/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.db;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.FileDeleteStrategy;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.db.DAO;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.MetadataTable;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.db.ProductTable;

public class ProductDB
extends DAO {
    private ProductTable productTable;
    private MetadataTable metadataTable;
    private static ProductDB _instance = null;
    public static final String DEFAULT_PRODUCT_DATABASE_NAME = "productDB";
    private static final String strGetProductsWhere = "SELECT * FROM APP.PRODUCTS, APP.METADATA WHERE APP.PRODUCTS.ID = APP.METADATA.ID AND ";

    public static ProductDB instance() throws Exception {
        if (_instance == null) {
            _instance = ProductDB.createDefaultInstance();
            ProductDB.initializeInstance();
        }
        return _instance;
    }

    private static ProductDB createDefaultInstance() throws IOException {
        Properties properties = new Properties();
        properties.put("user", "nestuser");
        properties.put("password", "snapuser");
        properties.put("derby.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        properties.put("derby.url", "jdbc:derby:");
        properties.put("db.table", "PRODUCTS");
        properties.put("db.schema", "APP");
        return new ProductDB(properties);
    }

    private static void initializeInstance() throws Exception {
        boolean connected = _instance.connect();
        if (!connected) {
            String dbLocation = _instance.getDatabaseLocation();
            ProductDB.deleteInstance();
            File dbFolder = new File(dbLocation);
            File qlFolder = new File(dbFolder.getParentFile(), "QuickLooks");
            boolean deleted = FileDeleteStrategy.FORCE.deleteQuietly(dbFolder);
            deleted = FileDeleteStrategy.FORCE.deleteQuietly(qlFolder);
            _instance = ProductDB.createDefaultInstance();
            connected = _instance.connect();
            if (!connected) {
                throw new Exception("Unable to connect to database\n" + _instance.getLastSQLException().getMessage());
            }
        }
    }

    public static void deleteInstance() {
        _instance.disconnect();
        _instance = null;
    }

    private ProductDB(Properties dbProperties) throws IOException {
        super(DEFAULT_PRODUCT_DATABASE_NAME, dbProperties);
    }

    public boolean isReady() {
        return this.productTable != null;
    }

    @Override
    protected boolean createTables(Connection connection) throws SQLException {
        this.productTable = new ProductTable(connection);
        this.productTable.createTable();
        this.metadataTable = new MetadataTable(connection);
        this.metadataTable.createTable();
        return true;
    }

    @Override
    protected void validateTables(Connection connection) throws SQLException {
        if (this.productTable == null) {
            this.productTable = new ProductTable(connection);
        }
        if (this.metadataTable == null) {
            this.metadataTable = new MetadataTable(connection);
        }
        this.productTable.validateTable();
        this.metadataTable.validateTable();
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.productTable.prepareStatements();
        this.metadataTable.prepareStatements();
    }

    public boolean pathExistsInDB(File path) throws SQLException {
        return this.productTable.pathExists(path);
    }

    public ProductEntry getProductEntry(File path) throws SQLException {
        return this.productTable.getProductEntry(path);
    }

    public ProductEntry[] getProductEntryInPath(File baseDir) throws SQLException {
        String queryStr = "PATH LIKE '" + baseDir.getAbsolutePath() + "%'";
        return this.queryProduct(queryStr);
    }

    public MetadataElement getProductMetadata(int id) throws SQLException {
        return this.metadataTable.getProductMetadata(id);
    }

    public ProductEntry saveProduct(Product product) throws SQLException {
        ProductEntry newEntry = new ProductEntry(product);
        if (!this.productTable.pathExists(newEntry.getFile())) {
            this.addRecord(newEntry);
        }
        return newEntry;
    }

    private void addRecord(ProductEntry record) throws SQLException {
        ResultSet results = this.productTable.addRecord(record);
        if (results.next()) {
            int id = results.getInt(1);
            record.setId(id);
            this.metadataTable.addRecord(record);
        }
    }

    public void cleanUpRemovedProducts(ProgressMonitor pm) throws SQLException {
        DBQuery dbQuery = new DBQuery();
        ProductEntry[] entries = dbQuery.queryDatabase(this);
        pm.beginTask("Cleaning up database...", entries.length);
        for (ProductEntry entry : entries) {
            if (!entry.getFile().exists()) {
                this.deleteProductEntry(entry);
            }
            pm.worked(1);
        }
        pm.done();
    }

    public void deleteProductEntry(ProductEntry entry) throws SQLException {
        this.deleteRecord(entry.getId());
    }

    private void deleteRecord(int id) throws SQLException {
        this.productTable.deleteRecord(id);
        this.metadataTable.deleteRecord(id);
    }

    public void removeProducts(File baseDir, ProgressMonitor pm) throws SQLException {
        String queryStr = "PATH LIKE '" + baseDir.getAbsolutePath() + "%'";
        ProductEntry[] list = this.queryProduct(queryStr);
        pm.beginTask("Removing products from database...", list.length);
        for (ProductEntry entry : list) {
            if (pm.isCanceled()) break;
            this.deleteProductEntry(entry);
            pm.worked(1);
        }
        pm.done();
    }

    public void removeAllProducts(ProgressMonitor pm) throws SQLException {
        String queryStr = "";
        ProductEntry[] list = this.queryProduct("");
        pm.beginTask("Removing products from database...", list.length);
        for (ProductEntry entry : list) {
            if (pm.isCanceled()) break;
            this.deleteProductEntry(entry);
            pm.worked(1);
        }
        pm.done();
    }

    public ProductEntry[] getProductEntryList(boolean validate) throws SQLException {
        if (!validate) {
            return this.productTable.getProductEntryList();
        }
        ProductEntry[] entries = this.productTable.getProductEntryList();
        ArrayList<ProductEntry> list = new ArrayList<ProductEntry>(entries.length);
        for (ProductEntry entry : entries) {
            if (entry.getFile().exists()) {
                list.add(entry);
                continue;
            }
            this.deleteRecord(entry.getId());
        }
        return list.toArray(new ProductEntry[list.size()]);
    }

    public ProductEntry[] queryProduct(String queryStr) throws SQLException {
        ArrayList<ProductEntry> listEntries = new ArrayList<ProductEntry>();
        try (Statement queryStatement = this.dbConnect.createStatement();){
            String whereStr = strGetProductsWhere;
            if (queryStr.isEmpty()) {
                whereStr = strGetProductsWhere.substring(0, strGetProductsWhere.lastIndexOf(" AND "));
            }
            ResultSet results = queryStatement.executeQuery(whereStr + queryStr);
            while (results.next()) {
                listEntries.add(new ProductEntry(results));
            }
            ProductEntry[] productEntryArray = listEntries.toArray(new ProductEntry[listEntries.size()]);
            return productEntryArray;
        }
    }

    public String[] getAllMissions() throws SQLException {
        if (this.productTable == null) {
            return new String[0];
        }
        return this.productTable.getAllMissions();
    }

    public String[] getAllProductTypes() throws SQLException {
        return this.productTable.getAllProductTypes();
    }

    public String[] getProductTypes(String[] missions) throws SQLException {
        return missions == null ? this.productTable.getAllProductTypes() : this.productTable.getProductTypes(missions);
    }

    public String[] getAllAcquisitionModes() throws SQLException {
        return this.productTable.getAllAcquisitionModes();
    }

    public String[] getAcquisitionModes(String[] missions) throws SQLException {
        return missions == null ? this.productTable.getAllAcquisitionModes() : this.productTable.getAcquisitionModes(missions);
    }

    public String[] getMetadataNames() {
        ProductDB productDB = this;
        return productDB.metadataTable.getAllMetadataNames();
    }
}

