/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.collocation.visat;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.collocation.CollocateOp;
import org.esa.snap.collocation.visat.CollocationForm;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.ui.AppContext;

class CollocationDialog
extends SingleTargetProductDialog {
    public static final String HELP_ID = "collocation";
    private final OperatorParameterSupport parameterSupport;
    private final CollocationForm form;

    public CollocationDialog(AppContext appContext) {
        super(appContext, "Collocation", 24, HELP_ID);
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(CollocateOp.Spi.class.getName());
        this.parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor());
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), operatorSpi.getOperatorDescriptor(), this.parameterSupport, appContext, HELP_ID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
        this.form = new CollocationForm(this.parameterSupport.getPropertySet(), this.getTargetProductSelector(), appContext);
    }

    protected Product createTargetProduct() throws Exception {
        HashMap<String, Product> productMap = new HashMap<String, Product>(5);
        productMap.put("master", this.form.getMasterProduct());
        productMap.put("slave", this.form.getSlaveProduct());
        return GPF.createProduct((String)OperatorSpi.getOperatorAlias(CollocateOp.class), (Map)this.parameterSupport.getParameterMap(), productMap);
    }

    public int show() {
        this.form.prepareShow();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareHide();
        super.hide();
    }
}

