/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import org.esa.snap.core.datamodel.ProductData;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class DataTypeUtils {
    public static boolean isValidRasterDataType(DataType dataType) {
        boolean unsigned = false;
        return DataTypeUtils.getRasterDataType(dataType, false) != -1;
    }

    public static int getRasterDataType(Variable variable) {
        return DataTypeUtils.getRasterDataType(variable.getDataType(), variable.isUnsigned());
    }

    public static int getRasterDataType(DataType dataType, boolean unsigned) {
        boolean rasterDataOnly = true;
        return DataTypeUtils.getEquivalentProductDataType(dataType, unsigned, true);
    }

    public static int getEquivalentProductDataType(DataType dataType, boolean unsigned, boolean rasterDataOnly) {
        if (DataType.BYTE.equals((Object)dataType)) {
            return unsigned ? 20 : 10;
        }
        if (DataType.SHORT.equals((Object)dataType)) {
            return unsigned ? 21 : 11;
        }
        if (DataType.INT.equals((Object)dataType)) {
            return unsigned ? 22 : 12;
        }
        if (DataType.LONG.equals((Object)dataType)) {
            return 13;
        }
        if (DataType.FLOAT.equals((Object)dataType)) {
            return 30;
        }
        if (DataType.DOUBLE.equals((Object)dataType)) {
            return 31;
        }
        if (!rasterDataOnly) {
            if (DataType.CHAR.equals((Object)dataType)) {
                return 41;
            }
            if (DataType.STRING.equals((Object)dataType)) {
                return 41;
            }
        }
        return -1;
    }

    public static DataType getNetcdfDataType(int dataType) {
        switch (dataType) {
            case 10: 
            case 20: {
                return DataType.BYTE;
            }
            case 11: 
            case 21: {
                return DataType.SHORT;
            }
            case 12: 
            case 22: {
                return DataType.INT;
            }
            case 13: {
                return DataType.LONG;
            }
            case 30: {
                return DataType.FLOAT;
            }
            case 31: {
                return DataType.DOUBLE;
            }
            case 41: {
                return DataType.STRING;
            }
            case 51: {
                return DataType.STRING;
            }
        }
        return null;
    }

    public static Number convertTo(double value, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return (byte)value;
            }
            case SHORT: {
                return (short)value;
            }
            case INT: {
                return (int)value;
            }
            case LONG: {
                return (long)value;
            }
            case FLOAT: {
                return Float.valueOf((float)value);
            }
            case DOUBLE: {
                return value;
            }
        }
        throw new IllegalArgumentException("Can not convert data type:" + dataType.name());
    }

    public static ProductData createProductData(Attribute attribute) {
        int productDataType = DataTypeUtils.getEquivalentProductDataType(attribute.getDataType(), false, false);
        ProductData attributeValue = productDataType == 41 ? ProductData.createInstance((String)attribute.getStringValue()) : ProductData.createInstance((int)productDataType, (Object)attribute.getValues().copyTo1DJavaArray());
        return attributeValue;
    }
}

