/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;

public abstract class AbstractNetcdfMultiLevelImage
extends MultiLevelImage {
    private final RasterDataNode rasterDataNode;
    private final int levelCount;
    private final RenderedImage[] levelImages;
    private MultiLevelModel multiLevelModel;

    protected AbstractNetcdfMultiLevelImage(RasterDataNode rasterDataNode) {
        super(ImageManager.createSingleBandedImageLayout((RasterDataNode)rasterDataNode), null, null);
        this.rasterDataNode = rasterDataNode;
        int width = rasterDataNode.getRasterWidth();
        int height = rasterDataNode.getRasterHeight();
        this.levelCount = DefaultMultiLevelModel.getLevelCount((int)width, (int)height);
        this.levelImages = new RenderedImage[this.levelCount];
    }

    protected RasterDataNode getRasterDataNode() {
        return this.rasterDataNode;
    }

    public synchronized MultiLevelModel getModel() {
        if (this.multiLevelModel == null) {
            this.multiLevelModel = AbstractNetcdfMultiLevelImage.createMultiLevelModel(this.rasterDataNode, this.levelCount);
        }
        return this.multiLevelModel;
    }

    public synchronized RenderedImage getImage(int level) {
        this.checkLevel(level);
        RenderedImage levelImage = this.levelImages[level];
        if (levelImage == null) {
            this.levelImages[level] = levelImage = this.createImage(level);
        }
        return levelImage;
    }

    protected abstract RenderedImage createImage(int var1);

    public Shape getImageShape(int level) {
        return null;
    }

    public void reset() {
        for (int level = 0; level < this.levelImages.length; ++level) {
            RenderedImage levelImage = this.levelImages[level];
            if (levelImage instanceof PlanarImage) {
                PlanarImage planarImage = (PlanarImage)levelImage;
                planarImage.dispose();
            }
            this.levelImages[level] = null;
        }
    }

    public void dispose() {
        this.reset();
        super.dispose();
    }

    private void checkLevel(int level) {
        if (level < 0 || level >= this.levelCount) {
            throw new IllegalArgumentException("level=" + level);
        }
    }

    private static MultiLevelModel createMultiLevelModel(RasterDataNode rasterDataNode, int levelCount) {
        int w = rasterDataNode.getRasterWidth();
        int h = rasterDataNode.getRasterHeight();
        AffineTransform i2mTransform = Product.findImageToModelTransform((GeoCoding)rasterDataNode.getGeoCoding());
        return new DefaultMultiLevelModel(levelCount, i2mTransform, w, h);
    }
}

