/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class CfFlagCodingPart
extends ProfilePartIO {
    private static final String FLAG_MASKS = "flag_masks";
    private static final String FLAG_MEANINGS = "flag_meanings";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        Band[] bands;
        for (Band band : bands = p.getBands()) {
            CfFlagCodingPart.writeFlagCoding(band, ctx.getNetcdfFileWriteable());
        }
    }

    public static void writeFlagCoding(Band band, NFileWriteable ncFile) throws IOException {
        FlagCoding flagCoding = band.getFlagCoding();
        if (flagCoding != null) {
            String[] flagNames = flagCoding.getFlagNames();
            ProductData flagValueData = ProductData.createInstance((int)band.getDataType(), (int)flagNames.length);
            StringBuilder meanings = new StringBuilder();
            for (int i = 0; i < flagValueData.getNumElems(); ++i) {
                if (meanings.length() > 0) {
                    meanings.append(" ");
                }
                String name = flagNames[i];
                meanings.append(name);
                flagValueData.setElemIntAt(i, flagCoding.getFlagMask(name));
            }
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            String description = flagCoding.getDescription();
            if (description != null) {
                ncFile.findVariable(variableName).addAttribute("long_name", description);
            }
            ncFile.findVariable(variableName).addAttribute(FLAG_MEANINGS, meanings.toString());
            Array maskValues = Array.factory(flagValueData.getElems());
            maskValues.setUnsigned(flagValueData.isUnsigned());
            ncFile.findVariable(variableName).addAttribute(FLAG_MASKS, maskValues);
        }
    }

    public static FlagCoding readFlagCoding(ProfileReadContext ctx, String variableName) {
        Variable variable = ctx.getNetcdfFile().getRootGroup().findVariable(variableName);
        String codingName = variableName + "_flag_coding";
        if (variable != null) {
            return CfFlagCodingPart.readFlagCoding(variable, codingName);
        }
        return null;
    }

    private static FlagCoding readFlagCoding(Variable variable, String codingName) {
        Attribute flagMeanings;
        int[] maskValues;
        Attribute flagMasks = variable.findAttribute(FLAG_MASKS);
        if (flagMasks != null) {
            Array flagMasksArray = flagMasks.getValues();
            flagMasksArray.setUnsigned(variable.isUnsigned());
            maskValues = new int[flagMasks.getLength()];
            for (int i = 0; i < maskValues.length; ++i) {
                maskValues[i] = flagMasksArray.getInt(i);
            }
        } else {
            maskValues = null;
        }
        String[] flagNames = (flagMeanings = variable.findAttribute(FLAG_MEANINGS)) != null ? flagMeanings.getStringValue().split(" ") : null;
        return CfFlagCodingPart.createFlagCoding(codingName, maskValues, flagNames);
    }

    private static FlagCoding createFlagCoding(String codingName, int[] maskValues, String[] flagNames) {
        if (maskValues != null && flagNames != null && maskValues.length == flagNames.length) {
            FlagCoding coding = new FlagCoding(codingName);
            for (int i = 0; i < maskValues.length; ++i) {
                String sampleName = CfFlagCodingPart.replaceNonWordCharacters(flagNames[i]);
                int sampleValue = maskValues[i];
                coding.addSample(sampleName, sampleValue, "");
            }
            if (coding.getNumAttributes() > 0) {
                return coding;
            }
        }
        return null;
    }

    static String replaceNonWordCharacters(String flagName) {
        return flagName.replaceAll("\\W+", "_");
    }
}

