/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamGeocodingPart
extends CfGeocodingPart {
    public static final String TIEPOINT_COORDINATES = "tiepoint_coordinates";
    private static final int LON_INDEX = 0;
    private static final int LAT_INDEX = 1;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        Attribute tpCoordinatesAtt = netcdfFile.findGlobalAttribute(TIEPOINT_COORDINATES);
        GeoCoding geoCoding = null;
        if (tpCoordinatesAtt != null) {
            String[] tpGridNames = tpCoordinatesAtt.getStringValue().split(" ");
            if (tpGridNames.length == 2 && p.containsTiePointGrid(tpGridNames[0]) && p.containsTiePointGrid(tpGridNames[1])) {
                TiePointGrid lon = p.getTiePointGrid(tpGridNames[0]);
                TiePointGrid lat = p.getTiePointGrid(tpGridNames[1]);
                geoCoding = new TiePointGeoCoding(lat, lon);
            }
        } else {
            Variable crsVar = netcdfFile.getRootGroup().findVariable("crs");
            if (crsVar != null) {
                Attribute wktAtt = crsVar.findAttribute("wkt");
                Attribute i2mAtt = crsVar.findAttribute("i2m");
                if (wktAtt != null && i2mAtt != null) {
                    geoCoding = this.createGeoCodingFromWKT(p, wktAtt.getStringValue(), i2mAtt.getStringValue());
                }
            }
        }
        if (geoCoding != null) {
            p.setSceneGeoCoding(geoCoding);
        } else {
            super.decode(ctx, p);
        }
    }

    private GeoCoding createGeoCodingFromWKT(Product p, String wktString, String i2mString) {
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)wktString);
            String[] parameters = StringUtils.csvToArray((String)i2mString);
            double[] matrix = new double[parameters.length];
            for (int i = 0; i < matrix.length; ++i) {
                matrix[i] = Double.valueOf(parameters[i]);
            }
            AffineTransform i2m = new AffineTransform(matrix);
            Rectangle imageBounds = new Rectangle(p.getSceneRasterWidth(), p.getSceneRasterHeight());
            return new CrsGeoCoding(crs, imageBounds, i2m);
        }
        catch (FactoryException factoryException) {
        }
        catch (TransformException transformException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        super.preEncode(ctx, p);
        GeoCoding geoCoding = p.getSceneGeoCoding();
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tpGC = (TiePointGeoCoding)geoCoding;
            String[] names = new String[]{tpGC.getLonGrid().getName(), tpGC.getLatGrid().getName()};
            String value = StringUtils.arrayToString((Object)names, (String)" ");
            ctx.getNetcdfFileWriteable().addGlobalAttribute(TIEPOINT_COORDINATES, value);
        } else if (geoCoding instanceof CrsGeoCoding) {
            this.addWktAsVariable(ctx.getNetcdfFileWriteable(), geoCoding);
        }
    }

    private void addWktAsVariable(NFileWriteable ncFile, GeoCoding geoCoding) throws IOException {
        CoordinateReferenceSystem crs = geoCoding.getMapCRS();
        double[] matrix = new double[6];
        MathTransform transform = geoCoding.getImageToMapTransform();
        if (transform instanceof AffineTransform) {
            ((AffineTransform)transform).getMatrix(matrix);
        }
        NVariable crsVariable = ncFile.addScalarVariable("crs", DataType.INT);
        crsVariable.addAttribute("wkt", crs.toWKT());
        crsVariable.addAttribute("i2m", StringUtils.arrayToCsv((Object)matrix));
    }
}

