/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.worldmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.rcp.worldmap.Bundle;
import org.esa.snap.ui.WorldMapPane;
import org.esa.snap.ui.WorldMapPaneDataModel;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="WorldMapTopComponent", iconBase="org/esa/snap/rcp/icons/WorldMap.gif", persistenceType=0)
public class WorldMapTopComponent
extends ToolTopComponent {
    public static final String ID = WorldMapTopComponent.class.getName();
    protected WorldMapPaneDataModel worldMapDataModel;

    public WorldMapTopComponent() {
        this.setDisplayName(Bundle.CTL_WorldMapTopComponent_Name());
        this.initUI();
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setPreferredSize(new Dimension(320, 160));
        this.worldMapDataModel = new WorldMapPaneDataModel();
        WorldMapPane worldMapPane = new WorldMapPane(this.worldMapDataModel);
        worldMapPane.setNavControlVisible(true);
        mainPane.add((Component)worldMapPane, "Center");
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)new WorldMapProductManagerListener());
        snapApp.getSelectionSupport(ProductNode.class).addHandler(new SelectionSupport.Handler<ProductNode>(){

            @Override
            public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                if (newValue != null) {
                    WorldMapTopComponent.this.setSelectedProduct(newValue.getProduct());
                }
            }
        });
        this.setProducts(snapApp.getProductManager().getProducts());
        this.setSelectedProduct(snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.VIEW));
        this.add(mainPane, "Center");
    }

    public void setSelectedProduct(Product product) {
        this.worldMapDataModel.setSelectedProduct(product);
    }

    public Product getSelectedProduct() {
        return this.worldMapDataModel.getSelectedProduct();
    }

    public void setProducts(Product[] products) {
        this.worldMapDataModel.setProducts(products);
    }

    @Override
    protected void productSceneViewSelected(@NonNull ProductSceneView view) {
        this.setSelectedProduct(view.getProduct());
    }

    private class WorldMapProductManagerListener
    implements ProductManager.Listener {
        private WorldMapProductManagerListener() {
        }

        public void productAdded(ProductManager.Event event) {
            Product product = event.getProduct();
            WorldMapTopComponent.this.worldMapDataModel.addProduct(product);
            WorldMapTopComponent.this.setSelectedProduct(product);
        }

        public void productRemoved(ProductManager.Event event) {
            Product product = event.getProduct();
            if (WorldMapTopComponent.this.getSelectedProduct() == product) {
                WorldMapTopComponent.this.setSelectedProduct(null);
            }
            WorldMapTopComponent.this.worldMapDataModel.removeProduct(product);
        }
    }
}

