/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.status;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.awt.StatusLineElementProvider;

public class PixelPosStatusLineElementProvider
implements StatusLineElementProvider,
DocumentWindowManager.Listener<Object, ProductSceneView>,
PixelPositionListener,
PreferenceChangeListener {
    private static final String GEO_POS_FORMAT = "Lat %8s  Lon %8s";
    private static final String PIXEL_POS_FORMAT = "X %6s  Y %6s";
    private static final String ZOOM_LEVEL_FORMAT = "Zoom %s  Level %s";
    private final JLabel zoomLevelLabel;
    private final JLabel geoPosLabel;
    private final JLabel pixelPosLabel;
    private final JPanel panel;
    private boolean showPixelOffsetDecimals;
    private boolean showGeoPosOffsetDecimals;

    public PixelPosStatusLineElementProvider() {
        DocumentWindowManager.getDefault().addListener(DocumentWindowManager.Predicate.view(ProductSceneView.class), (DocumentWindowManager.Listener)this);
        SnapApp.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.updateSettings();
        this.pixelPosLabel = new JLabel();
        this.pixelPosLabel.setPreferredSize(new Dimension(120, 20));
        this.pixelPosLabel.setHorizontalAlignment(0);
        this.geoPosLabel = new JLabel();
        this.geoPosLabel.setPreferredSize(new Dimension(200, 20));
        this.geoPosLabel.setHorizontalAlignment(0);
        this.zoomLevelLabel = new JLabel();
        this.zoomLevelLabel.setPreferredSize(new Dimension(150, 20));
        this.zoomLevelLabel.setHorizontalAlignment(0);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 2));
        this.panel.add(Box.createHorizontalGlue());
        this.panel.add(new JSeparator(1));
        this.panel.add(this.pixelPosLabel);
        this.panel.add(new JSeparator(1));
        this.panel.add(this.geoPosLabel);
        this.panel.add(new JSeparator(1));
        this.panel.add(this.zoomLevelLabel);
    }

    public Component getStatusLineElement() {
        return this.panel;
    }

    public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
        if (pixelPosValid) {
            String scaleStr;
            AffineTransform i2mTransform = imageLayer.getImageToModelTransform(currentLevel);
            Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
            AffineTransform m2iTransform = imageLayer.getModelToImageTransform();
            Point2D imageP = m2iTransform.transform(modelP, null);
            PixelPos pixelPos = new PixelPos(imageP.getX(), imageP.getY());
            ProductSceneView productSceneView = SnapApp.getDefault().getSelectedProductSceneView();
            if (productSceneView == null) {
                this.setDefault();
                return;
            }
            RasterDataNode rasterDataNode = productSceneView.getRaster();
            if (rasterDataNode == null) {
                this.setDefault();
                return;
            }
            GeoCoding geoCoding = rasterDataNode.getGeoCoding();
            if (geoCoding == null) {
                this.setDefault();
                return;
            }
            GeoPos geoPos = geoCoding.getGeoPos(pixelPos, null);
            if (this.showGeoPosOffsetDecimals) {
                this.geoPosLabel.setText(String.format("Lat %.5f  Lon %.5f", geoPos.getLat(), geoPos.getLon()));
            } else {
                this.geoPosLabel.setText(String.format(GEO_POS_FORMAT, geoPos.getLatString(), geoPos.getLonString()));
            }
            if (this.showPixelOffsetDecimals) {
                this.pixelPosLabel.setText(String.format(PIXEL_POS_FORMAT, imageP.getX(), imageP.getY()));
            } else {
                this.pixelPosLabel.setText(String.format(PIXEL_POS_FORMAT, (int)Math.floor(imageP.getX()), (int)Math.floor(imageP.getY())));
            }
            LayerCanvas layerCanvas = (LayerCanvas)e.getSource();
            double zoomFactor = layerCanvas.getViewport().getZoomFactor();
            if (zoomFactor > 1.0) {
                double v = (double)Math.round(10.0 * zoomFactor) / 10.0;
                scaleStr = ((double)((int)v) == v ? (double)((int)v) : v) + ":1";
            } else {
                double v = (double)Math.round(10.0 / zoomFactor) / 10.0;
                scaleStr = "1:" + ((double)((int)v) == v ? (double)((int)v) : v);
            }
            this.zoomLevelLabel.setText(String.format(ZOOM_LEVEL_FORMAT, scaleStr, currentLevel));
        } else {
            this.setDefault();
        }
    }

    private void setDefault() {
        this.geoPosLabel.setText(String.format(GEO_POS_FORMAT, "--", "--"));
        this.pixelPosLabel.setText(String.format(PIXEL_POS_FORMAT, "--", "--"));
        this.zoomLevelLabel.setText(String.format(ZOOM_LEVEL_FORMAT, "--", "--"));
    }

    public void pixelPosNotAvailable() {
        this.setDefault();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String propertyName = evt.getKey();
        if ("pixelview.showPixelPosDecimals".equals(propertyName) || "pixelview.showGeoPosDecimals".equals(propertyName)) {
            this.updateSettings();
        }
    }

    public void windowSelected(DocumentWindowManager.Event<Object, ProductSceneView> e) {
        ProductSceneView view = (ProductSceneView)e.getWindow().getView();
        view.addPixelPositionListener((PixelPositionListener)this);
    }

    public void windowDeselected(DocumentWindowManager.Event<Object, ProductSceneView> e) {
        ProductSceneView view = (ProductSceneView)e.getWindow().getView();
        view.removePixelPositionListener((PixelPositionListener)this);
    }

    private void updateSettings() {
        Preferences preferences = SnapApp.getDefault().getPreferences();
        this.showPixelOffsetDecimals = preferences.getBoolean("pixelview.showPixelPosDecimals", false);
        this.showGeoPosOffsetDecimals = preferences.getBoolean("pixelview.showGeoPosDecimals", false);
    }
}

