/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.validators.IntervalValidator;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.media.jai.Histogram;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.statistics.ExportStatisticsAsCsvAction;
import org.esa.snap.rcp.statistics.MultipleRoiComputePanel;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.rcp.statistics.PutStatisticsIntoVectorDataAction;
import org.esa.snap.rcp.statistics.StatisticsDataProvider;
import org.esa.snap.rcp.statistics.TitledSeparator;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.statistics.output.Util;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XIntervalSeries;
import org.jfree.data.xy.XIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;
import org.openide.windows.TopComponent;

class StatisticsPanel
extends PagePanel
implements MultipleRoiComputePanel.ComputeMasks,
StatisticsDataProvider {
    private static final String DEFAULT_STATISTICS_TEXT = "No statistics computed yet.";
    private static final String TITLE_PREFIX = "Statistics";
    private MultipleRoiComputePanel computePanel;
    private JPanel backgroundPanel;
    private AbstractButton hideAndShowButton;
    private AbstractButton exportButton;
    private JPanel contentPanel;
    private final PopupHandler popupHandler;
    private final StringBuilder resultText;
    private boolean init;
    private Histogram[] histograms;
    private ExportStatisticsAsCsvAction exportAsCsvAction;
    private PutStatisticsIntoVectorDataAction putStatisticsIntoVectorDataAction;
    private AccuracyModel accuracyModel;

    public StatisticsPanel(TopComponent parentDialog, String helpID) {
        super(parentDialog, helpID, TITLE_PREFIX);
        this.setMinimumSize(new Dimension(1000, 390));
        this.resultText = new StringBuilder();
        this.popupHandler = new PopupHandler();
    }

    @Override
    protected void initComponents() {
        this.init = true;
        this.computePanel = new MultipleRoiComputePanel(this, this.getRaster());
        this.exportButton = this.getExportButton();
        JPanel exportAndHelpPanel = GridBagUtils.createPanel();
        GridBagConstraints helpPanelConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2,weightx=1,ipadx=0");
        GridBagUtils.addToPanel((JPanel)exportAndHelpPanel, (Component)new JSeparator(), (GridBagConstraints)helpPanelConstraints, (String)"fill=HORIZONTAL,gridwidth=2,insets.left=5,insets.right=5");
        GridBagUtils.addToPanel((JPanel)exportAndHelpPanel, (Component)this.exportButton, (GridBagConstraints)helpPanelConstraints, (String)"gridy=1,anchor=WEST,fill=NONE");
        GridBagUtils.addToPanel((JPanel)exportAndHelpPanel, (Component)this.getHelpButton(), (GridBagConstraints)helpPanelConstraints, (String)"gridx=1,gridy=1,anchor=EAST,fill=NONE");
        final JPanel rightPanel = GridBagUtils.createPanel();
        GridBagConstraints extendedOptionsPanelConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2,weightx=1,insets.right=-2");
        GridBagUtils.addToPanel((JPanel)rightPanel, (Component)this.computePanel, (GridBagConstraints)extendedOptionsPanelConstraints, (String)"gridy=0,fill=BOTH,weighty=1");
        GridBagUtils.addToPanel((JPanel)rightPanel, (Component)this.createAccuracyPanel(), (GridBagConstraints)extendedOptionsPanelConstraints, (String)"gridy=1,fill=BOTH,weighty=1");
        GridBagUtils.addToPanel((JPanel)rightPanel, (Component)exportAndHelpPanel, (GridBagConstraints)extendedOptionsPanelConstraints, (String)"gridy=2,anchor=SOUTHWEST,fill=HORIZONTAL,weighty=0");
        final ImageIcon collapseIcon = UIUtils.loadImageIcon((String)"icons/PanelRight12.png");
        final ImageIcon collapseRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)collapseIcon);
        final ImageIcon expandIcon = UIUtils.loadImageIcon((String)"icons/PanelLeft12.png");
        final ImageIcon expandRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)expandIcon);
        this.hideAndShowButton = ToolButtonFactory.createButton((Icon)collapseIcon, (boolean)false);
        this.hideAndShowButton.setToolTipText("Collapse Options Panel");
        this.hideAndShowButton.setName("switchToChartButton");
        this.hideAndShowButton.addActionListener(new ActionListener(){
            private boolean rightPanelShown;

            @Override
            public void actionPerformed(ActionEvent e) {
                rightPanel.setVisible(this.rightPanelShown);
                if (this.rightPanelShown) {
                    StatisticsPanel.this.hideAndShowButton.setIcon(collapseIcon);
                    StatisticsPanel.this.hideAndShowButton.setRolloverIcon(collapseRolloverIcon);
                    StatisticsPanel.this.hideAndShowButton.setToolTipText("Collapse Options Panel");
                } else {
                    StatisticsPanel.this.hideAndShowButton.setIcon(expandIcon);
                    StatisticsPanel.this.hideAndShowButton.setRolloverIcon(expandRolloverIcon);
                    StatisticsPanel.this.hideAndShowButton.setToolTipText("Expand Options Panel");
                }
                this.rightPanelShown = !this.rightPanelShown;
            }
        });
        this.contentPanel = new JPanel(new GridLayout(-1, 1));
        this.contentPanel.setBackground(Color.WHITE);
        this.contentPanel.addMouseListener(this.popupHandler);
        JScrollPane contentScrollPane = new JScrollPane(this.contentPanel);
        contentScrollPane.setBorder(null);
        contentScrollPane.setBackground(Color.WHITE);
        this.backgroundPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagUtils.addToPanel((JPanel)this.backgroundPanel, (Component)contentScrollPane, (GridBagConstraints)gbc, (String)"fill=BOTH, weightx=1.0, weighty=1.0, anchor=NORTH");
        GridBagUtils.addToPanel((JPanel)this.backgroundPanel, (Component)rightPanel, (GridBagConstraints)gbc, (String)"gridx=1, fill=VERTICAL, weightx=0.0");
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add(this.backgroundPanel);
        layeredPane.add(this.hideAndShowButton);
        this.add(layeredPane);
    }

    private JPanel createAccuracyPanel() {
        JPanel accuracyPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        final JLabel label = new JLabel("Histogram accuracy:");
        this.accuracyModel = new AccuracyModel();
        final BindingContext bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.accuracyModel));
        SpinnerNumberModel accuracyNumberModel = new SpinnerNumberModel(this.accuracyModel.accuracy, 0, 6, 1);
        final JSpinner accuracySpinner = new JSpinner(accuracyNumberModel);
        ((JSpinner.DefaultEditor)accuracySpinner.getEditor()).getTextField().setEditable(false);
        bindingContext.bind("accuracy", accuracySpinner);
        final JCheckBox checkBox = new JCheckBox("Auto accuracy");
        bindingContext.bind("useAutoAccuracy", checkBox);
        IntervalValidator rangeValidator = new IntervalValidator(new ValueRange(0.0, 6.0));
        PropertyDescriptor accuracyDescriptor = bindingContext.getPropertySet().getDescriptor("accuracy");
        accuracyDescriptor.setValidator((Validator)rangeValidator);
        checkBox.setSelected(this.accuracyModel.useAutoAccuracy);
        bindingContext.getPropertySet().getProperty("useAutoAccuracy").addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                label.setEnabled(!checkBox.isSelected());
                accuracySpinner.setEnabled(!checkBox.isSelected());
                if (checkBox.isSelected()) {
                    bindingContext.getBinding("accuracy").setPropertyValue((Object)3);
                }
                StatisticsPanel.this.computePanel.updateEnablement();
            }
        });
        label.setEnabled(false);
        accuracySpinner.setEnabled(false);
        accuracySpinner.setToolTipText("Specify the number of histogram bins (#bins: 10^accuracy).");
        accuracySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StatisticsPanel.this.computePanel.updateEnablement();
            }
        });
        GridBagUtils.addToPanel((JPanel)accuracyPanel, (Component)new TitledSeparator("Histogram accuracy"), (GridBagConstraints)gbc, (String)"fill=HORIZONTAL, weightx=1.0,anchor=NORTH,gridwidth=2");
        GridBagUtils.addToPanel((JPanel)accuracyPanel, (Component)checkBox, (GridBagConstraints)gbc, (String)"gridy=1,insets.left=5,insets.top=2");
        GridBagUtils.addToPanel((JPanel)accuracyPanel, (Component)label, (GridBagConstraints)gbc, (String)"gridy=2, insets.left=26,weightx=0.0,fill=NONE,anchor=WEST,gridwidth=1");
        GridBagUtils.addToPanel((JPanel)accuracyPanel, (Component)accuracySpinner, (GridBagConstraints)gbc, (String)"gridx=1,weightx=1.0,fill=HORIZONTAL,insets.right=5,insets.left=5");
        return accuracyPanel;
    }

    @Override
    protected void updateComponents() {
        if (!this.init) {
            this.initComponents();
        }
        RasterDataNode raster = this.getRaster();
        this.computePanel.setRaster(raster);
        this.contentPanel.removeAll();
        this.resultText.setLength(0);
        if (raster != null && raster.isStxSet() && raster.getStx().getResolutionLevel() == 0) {
            this.resultText.append(this.createText(raster.getStx(), null));
            this.contentPanel.add(this.createStatPanel(raster.getStx(), null));
            this.histograms = new Histogram[]{raster.getStx().getHistogram()};
            this.exportAsCsvAction = new ExportStatisticsAsCsvAction(this);
            this.putStatisticsIntoVectorDataAction = new PutStatisticsIntoVectorDataAction(this);
            this.exportButton.setEnabled(true);
        } else {
            this.contentPanel.add(new JLabel(DEFAULT_STATISTICS_TEXT));
            this.exportButton.setEnabled(false);
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    @Override
    public Histogram[] getHistograms() {
        return this.histograms;
    }

    @Override
    public void compute(final Mask[] selectedMasks) {
        this.histograms = new Histogram[selectedMasks.length];
        String title = "Computing Statistics";
        ProgressMonitorSwingWorker<Object, ComputeResult> swingWorker = new ProgressMonitorSwingWorker<Object, ComputeResult>((Component)this, "Computing Statistics"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground(ProgressMonitor pm) {
                pm.beginTask("Computing Statistics", selectedMasks.length);
                try {
                    int binCount = Util.computeBinCount((int)StatisticsPanel.this.accuracyModel.accuracy);
                    for (int i = 0; i < selectedMasks.length; ++i) {
                        Stx stx;
                        Mask mask = selectedMasks[i];
                        ProgressMonitor subPm = SubProgressMonitor.create((ProgressMonitor)pm, (int)1);
                        if (mask == null) {
                            stx = new StxFactory().withHistogramBinCount(Integer.valueOf(binCount)).create(StatisticsPanel.this.getRaster(), subPm);
                            StatisticsPanel.this.getRaster().setStx(stx);
                        } else {
                            stx = new StxFactory().withHistogramBinCount(Integer.valueOf(binCount)).withRoiMask(mask).create(StatisticsPanel.this.getRaster(), subPm);
                        }
                        ((StatisticsPanel)StatisticsPanel.this).histograms[i] = stx.getHistogram();
                        this.publish(new ComputeResult[]{new ComputeResult(stx, mask)});
                    }
                }
                finally {
                    pm.done();
                }
                return null;
            }

            protected void process(List<ComputeResult> chunks) {
                for (ComputeResult result : chunks) {
                    Stx stx = result.stx;
                    Mask mask = result.mask;
                    if (StatisticsPanel.this.resultText.length() > 0) {
                        StatisticsPanel.this.resultText.append("\n");
                    }
                    StatisticsPanel.this.resultText.append(StatisticsPanel.this.createText(stx, mask));
                    JPanel statPanel = StatisticsPanel.this.createStatPanel(stx, mask);
                    StatisticsPanel.this.contentPanel.add(statPanel);
                    StatisticsPanel.this.contentPanel.revalidate();
                    StatisticsPanel.this.contentPanel.repaint();
                }
            }

            protected void done() {
                try {
                    this.get();
                    if (StatisticsPanel.this.exportAsCsvAction == null) {
                        StatisticsPanel.this.exportAsCsvAction = new ExportStatisticsAsCsvAction(StatisticsPanel.this);
                    }
                    StatisticsPanel.this.exportAsCsvAction.setSelectedMasks(selectedMasks);
                    if (StatisticsPanel.this.putStatisticsIntoVectorDataAction == null) {
                        StatisticsPanel.this.putStatisticsIntoVectorDataAction = new PutStatisticsIntoVectorDataAction(StatisticsPanel.this);
                    }
                    StatisticsPanel.this.putStatisticsIntoVectorDataAction.setSelectedMasks(selectedMasks);
                    StatisticsPanel.this.exportButton.setEnabled(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Dialogs.showMessage("<html>Statistics", "Failed to compute statistics.<br/>An error occurred:" + e.getMessage() + "</html>", 0, null);
                }
            }
        };
        this.resultText.setLength(0);
        this.contentPanel.removeAll();
        swingWorker.execute();
    }

    private JPanel createStatPanel(Stx stx, Mask mask) {
        Histogram histogram = stx.getHistogram();
        XIntervalSeries histogramSeries = new XIntervalSeries((Comparable)((Object)"Histogram"));
        int[] bins = histogram.getBins(0);
        for (int j = 0; j < bins.length; ++j) {
            histogramSeries.add(histogram.getBinLowValue(0, j), histogram.getBinLowValue(0, j), j < bins.length - 1 ? histogram.getBinLowValue(0, j + 1) : histogram.getHighValue(0), (double)bins[j]);
        }
        ChartPanel histogramPanel = StatisticsPanel.createChartPanel(histogramSeries, "Value", "#Pixels", new Color(0, 0, 127));
        XIntervalSeries percentileSeries = new XIntervalSeries((Comparable)((Object)"Percentile"));
        percentileSeries.add(0.0, 0.0, 1.0, histogram.getLowValue(0));
        for (int j = 1; j < 99; ++j) {
            percentileSeries.add((double)j, (double)j, (double)(j + 1), histogram.getPTileThreshold((double)j / 100.0)[0]);
        }
        percentileSeries.add(99.0, 99.0, 100.0, histogram.getHighValue(0));
        ChartPanel percentilePanel = StatisticsPanel.createChartPanel(percentileSeries, "Percentile (%)", "Value Threshold", new Color(127, 0, 0));
        Object[][] tableData = new Object[][]{{"#Pixels total:", histogram.getTotals()[0]}, {"Minimum:", stx.getMinimum()}, {"Maximum:", stx.getMaximum()}, {"Mean:", stx.getMean()}, {"Sigma:", stx.getStandardDeviation()}, {"Median:", stx.getMedian()}, {"Coef Variation:", stx.getCoefficientOfVariation()}, {"ENL:", stx.getEquivalentNumberOfLooks()}, {"P75 threshold:", histogram.getPTileThreshold(0.75)[0]}, {"P80 threshold:", histogram.getPTileThreshold(0.8)[0]}, {"P85 threshold:", histogram.getPTileThreshold(0.85)[0]}, {"P90 threshold:", histogram.getPTileThreshold(0.9)[0]}, {"Max error:", StatisticsPanel.getBinSize(histogram)}};
        JPanel plotContainerPanel = new JPanel(new GridLayout(1, 2));
        plotContainerPanel.add((Component)histogramPanel);
        plotContainerPanel.add((Component)percentilePanel);
        DefaultTableModel tableModel = new DefaultTableModel(tableData, new String[]{"Name", "Value"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex == 0 ? String.class : Number.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        JTable table = new JTable(tableModel);
        table.setDefaultRenderer(Number.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component label = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Float || value instanceof Double) {
                    this.setHorizontalTextPosition(4);
                    this.setText(this.getFormattedValue((Number)value));
                }
                return label;
            }

            private String getFormattedValue(Number value) {
                if (value.doubleValue() < 0.001 && value.doubleValue() > -0.001 && value.doubleValue() != 0.0) {
                    return new DecimalFormat("0.####E0").format(value.doubleValue());
                }
                return String.format("%.4f", value.doubleValue());
            }
        });
        table.addMouseListener(this.popupHandler);
        JPanel textContainerPanel = new JPanel(new BorderLayout(2, 2));
        textContainerPanel.setBackground(Color.WHITE);
        textContainerPanel.add((Component)table, "Center");
        JPanel statPanel = new JPanel(new BorderLayout(4, 4));
        statPanel.setBorder(new EmptyBorder(10, 2, 10, 2));
        statPanel.setBackground(Color.WHITE);
        statPanel.add((Component)new JLabel(this.getSubPanelTitle(mask)), "North");
        statPanel.add((Component)textContainerPanel, "West");
        statPanel.add((Component)plotContainerPanel, "Center");
        return statPanel;
    }

    static double getBinSize(Histogram histogram) {
        return (histogram.getHighValue(0) - histogram.getLowValue(0)) / (double)histogram.getNumBins(0);
    }

    private String getSubPanelTitle(Mask mask) {
        String title = mask != null ? String.format("<html><b>%s</b> with ROI-mask <b>%s</b></html>", this.getRaster().getName(), mask.getName()) : String.format("<html><b>%s</b></html>", this.getRaster().getName());
        return title;
    }

    @Override
    protected String getDataAsText() {
        return this.resultText.toString();
    }

    private String createText(Stx stx, Mask mask) {
        if (stx.getSampleCount() == 0L) {
            if (mask != null) {
                return "The ROI-Mask '" + mask.getName() + "' is empty.";
            }
            return "The scene contains no valid pixels.";
        }
        RasterDataNode raster = this.getRaster();
        boolean maskUsed = mask != null;
        String unit = StringUtils.isNotNullAndNotEmpty((String)raster.getUnit()) ? raster.getUnit() : "1";
        long numPixelTotal = (long)raster.getRasterWidth() * (long)raster.getRasterHeight();
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Only ROI-mask pixels considered:\t");
        sb.append(maskUsed ? "Yes" : "No");
        sb.append("\n");
        if (maskUsed) {
            sb.append("ROI-mask name:\t");
            sb.append(mask.getName());
            sb.append("\n");
        }
        sb.append("Number of pixels total:\t");
        sb.append(numPixelTotal);
        sb.append("\n");
        sb.append("Number of considered pixels:\t");
        sb.append(stx.getSampleCount());
        sb.append("\n");
        sb.append("Ratio of considered pixels:\t");
        sb.append(100.0 * (double)stx.getSampleCount() / (double)numPixelTotal);
        sb.append("\t");
        sb.append("%");
        sb.append("\n");
        sb.append("Minimum:\t");
        sb.append(stx.getMinimum());
        sb.append("\t");
        sb.append(unit);
        sb.append("\n");
        sb.append("Maximum:\t");
        sb.append(stx.getMaximum());
        sb.append("\t");
        sb.append(unit);
        sb.append("\n");
        sb.append("Mean:\t");
        sb.append(stx.getMean());
        sb.append("\t");
        sb.append(unit);
        sb.append("\n");
        sb.append("Standard deviation:\t");
        sb.append(stx.getStandardDeviation());
        sb.append("\t");
        sb.append(unit);
        sb.append("\n");
        sb.append("Coefficient of variation:\t");
        sb.append(this.getCoefficientOfVariation(stx));
        sb.append("\t");
        sb.append("");
        sb.append("\n");
        sb.append("Median:\t");
        sb.append(stx.getMedian());
        sb.append("\t ");
        sb.append(unit);
        sb.append("\n");
        for (int percentile = 5; percentile <= 95; percentile += 5) {
            sb.append("P").append(percentile).append(" threshold:\t");
            sb.append(stx.getHistogram().getPTileThreshold((double)percentile / 100.0)[0]);
            sb.append("\t");
            sb.append(unit);
            sb.append("\n");
        }
        sb.append("Threshold max error:\t");
        sb.append(StatisticsPanel.getBinSize(stx.getHistogram()));
        sb.append("\t");
        sb.append(unit);
        sb.append("\n");
        return sb.toString();
    }

    private double getCoefficientOfVariation(Stx stx) {
        return stx.getStandardDeviation() / stx.getMean();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.backgroundPanel.setBounds(0, 0, this.getWidth() - 8, this.getHeight() - 8);
        this.hideAndShowButton.setBounds(this.getWidth() - this.hideAndShowButton.getWidth() - 12, 6, 24, 24);
    }

    private static ChartPanel createChartPanel(XIntervalSeries percentileSeries, String xAxisLabel, String yAxisLabel, Color color) {
        XIntervalSeriesCollection percentileDataset = new XIntervalSeriesCollection();
        percentileDataset.addSeries(percentileSeries);
        return StatisticsPanel.getHistogramPlotPanel(percentileDataset, xAxisLabel, yAxisLabel, color);
    }

    private static ChartPanel getHistogramPlotPanel(XIntervalSeriesCollection dataset, String xAxisLabel, String yAxisLabel, Color color) {
        JFreeChart chart = ChartFactory.createHistogram(null, (String)xAxisLabel, (String)yAxisLabel, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.setNoDataMessage("No data");
        xyPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        XYBarRenderer renderer = (XYBarRenderer)xyPlot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setShadowVisible(false);
        renderer.setSeriesPaint(0, (Paint)color);
        StandardXYBarPainter painter = new StandardXYBarPainter();
        renderer.setBarPainter((XYBarPainter)painter);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(300, 200));
        return chartPanel;
    }

    private AbstractButton getExportButton() {
        final AbstractButton export = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Export24.gif"), (boolean)false);
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu viewPopup = new JPopupMenu("Export");
                viewPopup.add(StatisticsPanel.this.exportAsCsvAction);
                viewPopup.add(StatisticsPanel.this.putStatisticsIntoVectorDataAction);
                Rectangle buttonBounds = export.getBounds();
                viewPopup.show(export, 1, buttonBounds.height + 1);
            }
        });
        export.setEnabled(false);
        return export;
    }

    @Override
    public RasterDataNode getRasterDataNode() {
        return this.getRaster();
    }

    @Override
    public ProductNodeGroup<VectorDataNode> getVectorDataNodeGroup() {
        return this.getRasterDataNode().getProduct().getVectorDataGroup();
    }

    static class AccuracyModel {
        private int accuracy = 3;
        private boolean useAutoAccuracy = true;

        AccuracyModel() {
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 2 || e.isPopupTrigger()) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(StatisticsPanel.this.createCopyDataToClipboardMenuItem());
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class ComputeResult {
        final Stx stx;
        final Mask mask;

        ComputeResult(Stx stx, Mask mask) {
            this.stx = stx;
            this.mask = mask;
        }
    }
}

