/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.core.datamodel.TransectProfileDataBuilder;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.rcp.statistics.AxisRangeControl;
import org.esa.snap.rcp.statistics.ChartPagePanel;
import org.esa.snap.rcp.statistics.CorrelativeFieldSelector;
import org.esa.snap.rcp.statistics.MaskSelectionToolSupport;
import org.esa.snap.rcp.statistics.PlotAreaSelectionTool;
import org.esa.snap.rcp.statistics.ProfileDataTableModel;
import org.esa.snap.rcp.statistics.RoiMaskSelector;
import org.esa.snap.rcp.statistics.StatisticChartStyling;
import org.esa.snap.rcp.statistics.StatisticsUtils;
import org.esa.snap.rcp.statistics.TableViewPagePanel;
import org.esa.snap.rcp.statistics.XYPlotMarker;
import org.esa.snap.rcp.statistics.XYPlotToolTipGenerator;
import org.esa.snap.rcp.sync.DefaultCursorSynchronizer;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.GridBagUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.openide.windows.TopComponent;

class ProfilePlotPanel
extends ChartPagePanel {
    static final String CHART_TITLE = "Profile Plot";
    private static final String NO_DATA_MESSAGE = "No profile plot computed yet.\nIt will be computed if vector data (a polygon, an ellipse, or a line)\nis selected within the image view.\nFor more information about this plot\nhit the help button at the bottom right.\nTIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private static final String PROPERTY_NAME_MARK_SEGMENTS = "markSegments";
    private static final String PROPERTY_NAME_LOG_SCALED = "logScaled";
    private static final String DEFAULT_SAMPLE_DATASET_NAME = "Sample";
    private AxisRangeControl xAxisRangeControl;
    private AxisRangeControl yAxisRangeControl;
    private boolean isInitialized;
    private ChartPanel profilePlotDisplay;
    private JFreeChart chart;
    private XYIntervalSeriesCollection dataset;
    private TransectProfileData profileData;
    private boolean axisAdjusting = false;
    private Set<IntervalMarker> intervalMarkers;
    private CorrelativeFieldSelector correlativeFieldSelector;
    private DataSourceConfig dataSourceConfig;
    private DeviationRenderer deviationRenderer;
    private XYErrorRenderer pointRenderer;
    private Enablement pointDataSourceEnablement;
    private Enablement dataFieldEnablement;
    private DefaultCursorSynchronizer cursorSynchronizer;

    ProfilePlotPanel(TopComponent parentComponent, String helpId) {
        super(parentComponent, helpId, CHART_TITLE, false);
    }

    private ChartPanel createChartPanel(JFreeChart chart) {
        this.profilePlotDisplay = new ChartPanel(chart);
        MaskSelectionToolSupport maskSelectionToolSupport = new MaskSelectionToolSupport(this, this.profilePlotDisplay, "profile_plot_area", "Mask generated from selected profile plot area", Color.RED, PlotAreaSelectionTool.AreaType.Y_RANGE){

            @Override
            protected String createMaskExpression(PlotAreaSelectionTool.AreaType areaType, Shape shape) {
                Rectangle2D bounds = shape.getBounds2D();
                return this.createMaskExpression(bounds.getMinY(), bounds.getMaxY());
            }

            protected String createMaskExpression(double x1, double x2) {
                String bandName = BandArithmetic.createExternalName((String)ProfilePlotPanel.this.getRaster().getName());
                return String.format("%s >= %s && %s <= %s", bandName, x1, bandName, x2);
            }
        };
        this.profilePlotDisplay.addChartMouseListener((ChartMouseListener)new XYPlotMarker(this.profilePlotDisplay, new XYPlotMarker.Listener(){

            @Override
            public void pointSelected(XYDataset xyDataset, int seriesIndex, Point2D dataPoint) {
                if (ProfilePlotPanel.this.profileData != null) {
                    GeoPos[] geoPositions = ProfilePlotPanel.this.profileData.getGeoPositions();
                    int index = (int)dataPoint.getX();
                    if (index >= 0 && index < geoPositions.length) {
                        if (ProfilePlotPanel.this.cursorSynchronizer == null) {
                            ProfilePlotPanel.this.cursorSynchronizer = new DefaultCursorSynchronizer();
                        }
                        if (!ProfilePlotPanel.this.cursorSynchronizer.isEnabled()) {
                            ProfilePlotPanel.this.cursorSynchronizer.setEnabled(true);
                        }
                        ProfilePlotPanel.this.cursorSynchronizer.updateCursorOverlays(geoPositions[index]);
                    }
                }
            }

            @Override
            public void pointDeselected() {
                ProfilePlotPanel.this.cursorSynchronizer.setEnabled(false);
            }
        }));
        this.profilePlotDisplay.setInitialDelay(200);
        this.profilePlotDisplay.setDismissDelay(1500);
        this.profilePlotDisplay.setReshowDelay(200);
        this.profilePlotDisplay.setZoomTriggerDistance(5);
        this.profilePlotDisplay.getPopupMenu().addSeparator();
        this.profilePlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createMaskSelectionModeMenuItem());
        this.profilePlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createDeleteMaskMenuItem());
        this.profilePlotDisplay.getPopupMenu().addSeparator();
        this.profilePlotDisplay.getPopupMenu().add(this.createCopyDataToClipboardMenuItem());
        return this.profilePlotDisplay;
    }

    @Override
    protected void showAlternativeView() {
        AbstractTableModel model = this.profileData != null ? this.createProfileDataTableModel() : new DefaultTableModel();
        TableViewPagePanel alternativePanel = (TableViewPagePanel)this.getAlternativeView();
        alternativePanel.setModel(model);
        super.showAlternativeView();
    }

    @Override
    protected void initComponents() {
        if (this.hasAlternativeView()) {
            this.getAlternativeView().initComponents();
        }
        this.dataset = new XYIntervalSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)CHART_TITLE, (String)"Path in pixels", (String)DEFAULT_SAMPLE_DATASET_NAME, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = this.chart.getXYPlot();
        this.deviationRenderer = new DeviationRenderer();
        this.deviationRenderer.setUseFillPaint(true);
        this.deviationRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new XYPlotToolTipGenerator());
        this.deviationRenderer.setSeriesLinesVisible(0, true);
        this.deviationRenderer.setSeriesShapesVisible(0, false);
        this.deviationRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        this.deviationRenderer.setSeriesPaint(0, StatisticChartStyling.SAMPLE_DATA_PAINT);
        this.deviationRenderer.setSeriesFillPaint(0, StatisticChartStyling.SAMPLE_DATA_FILL_PAINT);
        this.pointRenderer = new XYErrorRenderer();
        this.pointRenderer.setUseFillPaint(true);
        this.pointRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new XYPlotToolTipGenerator());
        this.pointRenderer.setSeriesLinesVisible(0, false);
        this.pointRenderer.setSeriesShapesVisible(0, true);
        this.pointRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        this.pointRenderer.setSeriesPaint(0, StatisticChartStyling.SAMPLE_DATA_PAINT);
        this.pointRenderer.setSeriesFillPaint(0, StatisticChartStyling.SAMPLE_DATA_FILL_PAINT);
        this.pointRenderer.setSeriesShape(0, StatisticChartStyling.SAMPLE_DATA_POINT_SHAPE);
        this.configureRendererForCorrelativeData((XYLineAndShapeRenderer)this.deviationRenderer);
        this.configureRendererForCorrelativeData((XYLineAndShapeRenderer)this.pointRenderer);
        plot.setNoDataMessage(NO_DATA_MESSAGE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setRenderer((XYItemRenderer)this.deviationRenderer);
        AxisChangeListener axisListener = new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent event) {
                ProfilePlotPanel.this.adjustAxisControlComponents();
            }
        };
        ValueAxis domainAxis = plot.getDomainAxis();
        ValueAxis rangeAxis = plot.getRangeAxis();
        domainAxis.setAutoRange(true);
        rangeAxis.setAutoRange(true);
        domainAxis.addChangeListener(axisListener);
        rangeAxis.addChangeListener(axisListener);
        this.intervalMarkers = new HashSet<IntervalMarker>();
        this.xAxisRangeControl = new AxisRangeControl("X-Axis");
        this.yAxisRangeControl = new AxisRangeControl("Y-Axis");
        PropertyChangeListener changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(ProfilePlotPanel.PROPERTY_NAME_MARK_SEGMENTS)) {
                    ProfilePlotPanel.this.updateDataSet();
                }
                if (evt.getPropertyName().equals(ProfilePlotPanel.PROPERTY_NAME_LOG_SCALED)) {
                    ProfilePlotPanel.this.updateScalingOfYAxis();
                }
                ProfilePlotPanel.this.updateUIState();
            }
        };
        this.xAxisRangeControl.getBindingContext().addPropertyChangeListener(changeListener);
        this.xAxisRangeControl.getBindingContext().getPropertySet().addProperty(Property.create((String)PROPERTY_NAME_MARK_SEGMENTS, (Object)false));
        this.xAxisRangeControl.getBindingContext().getPropertySet().getDescriptor(PROPERTY_NAME_MARK_SEGMENTS).setDescription("Toggle whether to mark segments");
        this.yAxisRangeControl.getBindingContext().addPropertyChangeListener(changeListener);
        this.yAxisRangeControl.getBindingContext().getPropertySet().addProperty(Property.create((String)PROPERTY_NAME_LOG_SCALED, (Object)false));
        this.yAxisRangeControl.getBindingContext().getPropertySet().getDescriptor(PROPERTY_NAME_LOG_SCALED).setDescription("Toggle whether to use a logarithmic axis");
        this.dataSourceConfig = new DataSourceConfig();
        BindingContext bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.dataSourceConfig));
        JPanel middlePanel = this.createMiddlePanel(bindingContext);
        this.createUI(this.createChartPanel(this.chart), middlePanel, new RoiMaskSelector(bindingContext));
        this.isInitialized = true;
        this.updateComponents();
    }

    protected JPanel createMiddlePanel(BindingContext bindingContext) {
        JLabel boxSizeLabel = new JLabel("Box size: ");
        JSpinner boxSizeSpinner = new JSpinner();
        JCheckBox computeInBetweenPoints = new JCheckBox("Compute in-between points");
        JCheckBox useCorrelativeData = new JCheckBox("Use correlative data");
        this.correlativeFieldSelector = new CorrelativeFieldSelector(bindingContext);
        PropertyDescriptor boxSizeDescriptor = bindingContext.getPropertySet().getProperty("boxSize").getDescriptor();
        boxSizeDescriptor.setValueRange(new ValueRange(1.0, 101.0));
        boxSizeDescriptor.setAttribute("stepSize", (Object)2);
        boxSizeDescriptor.setValidator(new Validator(){

            public void validateValue(Property property, Object value) throws ValidationException {
                if (((Number)value).intValue() % 2 == 0) {
                    throw new ValidationException("Only odd values allowed as box size.");
                }
            }
        });
        bindingContext.bind("boxSize", boxSizeSpinner);
        bindingContext.bind("computeInBetweenPoints", computeInBetweenPoints);
        bindingContext.bind("useCorrelativeData", useCorrelativeData);
        EnablePointDataCondition condition = new EnablePointDataCondition();
        this.pointDataSourceEnablement = bindingContext.bindEnabledState("pointDataSource", true, (Enablement.Condition)condition);
        this.dataFieldEnablement = bindingContext.bindEnabledState("dataField", true, (Enablement.Condition)condition);
        bindingContext.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProfilePlotPanel.this.updateDataSource();
                ProfilePlotPanel.this.updateDataSet();
                ProfilePlotPanel.this.updateUIState();
            }
        });
        JPanel dataSourceOptionsPanel = GridBagUtils.createPanel();
        GridBagConstraints dataSourceOptionsConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)boxSizeLabel, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridwidth=1,gridy=0,gridx=0,weightx=0,insets.left=4");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)boxSizeSpinner, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridwidth=1,gridy=0,gridx=1,weightx=1,insets.left=0");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)computeInBetweenPoints, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridwidth=2,gridy=1,gridx=0,weightx=2");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)useCorrelativeData, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridy=2,insets.top=16");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)this.correlativeFieldSelector.pointDataSourceLabel, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridy=3,insets.top=0,insets.left=4");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)this.correlativeFieldSelector.pointDataSourceList, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridy=4,insets.left=4");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)this.correlativeFieldSelector.dataFieldLabel, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridy=5,insets.left=4");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)this.correlativeFieldSelector.dataFieldList, (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridy=6,insets.left=4");
        this.xAxisRangeControl.getBindingContext().bind(PROPERTY_NAME_MARK_SEGMENTS, new JCheckBox("Mark segments"));
        this.yAxisRangeControl.getBindingContext().bind(PROPERTY_NAME_LOG_SCALED, new JCheckBox("Log10 scaled"));
        JPanel displayOptionsPanel = GridBagUtils.createPanel();
        GridBagConstraints displayOptionsConstraints = GridBagUtils.createConstraints((String)"anchor=SOUTH,fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel((JPanel)displayOptionsPanel, (Component)this.xAxisRangeControl.getPanel(), (GridBagConstraints)displayOptionsConstraints, (String)"gridy=0");
        GridBagUtils.addToPanel((JPanel)displayOptionsPanel, (Component)this.xAxisRangeControl.getBindingContext().getBinding(PROPERTY_NAME_MARK_SEGMENTS).getComponents()[0], (GridBagConstraints)displayOptionsConstraints, (String)"gridy=1");
        GridBagUtils.addToPanel((JPanel)displayOptionsPanel, (Component)this.yAxisRangeControl.getPanel(), (GridBagConstraints)displayOptionsConstraints, (String)"gridy=2");
        GridBagUtils.addToPanel((JPanel)displayOptionsPanel, (Component)this.yAxisRangeControl.getBindingContext().getBinding(PROPERTY_NAME_LOG_SCALED).getComponents()[0], (GridBagConstraints)displayOptionsConstraints, (String)"gridy=3");
        JPanel middlePanel = GridBagUtils.createPanel();
        GridBagConstraints middlePanelConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2,weightx=1");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)dataSourceOptionsPanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=0");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)new JPanel(), (GridBagConstraints)middlePanelConstraints, (String)"gridy=1,fill=VERTICAL,weighty=1");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)displayOptionsPanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=2,fill=HORIZONTAL,weighty=0");
        return middlePanel;
    }

    @Override
    protected void updateChartData() {
    }

    private void configureRendererForCorrelativeData(XYLineAndShapeRenderer renderer) {
        renderer.setSeriesLinesVisible(1, false);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(1.0f));
        renderer.setSeriesPaint(1, StatisticChartStyling.CORRELATIVE_POINT_PAINT);
        renderer.setSeriesFillPaint(1, StatisticChartStyling.CORRELATIVE_POINT_FILL_PAINT);
        renderer.setSeriesShape(1, StatisticChartStyling.CORRELATIVE_POINT_SHAPE);
    }

    @Override
    protected boolean mustHandleSelectionChange() {
        return super.mustHandleSelectionChange() || this.isVectorDataNodeChanged();
    }

    @Override
    protected void updateComponents() {
        if (!this.isInitialized || !this.isVisible()) {
            return;
        }
        RasterDataNode raster = this.getRaster();
        if (raster != null) {
            this.chart.setTitle("Profile Plot for " + raster.getName());
        } else {
            this.chart.setTitle(CHART_TITLE);
        }
        this.correlativeFieldSelector.updatePointDataSource(this.getProduct());
        this.updateDataSource();
        this.updateDataSet();
        this.updateUIState();
        super.updateComponents();
    }

    private void updateDataSource() {
        if (!this.isInitialized) {
            return;
        }
        this.profileData = null;
        if (this.getRaster() != null) {
            try {
                if (this.dataSourceConfig.useCorrelativeData && this.dataSourceConfig.pointDataSource != null) {
                    this.profileData = new TransectProfileDataBuilder().raster(this.getRaster()).pointData(this.dataSourceConfig.pointDataSource).boxSize(this.dataSourceConfig.boxSize).connectVertices(this.dataSourceConfig.computeInBetweenPoints).useRoiMask(this.dataSourceConfig.useRoiMask).roiMask(this.dataSourceConfig.roiMask).build();
                } else {
                    Shape shape = StatisticsUtils.TransectProfile.getTransectShape(this.getRaster().getProduct());
                    if (shape != null) {
                        this.profileData = new TransectProfileDataBuilder().raster(this.getRaster()).path(shape).boxSize(this.dataSourceConfig.boxSize).connectVertices(this.dataSourceConfig.computeInBetweenPoints).useRoiMask(this.dataSourceConfig.useRoiMask).roiMask(this.dataSourceConfig.roiMask).build();
                    }
                }
            }
            catch (IOException e) {
                AbstractDialog.showErrorDialog((Component)this.getParent(), (String)("Failed to compute profile plot.\nAn I/O error occurred:" + e.getMessage()), (String)"I/O error");
            }
        }
    }

    private void updateDataSet() {
        if (!this.isInitialized) {
            return;
        }
        this.dataset.removeAllSeries();
        double dx = 0.5 * (double)this.dataSourceConfig.boxSize;
        if (this.profileData != null) {
            float[] sampleValues = this.profileData.getSampleValues();
            float[] sampleSigmas = this.profileData.getSampleSigmas();
            XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)(this.getRaster() != null ? this.getRaster().getName() : DEFAULT_SAMPLE_DATASET_NAME)));
            for (int x = 0; x < sampleValues.length; ++x) {
                float y = sampleValues[x];
                float dy = sampleSigmas[x];
                series.add((double)x, (double)x - dx, (double)x + dx, (double)y, (double)(y - dy), (double)(y + dy));
            }
            this.dataset.addSeries(series);
            if (this.dataSourceConfig.useCorrelativeData && this.dataSourceConfig.pointDataSource != null && this.dataSourceConfig.dataField != null) {
                SimpleFeature[] simpleFeatures;
                XYIntervalSeries corrSeries = new XYIntervalSeries((Comparable)((Object)StatisticChartStyling.getCorrelativeDataLabel(this.dataSourceConfig.pointDataSource, this.dataSourceConfig.dataField)));
                int[] shapeVertexIndexes = this.profileData.getShapeVertexIndexes();
                if (shapeVertexIndexes.length == (simpleFeatures = (SimpleFeature[])this.dataSourceConfig.pointDataSource.getFeatureCollection().toArray((Object[])new SimpleFeature[0])).length) {
                    int fieldIndex = this.getAttributeIndex(this.dataSourceConfig.pointDataSource, this.dataSourceConfig.dataField);
                    if (fieldIndex != -1) {
                        for (int i = 0; i < simpleFeatures.length; ++i) {
                            Number attribute = (Number)simpleFeatures[i].getAttribute(fieldIndex);
                            if (attribute == null) continue;
                            double x = shapeVertexIndexes[i];
                            double y = attribute.doubleValue();
                            corrSeries.add(x, x, x, y, y, y);
                        }
                        this.dataset.addSeries(corrSeries);
                    }
                } else {
                    System.out.println("Weird things happened:");
                    System.out.println("  shapeVertexIndexes.length = " + shapeVertexIndexes.length);
                    System.out.println("  simpleFeatures.length     = " + simpleFeatures.length);
                }
            }
            this.profilePlotDisplay.restoreAutoBounds();
            this.xAxisRangeControl.getBindingContext().setComponentsEnabled(PROPERTY_NAME_MARK_SEGMENTS, this.profileData.getShapeVertices().length > 2);
        }
    }

    private int getAttributeIndex(VectorDataNode pointDataSource, AttributeDescriptor dataField) {
        String fieldName = dataField.getLocalName();
        if (fieldName.equals(" ")) {
            return -1;
        }
        return pointDataSource.getFeatureType().indexOf(fieldName);
    }

    private void updateUIState() {
        if (!this.isInitialized) {
            return;
        }
        this.xAxisRangeControl.getBindingContext().setComponentsEnabled(PROPERTY_NAME_MARK_SEGMENTS, this.profileData != null && this.profileData.getShapeVertices().length > 2);
        this.xAxisRangeControl.setComponentsEnabled(this.profileData != null);
        this.yAxisRangeControl.setComponentsEnabled(this.profileData != null);
        this.adjustPlotAxes();
        if (this.dataSourceConfig.computeInBetweenPoints) {
            this.chart.getXYPlot().setRenderer((XYItemRenderer)this.deviationRenderer);
        } else {
            this.chart.getXYPlot().setRenderer((XYItemRenderer)this.pointRenderer);
        }
        this.chart.getXYPlot().getRangeAxis().setLabel(StatisticChartStyling.getAxisLabel(this.getRaster(), DEFAULT_SAMPLE_DATASET_NAME, false));
        boolean markSegments = (Boolean)this.xAxisRangeControl.getBindingContext().getPropertySet().getValue(PROPERTY_NAME_MARK_SEGMENTS);
        if (markSegments && this.profileData != null && this.profileData.getNumShapeVertices() > 1) {
            int[] shapeVertexIndexes = this.profileData.getShapeVertexIndexes();
            this.removeIntervalMarkers();
            for (int i = 0; i < shapeVertexIndexes.length - 1; ++i) {
                if (i % 2 == 0) continue;
                IntervalMarker marker = new IntervalMarker((double)shapeVertexIndexes[i], (double)shapeVertexIndexes[i + 1]);
                marker.setPaint((Paint)new Color(120, 122, 125));
                marker.setAlpha(0.3f);
                this.chart.getXYPlot().addDomainMarker((Marker)marker, Layer.BACKGROUND);
                this.intervalMarkers.add(marker);
            }
        } else {
            this.removeIntervalMarkers();
        }
        this.pointDataSourceEnablement.apply();
        this.dataFieldEnablement.apply();
    }

    private void removeIntervalMarkers() {
        for (IntervalMarker intervalMarker : this.intervalMarkers) {
            this.chart.getXYPlot().removeDomainMarker((Marker)intervalMarker, Layer.BACKGROUND);
        }
        this.intervalMarkers.clear();
    }

    private void adjustAxisControlComponents() {
        if (!this.axisAdjusting) {
            this.axisAdjusting = true;
            try {
                if (this.xAxisRangeControl.isAutoMinMax()) {
                    this.xAxisRangeControl.adjustComponents(this.chart.getXYPlot().getDomainAxis(), 0);
                }
                if (this.yAxisRangeControl.isAutoMinMax()) {
                    this.yAxisRangeControl.adjustComponents(this.chart.getXYPlot().getRangeAxis(), 2);
                }
            }
            finally {
                this.axisAdjusting = false;
            }
        }
    }

    private void adjustPlotAxes() {
        if (!this.axisAdjusting) {
            this.axisAdjusting = true;
            try {
                this.xAxisRangeControl.adjustAxis(this.chart.getXYPlot().getDomainAxis(), 0);
                this.yAxisRangeControl.adjustAxis(this.chart.getXYPlot().getRangeAxis(), 2);
            }
            finally {
                this.axisAdjusting = false;
            }
        }
    }

    private void updateScalingOfYAxis() {
        boolean logScaled = (Boolean)this.yAxisRangeControl.getBindingContext().getBinding(PROPERTY_NAME_LOG_SCALED).getPropertyValue();
        XYPlot plot = this.chart.getXYPlot();
        plot.setRangeAxis(StatisticChartStyling.updateScalingOfAxis(logScaled, plot.getRangeAxis(), true));
    }

    @Override
    public void nodeAdded(ProductNodeEvent event) {
        if (event.getSourceNode() instanceof VectorDataNode) {
            this.updateComponents();
        }
    }

    @Override
    public void nodeRemoved(ProductNodeEvent event) {
        if (event.getSourceNode() instanceof VectorDataNode) {
            this.updateComponents();
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.updateComponents();
    }

    @Override
    protected String getDataAsText() {
        if (this.profileData != null) {
            ProfileDataTableModel model = this.createProfileDataTableModel();
            return model.toCsv();
        }
        return "";
    }

    private ProfileDataTableModel createProfileDataTableModel() {
        return new ProfileDataTableModel(this.getRaster().getName(), this.profileData, this.dataSourceConfig);
    }

    @Override
    public void handleLayerContentChanged() {
        this.updateComponents();
    }

    private class EnablePointDataCondition
    extends Enablement.Condition {
        private EnablePointDataCondition() {
        }

        public boolean evaluate(BindingContext bindingContext) {
            return ((ProfilePlotPanel)ProfilePlotPanel.this).dataSourceConfig.useCorrelativeData && ProfilePlotPanel.this.getProduct() != null;
        }
    }

    static class DataSourceConfig {
        int boxSize = 3;
        boolean useRoiMask;
        Mask roiMask;
        boolean computeInBetweenPoints = true;
        boolean useCorrelativeData;
        VectorDataNode pointDataSource;
        AttributeDescriptor dataField;

        DataSourceConfig() {
        }
    }
}

