/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.SliderAdapter;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Shape;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.statistics.ChartPagePanel;
import org.esa.snap.rcp.statistics.MetadataPlotSettings;
import org.esa.snap.rcp.statistics.MetadataPlotTableModel;
import org.esa.snap.rcp.statistics.RoiMaskSelector;
import org.esa.snap.rcp.statistics.TableViewPagePanel;
import org.esa.snap.ui.io.TableModelCsvEncoder;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.openide.windows.TopComponent;

class MetadataPlotPanel
extends ChartPagePanel {
    private static final String DEFAULT_SAMPLE_DATASET_NAME = "Sample";
    private static final String NO_DATA_MESSAGE = "No metadata plot computed yet.\nTo create a plot, select metadata elements in both combo boxes.\nThe plot will be computed when you click the 'Refresh View' button.\nFor more information about this plot\nhit the help button at the bottom right.\nTIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private static final String CHART_TITLE = "Metadata Plot";
    private static final String DEFAULT_X_AXIS_LABEL = "x-values";
    private static final Paint[] DEFAULT_PAINT_ARRAY = ChartColor.createDefaultPaintArray();
    private static final Shape[] DEFAULT_SHAPE_ARRAY = DefaultDrawingSupplier.createStandardSeriesShapes();
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String TOOL_TIP_FORMAT = "{0}: {1}, {2}";
    public static final String ITEM_LABEL_FORMAT = "{2}";
    private MetadataPlotSettings plotSettings;
    private boolean isInitialized;
    private JSlider recordSlider;
    private SpinnerNumberModel numRecSpinnerModel;
    private XYPlot xyPlot;
    private JTextField recordValueField;

    MetadataPlotPanel(TopComponent parentComponent, String helpId) {
        super(parentComponent, helpId, CHART_TITLE, false);
    }

    @Override
    protected void initComponents() {
        if (this.hasAlternativeView()) {
            this.getAlternativeView().initComponents();
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)CHART_TITLE, (String)DEFAULT_X_AXIS_LABEL, (String)DEFAULT_SAMPLE_DATASET_NAME, (XYDataset)new DefaultXYDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.xyPlot = chart.getXYPlot();
        this.xyPlot.setNoDataMessage(NO_DATA_MESSAGE);
        this.xyPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        ChartPanel profilePlotDisplay = new ChartPanel(chart);
        profilePlotDisplay.setInitialDelay(200);
        profilePlotDisplay.setDismissDelay(1500);
        profilePlotDisplay.setReshowDelay(200);
        profilePlotDisplay.setZoomTriggerDistance(5);
        profilePlotDisplay.getPopupMenu().addSeparator();
        profilePlotDisplay.getPopupMenu().add(this.createCopyDataToClipboardMenuItem());
        this.plotSettings = new MetadataPlotSettings();
        BindingContext bindingContext = this.plotSettings.getContext();
        JPanel settingsPanel = this.createSettingsPanel(bindingContext);
        this.createUI(profilePlotDisplay, settingsPanel, (RoiMaskSelector)null);
        bindingContext.setComponentsEnabled("recordStartIndex", false);
        bindingContext.setComponentsEnabled("recordsPerPlot", false);
        this.isInitialized = true;
        this.updateComponents();
        this.updateChartData();
        bindingContext.addPropertyChangeListener("metadataElement", evt -> this.updateUiState());
        bindingContext.addPropertyChangeListener(evt -> this.updateChartData());
    }

    private DefaultXYItemRenderer creatItemRenderer(int index, int yDataType) {
        DefaultXYItemRenderer itemRenderer = new DefaultXYItemRenderer();
        itemRenderer.setSeriesPaint(0, DEFAULT_PAINT_ARRAY[index % DEFAULT_PAINT_ARRAY.length]);
        itemRenderer.setSeriesShape(0, DEFAULT_SHAPE_ARRAY[index % DEFAULT_SHAPE_ARRAY.length]);
        itemRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        DecimalFormat numberFormat = new DecimalFormat("0.00#");
        numberFormat.setGroupingUsed(false);
        StandardXYToolTipGenerator toolTipGenerator = 51 == yDataType ? new StandardXYToolTipGenerator(TOOL_TIP_FORMAT, (NumberFormat)numberFormat, (DateFormat)SIMPLE_DATE_FORMAT) : new StandardXYToolTipGenerator(TOOL_TIP_FORMAT, (NumberFormat)numberFormat, (NumberFormat)numberFormat);
        itemRenderer.setSeriesToolTipGenerator(0, (XYToolTipGenerator)toolTipGenerator);
        StandardXYItemLabelGenerator itemLabelGenerator = 51 == yDataType ? new StandardXYItemLabelGenerator(ITEM_LABEL_FORMAT, (NumberFormat)numberFormat, (DateFormat)SIMPLE_DATE_FORMAT) : new StandardXYItemLabelGenerator(ITEM_LABEL_FORMAT, (NumberFormat)numberFormat, (NumberFormat)numberFormat);
        itemRenderer.setSeriesItemLabelGenerator(0, (XYItemLabelGenerator)itemLabelGenerator);
        return itemRenderer;
    }

    @Override
    protected void showAlternativeView() {
        AbstractTableModel model = this.xyPlot != null && this.xyPlot.getSeriesCount() > 0 ? new MetadataPlotTableModel(this.xyPlot) : new DefaultTableModel();
        TableViewPagePanel alternativPanel = (TableViewPagePanel)this.getAlternativeView();
        alternativPanel.setModel(model);
        super.showAlternativeView();
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
        super.nodeDataChanged(event);
    }

    @Override
    protected void updateComponents() {
        super.updateComponents();
        this.updateSettings();
        this.updateUiState();
    }

    @Override
    protected void updateChartData() {
        this.resetChart();
        MetadataElement metadataElement = this.plotSettings.getMetadataElement();
        String nameX = this.plotSettings.getNameX();
        String nameY1 = this.plotSettings.getNameY1();
        if (metadataElement == null || nameX == null || StringUtils.isNullOrEmpty((String)nameY1) || "None".equals(nameY1)) {
            return;
        }
        int numRecords = this.plotSettings.getNumRecords();
        int recordsPerPlot = this.plotSettings.getRecordsPerPlot();
        int startIndex = this.plotSettings.getRecordStartIndex();
        String nameY2 = this.plotSettings.getFieldY2();
        double[] recordIndices = MetadataPlotPanel.getRecordIndices(startIndex, recordsPerPlot, numRecords);
        String[] recordElementNames = new String[recordIndices.length];
        Arrays.setAll(recordElementNames, i -> String.format("%s.%.0f", metadataElement.getName(), recordIndices[i]));
        switch (nameX) {
            case "Record Index": {
                this.configureChartForRecordIndex(metadataElement, nameX, nameY1, nameY2, recordElementNames, String.format("%s.1", metadataElement.getName()), recordIndices);
                break;
            }
            case "Array Field Index [n]": {
                this.configureChartForArrayIndex(metadataElement, nameX, nameY1, nameY2, recordElementNames, String.format("%s.1", metadataElement.getName()));
                break;
            }
            default: {
                if (recordElementNames.length == 0) break;
                if (metadataElement.containsElement(recordElementNames[0])) {
                    this.configureChartForDefault(metadataElement.getElement(recordElementNames[0]), nameX, nameY1, nameY2);
                    break;
                }
                this.configureChartForDefault(metadataElement, nameX, nameY1, nameY2);
            }
        }
    }

    private void configureChartForDefault(MetadataElement metadataElement, String nameX, String nameY1, String nameY2) {
        if (!this.isValidYField(metadataElement, metadataElement.getName(), nameY1)) {
            return;
        }
        MetadataAttribute xAttribute = metadataElement.getAttribute(nameX);
        int xDataType = this.getAttributeType(xAttribute);
        this.configureDomainAxis(0, nameX, xDataType);
        double[] xData = new double[1];
        Arrays.setAll(xData, i -> this.getDataAsDouble(xAttribute.getData()));
        MetadataAttribute y1Attribute = metadataElement.getAttribute(nameY1);
        int y1DataType = this.getAttributeType(y1Attribute);
        ValueAxis y1Axis = this.configureRangeIndex(0, y1DataType);
        String unitY1 = y1Attribute.getUnit();
        y1Axis.setLabel(this.getYAxisLabel(nameY1, unitY1));
        double[] y1AxisData = new double[1];
        Arrays.setAll(y1AxisData, i -> this.getDataAsDouble(y1Attribute.getData()));
        DefaultXYDataset dataset1 = new DefaultXYDataset();
        dataset1.addSeries((Comparable)((Object)nameY1), (double[][])new double[][]{xData, y1AxisData});
        this.xyPlot.setDataset(0, (XYDataset)dataset1);
        this.xyPlot.mapDatasetToRangeAxis(0, 0);
        this.xyPlot.setRenderer(0, (XYItemRenderer)this.creatItemRenderer(0, y1DataType));
        if (!this.isValidYField(metadataElement, metadataElement.getName(), nameY2)) {
            return;
        }
        MetadataAttribute y2Attribute = metadataElement.getAttribute(nameY2);
        int y2DataType = this.getAttributeType(y2Attribute);
        ValueAxis y2Axis = this.configureRangeIndex(1, y2DataType);
        String unitY2 = y2Attribute.getUnit();
        y2Axis.setLabel(this.getYAxisLabel(nameY2, unitY2));
        double[] y2AxisData = new double[1];
        Arrays.setAll(y2AxisData, i -> this.getDataAsDouble(y2Attribute.getData()));
        DefaultXYDataset dataset2 = new DefaultXYDataset();
        dataset2.addSeries((Comparable)((Object)nameY2), (double[][])new double[][]{xData, y2AxisData});
        this.xyPlot.setDataset(1, (XYDataset)dataset2);
        this.xyPlot.mapDatasetToRangeAxis(1, 1);
        this.xyPlot.setRenderer(1, (XYItemRenderer)this.creatItemRenderer(1, y1DataType));
    }

    private void configureChartForArrayIndex(MetadataElement metadataElement, String nameX, String nameY1, String nameY2, String[] recordElementNames, String refRecordName) {
        if (!this.isValidArrayYField(metadataElement, refRecordName, nameY1)) {
            return;
        }
        this.configureDomainAxis(0, nameX, 12);
        MetadataElement refElem = metadataElement.getElement(refRecordName);
        int y1ArrayLength = (int)refElem.getAttribute(nameY1).getNumDataElems();
        double[] y1ArrayIndices = new double[y1ArrayLength];
        Arrays.setAll(y1ArrayIndices, i -> i);
        MetadataAttribute y1Attribute = metadataElement.getElement(refRecordName).getAttribute(nameY1);
        int y1DataType = this.getAttributeType(y1Attribute);
        ValueAxis y1Axis = this.configureRangeIndex(0, y1DataType);
        String unitY1 = y1Attribute.getUnit();
        y1Axis.setLabel(this.getYAxisLabel(nameY1, unitY1));
        int dataSetCnt = 0;
        int i2 = 0;
        while (i2 < recordElementNames.length) {
            String recordElementName = recordElementNames[i2];
            this.addArrayDataToSeries(0, 0, dataSetCnt, nameY1, metadataElement, y1ArrayIndices, recordElementName);
            ++i2;
            ++dataSetCnt;
        }
        if (!this.isValidArrayYField(metadataElement, refRecordName, nameY2)) {
            return;
        }
        MetadataAttribute y2Attribute = metadataElement.getElement(refRecordName).getAttribute(nameY2);
        int y2DataType = this.getAttributeType(y2Attribute);
        ValueAxis y2Axis = this.configureRangeIndex(1, y2DataType);
        String unitY2 = y2Attribute.getUnit();
        y2Axis.setLabel(this.getYAxisLabel(nameY2, unitY2));
        int y2ArrayLength = (int)refElem.getAttribute(nameY2).getNumDataElems();
        double[] y2ArrayIndices = new double[y2ArrayLength];
        Arrays.setAll(y2ArrayIndices, i -> i);
        if (y2ArrayLength != y1ArrayLength) {
            this.configureDomainAxis(0, nameY1 + " - " + nameX, 12);
            this.configureDomainAxis(1, nameY2 + " - " + nameX, 12);
        }
        int i3 = 0;
        while (i3 < recordElementNames.length) {
            String recordElementName = recordElementNames[i3];
            this.addArrayDataToSeries(y2ArrayLength != y1ArrayLength ? 1 : 0, 1, dataSetCnt, nameY2, metadataElement, y2ArrayIndices, recordElementName);
            ++i3;
            ++dataSetCnt;
        }
    }

    private void addArrayDataToSeries(int domainAxisIndex, int rangeAxisIndex, int datasetIndex, String yName, MetadataElement metadataElement, double[] arrayIndices, String recordElementName) {
        double[] yAxisData = new double[arrayIndices.length];
        ProductData attributeData = metadataElement.getElement(recordElementName).getAttribute(yName).getData();
        Arrays.setAll(yAxisData, arg_0 -> ((ProductData)attributeData).getElemDoubleAt(arg_0));
        String seriesKey = String.format("%s/%s", recordElementName, yName);
        DefaultXYDataset dataset = new DefaultXYDataset();
        dataset.addSeries((Comparable)((Object)seriesKey), (double[][])new double[][]{arrayIndices, yAxisData});
        this.xyPlot.setDataset(datasetIndex, (XYDataset)dataset);
        this.xyPlot.mapDatasetToRangeAxis(datasetIndex, rangeAxisIndex);
        this.xyPlot.mapDatasetToDomainAxis(datasetIndex, domainAxisIndex);
        this.xyPlot.setRenderer(datasetIndex, (XYItemRenderer)this.creatItemRenderer(datasetIndex, 12));
    }

    private void configureChartForRecordIndex(MetadataElement metadataElement, String nameX, String nameY1, String nameY2, String[] recordElementNames, String refRecordName, double[] recordIndices) {
        if (!this.isValidYField(metadataElement, refRecordName, nameY1)) {
            return;
        }
        this.configureRangeAxis(0, metadataElement, nameY1, recordElementNames, refRecordName, recordIndices);
        this.configureDomainAxis(0, nameX, 12);
        if (!this.isValidYField(metadataElement, recordElementNames[0], nameY2)) {
            return;
        }
        this.configureRangeAxis(1, metadataElement, nameY2, recordElementNames, refRecordName, recordIndices);
    }

    private void configureRangeAxis(int index, MetadataElement metadataElement, String yAttributeName, String[] recordElementNames, String refRecordName, double[] recordIndices) {
        double[] yAxisData = new double[recordIndices.length];
        Arrays.setAll(yAxisData, i -> this.getDataAsDouble(metadataElement.getElement(recordElementNames[i]).getAttribute(yAttributeName).getData()));
        DefaultXYDataset dataset2 = new DefaultXYDataset();
        dataset2.addSeries((Comparable)((Object)yAttributeName), (double[][])new double[][]{recordIndices, yAxisData});
        this.xyPlot.setDataset(index, (XYDataset)dataset2);
        this.xyPlot.mapDatasetToRangeAxis(index, index);
        int yDataType = this.getAttributeType(metadataElement.getElement(refRecordName).getAttribute(yAttributeName));
        ValueAxis yAxis = this.configureRangeIndex(index, yDataType);
        String yUnit = metadataElement.getElement(refRecordName).getAttribute(yAttributeName).getUnit();
        yAxis.setLabel(this.getYAxisLabel(yAttributeName, yUnit));
        this.xyPlot.setRenderer(index, (XYItemRenderer)this.creatItemRenderer(index, yDataType));
    }

    private ValueAxis configureRangeIndex(int index, int dataType) {
        ValueAxis axis = this.createAxis(dataType);
        axis.setAutoRange(true);
        Font axisFont = axis.getLabelFont().deriveFont(1);
        axis.setLabelFont(axisFont);
        axis.setLabel(String.format("Y%d Samples", index + 1));
        this.xyPlot.setRangeAxis(index, axis);
        this.xyPlot.setRangeAxisLocation(index, index == 0 ? AxisLocation.BOTTOM_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
        return axis;
    }

    private ValueAxis createAxis(int dataType) {
        NumberAxis axis;
        if (51 == dataType) {
            axis = new DateAxis("Date", TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
            ((DateAxis)axis).setDateFormatOverride((DateFormat)SIMPLE_DATE_FORMAT);
        } else {
            axis = new NumberAxis();
            axis.setAutoRangeIncludesZero(false);
        }
        return axis;
    }

    private void configureDomainAxis(int index, String nameX, int dataType) {
        ValueAxis axis = this.createAxis(dataType);
        axis.setAutoRange(true);
        axis.setAutoRangeMinimumSize(2.0);
        axis.setLabel(nameX);
        Font axisFont = axis.getLabelFont().deriveFont(1);
        axis.setLabelFont(axisFont);
        this.xyPlot.setDomainAxis(index, axis);
    }

    private int getAttributeType(MetadataAttribute attribute) {
        return ProductData.getType((String)attribute.getData().getTypeString());
    }

    private double getDataAsDouble(ProductData data) {
        if (data instanceof ProductData.UTC) {
            return ((ProductData.UTC)data).getAsDate().getTime();
        }
        return data.getElemDouble();
    }

    private String getYAxisLabel(String name, String unit) {
        return name + (StringUtils.isNullOrEmpty((String)unit) || unit.equals("-") ? "" : " in " + unit);
    }

    private void resetChart() {
        this.removeAllDatasetSeries();
        this.xyPlot.clearRangeAxes();
        this.xyPlot.clearDomainAxes();
        this.configureDomainAxis(0, DEFAULT_X_AXIS_LABEL, 31);
        this.xyPlot.getRenderer().setBaseSeriesVisibleInLegend(true);
    }

    private boolean isValidYField(MetadataElement metadataElement, String elementName, String nameY) {
        MetadataElement element = metadataElement.getName().equals(elementName) ? metadataElement : metadataElement.getElement(elementName);
        return StringUtils.isNotNullAndNotEmpty((String)nameY) && !"None".equals(nameY) && element != null && element.getAttribute(nameY) != null;
    }

    private boolean isValidArrayYField(MetadataElement metadataElement, String elementName, String nameY) {
        MetadataElement element = metadataElement.getElement(elementName);
        if (element == null || StringUtils.isNullOrEmpty((String)nameY)) {
            return false;
        }
        MetadataAttribute attribute = element.getAttribute(nameY);
        return attribute != null && !"None".equals(nameY) && attribute.getNumDataElems() > 1L;
    }

    private void removeAllDatasetSeries() {
        int datasetCount = this.xyPlot.getDatasetCount();
        for (int i = 0; i < datasetCount; ++i) {
            this.xyPlot.setDataset(i, null);
        }
    }

    static double[] getRecordIndices(int startIndex, int recordsPerPlot, int numRecords) {
        int clippedStartIndex = Math.max(1, Math.min(startIndex, numRecords));
        int clippedEndIndex = Math.min(numRecords, Math.min(startIndex - 1 + recordsPerPlot, numRecords));
        double[] indexArray = new double[clippedEndIndex - clippedStartIndex + 1];
        Arrays.setAll(indexArray, index -> index + clippedStartIndex);
        return indexArray;
    }

    @Override
    protected String getDataAsText() {
        StringWriter sw = new StringWriter();
        try {
            this.encodeCsv(sw);
            sw.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sw.toString();
    }

    private void encodeCsv(Writer writer) throws IOException {
        new TableModelCsvEncoder((TableModel)new MetadataPlotTableModel(this.xyPlot)).encodeCsv(writer);
    }

    private JPanel createSettingsPanel(BindingContext bindingContext) {
        JLabel datasetLabel = new JLabel("Dataset: ");
        JComboBox<Object> datasetBox = new JComboBox<Object>();
        datasetBox.setRenderer(new ProductNodeListCellRenderer());
        JLabel recordLabel = new JLabel("Record: ");
        this.recordValueField = new JTextField(7);
        this.recordSlider = new JSlider(0, 1, 1, 1);
        this.recordSlider.setPaintTrack(true);
        this.recordSlider.setPaintTicks(true);
        this.recordSlider.setPaintLabels(true);
        this.configureSilderLabels(this.recordSlider);
        JLabel numRecordsLabel = new JLabel("Records / Plot: ");
        this.numRecSpinnerModel = new SpinnerNumberModel(1, 1, 1, 1);
        JSpinner numRecordsSpinner = new JSpinner(this.numRecSpinnerModel);
        numRecordsSpinner.setEditor(new JSpinner.NumberEditor(numRecordsSpinner, "#"));
        JLabel xFieldLabel = new JLabel("X Field: ");
        JComboBox<Object> xFieldBox = new JComboBox<Object>();
        xFieldBox.setRenderer(new ProductNodeListCellRenderer());
        JLabel y1FieldLabel = new JLabel("Y Field: ");
        JComboBox<Object> y1FieldBox = new JComboBox<Object>();
        y1FieldBox.setRenderer(new ProductNodeListCellRenderer());
        JLabel y2FieldLabel = new JLabel("Y2 Field: ");
        JComboBox<Object> y2FieldBox = new JComboBox<Object>();
        y2FieldBox.setRenderer(new ProductNodeListCellRenderer());
        bindingContext.bind("metadataElement", datasetBox);
        bindingContext.bind("recordStartIndex", this.recordValueField);
        bindingContext.bind("recordStartIndex", (ComponentAdapter)new SliderAdapter(this.recordSlider));
        bindingContext.bind("recordsPerPlot", numRecordsSpinner);
        bindingContext.bind("fieldX", xFieldBox);
        bindingContext.bind("fieldY1", y1FieldBox);
        bindingContext.bind("fieldY2", y2FieldBox);
        TableLayout layout = new TableLayout(3);
        JPanel plotSettingsPanel = new JPanel((LayoutManager)layout);
        layout.setTableWeightX(Double.valueOf(0.0));
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(4, 4);
        layout.setCellWeightX(0, 1, Double.valueOf(1.0));
        layout.setCellColspan(0, 1, Integer.valueOf(2));
        plotSettingsPanel.add(datasetLabel);
        plotSettingsPanel.add(datasetBox);
        layout.setCellWeightX(1, 1, Double.valueOf(0.2));
        layout.setCellWeightX(1, 2, Double.valueOf(0.8));
        plotSettingsPanel.add(recordLabel);
        plotSettingsPanel.add(this.recordValueField);
        plotSettingsPanel.add(this.recordSlider);
        layout.setCellWeightX(2, 1, Double.valueOf(1.0));
        layout.setCellColspan(2, 1, Integer.valueOf(2));
        plotSettingsPanel.add(numRecordsLabel);
        plotSettingsPanel.add(numRecordsSpinner);
        layout.setCellWeightX(3, 1, Double.valueOf(1.0));
        layout.setCellColspan(3, 1, Integer.valueOf(2));
        plotSettingsPanel.add(xFieldLabel);
        plotSettingsPanel.add(xFieldBox);
        layout.setCellWeightX(4, 1, Double.valueOf(1.0));
        layout.setCellColspan(4, 1, Integer.valueOf(2));
        plotSettingsPanel.add(y1FieldLabel);
        plotSettingsPanel.add(y1FieldBox);
        layout.setCellWeightX(5, 1, Double.valueOf(1.0));
        layout.setCellColspan(5, 1, Integer.valueOf(2));
        plotSettingsPanel.add(y2FieldLabel);
        plotSettingsPanel.add(y2FieldBox);
        this.updateSettings();
        this.updateUiState();
        return plotSettingsPanel;
    }

    private void configureSilderLabels(JSlider recordSlider) {
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel minLabel = new JLabel(String.valueOf(recordSlider.getMinimum()));
        labelTable.put(recordSlider.getMinimum(), minLabel);
        JLabel maxLabel = new JLabel(String.valueOf(recordSlider.getMaximum()));
        labelTable.put(recordSlider.getMaximum(), maxLabel);
        recordSlider.setLabelTable(labelTable);
    }

    private void updateUiState() {
        if (!this.isInitialized) {
            return;
        }
        int numRecords = this.plotSettings.getNumRecords();
        this.recordSlider.setMaximum(numRecords);
        this.configureSilderLabels(this.recordSlider);
        this.numRecSpinnerModel.setMaximum(Integer.valueOf(numRecords));
        this.plotSettings.getContext().setComponentsEnabled("recordStartIndex", numRecords > 1);
        this.plotSettings.getContext().setComponentsEnabled("recordsPerPlot", numRecords > 1);
        this.recordValueField.setEditable(numRecords > 1);
    }

    private void updateSettings() {
        Product product = this.getProduct();
        if (product == null) {
            this.plotSettings.setMetadataElements(null);
            return;
        }
        this.removeAllDatasetSeries();
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement[] elements = metadataRoot.getElements();
        this.recordSlider.setValue(1);
        this.plotSettings.setMetadataElements(elements);
    }

    private static class ProductNodeListCellRenderer
    extends DefaultListCellRenderer {
        private ProductNodeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel rendererComponent = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ProductNode) {
                ProductNode element = (ProductNode)value;
                rendererComponent.setText(element.getName());
            }
            return rendererComponent;
        }
    }
}

