/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import javax.media.jai.Histogram;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.StatisticsDataProvider;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.statistics.output.CsvStatisticsWriter;
import org.esa.snap.statistics.output.MetadataWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.ui.SnapFileChooser;

class ExportStatisticsAsCsvAction
extends AbstractAction {
    private static final String PROPERTY_KEY_EXPORT_DIR = "user.statistics.export.dir";
    private Mask[] selectedMasks;
    private final StatisticsDataProvider dataProvider;

    public ExportStatisticsAsCsvAction(StatisticsDataProvider dataProvider) {
        super("Export as CSV");
        this.dataProvider = dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        PrintStream metadataOutputStream = null;
        PrintStream csvOutputStream = null;
        String exportDir = SnapApp.getDefault().getPreferences().get(PROPERTY_KEY_EXPORT_DIR, null);
        File baseDir = null;
        if (exportDir != null) {
            baseDir = new File(exportDir);
        }
        SnapFileChooser fileChooser = new SnapFileChooser(baseDir);
        SnapFileFilter snapFileFilter = new SnapFileFilter("CSV", new String[]{".csv", ".txt"}, "CSV files");
        fileChooser.setFileFilter((FileFilter)snapFileFilter);
        int result = fileChooser.showSaveDialog((Component)SnapApp.getDefault().getMainFrame());
        if (result != 0) {
            return;
        }
        File outputAsciiFile = fileChooser.getSelectedFile();
        SnapApp.getDefault().getPreferences().put(PROPERTY_KEY_EXPORT_DIR, outputAsciiFile.getParent());
        try {
            String[] regionIds;
            File metadataFile = new File(outputAsciiFile.getParent(), FileUtils.getFilenameWithoutExtension((File)outputAsciiFile) + "_metadata.txt");
            metadataOutputStream = new PrintStream(new FileOutputStream(metadataFile));
            csvOutputStream = new PrintStream(new FileOutputStream(outputAsciiFile));
            CsvStatisticsWriter csvStatisticsWriter = new CsvStatisticsWriter(csvOutputStream);
            MetadataWriter metadataWriter = new MetadataWriter(metadataOutputStream);
            if (this.selectedMasks != null) {
                regionIds = new String[this.selectedMasks.length];
                for (int i = 0; i < this.selectedMasks.length; ++i) {
                    regionIds[i] = this.selectedMasks[i] != null ? this.selectedMasks[i].getName() : "\t";
                }
            } else {
                regionIds = new String[]{"full_scene"};
            }
            String[] algorithmNames = new String[]{"minimum", "maximum", "median", "average", "sigma", "p90_threshold", "p95_threshold", "total"};
            StatisticsOutputContext outputContext = StatisticsOutputContext.create((Product[])new Product[]{this.dataProvider.getRasterDataNode().getProduct()}, (String[])algorithmNames, (String[])regionIds);
            metadataWriter.initialiseOutput(outputContext);
            csvStatisticsWriter.initialiseOutput(outputContext);
            HashMap<String, Number> statistics = new HashMap<String, Number>();
            Histogram[] histograms = this.dataProvider.getHistograms();
            for (int i = 0; i < histograms.length; ++i) {
                Histogram histogram = histograms[i];
                statistics.put("minimum", histogram.getLowValue(0));
                statistics.put("maximum", histogram.getHighValue(0));
                statistics.put("median", histogram.getPTileThreshold(0.5)[0]);
                statistics.put("average", histogram.getMean()[0]);
                statistics.put("sigma", histogram.getStandardDeviation()[0]);
                statistics.put("p90_threshold", histogram.getPTileThreshold(0.9)[0]);
                statistics.put("p95_threshold", histogram.getPTileThreshold(0.95)[0]);
                statistics.put("total", histogram.getTotals()[0]);
                csvStatisticsWriter.addToOutput(this.dataProvider.getRasterDataNode().getName(), regionIds[i], statistics);
                metadataWriter.addToOutput(this.dataProvider.getRasterDataNode().getName(), regionIds[i], statistics);
                statistics.clear();
            }
            csvStatisticsWriter.finaliseOutput();
            metadataWriter.finaliseOutput();
        }
        catch (IOException exception) {
            Dialogs.showMessage("Statistics export", "Failed to export statistics.\nAn error occurred:" + exception.getMessage(), 0, null);
        }
        finally {
            if (metadataOutputStream != null) {
                metadataOutputStream.close();
            }
            if (csvOutputStream != null) {
                csvOutputStream.close();
            }
        }
        Dialogs.showMessage("Statistics export", "The statistics have successfully been exported to '" + outputAsciiFile + "'.", 1, null);
    }

    public void setSelectedMasks(Mask[] selectedMasks) {
        this.selectedMasks = selectedMasks;
    }
}

