/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session.dom;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;

abstract class ProductNodeDomConverter<T extends ProductNode>
implements DomConverter {
    private final Class<T> type;
    private final ProductManager productManager;

    protected ProductNodeDomConverter(Class<T> type, ProductManager productManager) {
        this.type = type;
        this.productManager = productManager;
    }

    public final Class<T> getValueType() {
        return this.type;
    }

    public final T convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
        Integer refNo;
        DomElement refNoElement = (DomElement)parentElement.getChild("refNo");
        if (refNoElement == null) {
            throw new ConversionException(String.format("In parent element '%s': no child element 'refNo'", parentElement.getName()));
        }
        try {
            refNo = Integer.valueOf(refNoElement.getValue());
        }
        catch (NumberFormatException e) {
            throw new ConversionException(String.format("In parent element '%s': %s", parentElement.getName(), e.getMessage()));
        }
        Product product = this.productManager.getProductByRefNo(refNo.intValue());
        if (product == null) {
            throw new ConversionException(String.format("In parent element '%s': no product with refNo = %d", parentElement.getName(), refNo));
        }
        return this.getProductNode(parentElement, product);
    }

    public final void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
        ProductNode productNode = (ProductNode)value;
        Product product = productNode.getProduct();
        if (product == null) {
            throw new ConversionException("Node does not belong to a product");
        }
        DomElement refNo = parentElement.createChild("refNo");
        refNo.setValue(String.valueOf(product.getRefNo()));
        this.convertProductNodeToDom(productNode, parentElement);
    }

    protected abstract T getProductNode(DomElement var1, Product var2);

    protected abstract void convertProductNodeToDom(T var1, DomElement var2);
}

