/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.session.Bundle;
import org.esa.snap.rcp.session.SaveSessionAction;
import org.esa.snap.rcp.session.SessionManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class SaveSessionAsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    public static final String ID = "saveSessionAs";
    private final Lookup lookup;

    public SaveSessionAsAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SaveSessionAsAction(Lookup lookup) {
        super(Bundle.CTL_SaveSessionAsAction_MenuText());
        this.lookup = lookup;
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        productManager.addListener((ProductManager.Listener)new SaveAsSessionListener());
        Lookup.Result result = lookup.lookupResult(ProductNode.class);
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)result));
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SaveSessionAsAction(lookup);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SaveSessionAction action = new SaveSessionAction();
        action.saveSession(true);
    }

    public void resultChanged(LookupEvent ev) {
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        this.setEnabled(productNode != null || SessionManager.getDefault().getSessionFile() != null);
    }

    private class SaveAsSessionListener
    implements ProductManager.Listener {
        private SaveAsSessionListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            SaveSessionAsAction.this.setEnabled(SnapApp.getDefault().getProductManager().getProductCount() > 0 && SessionManager.getDefault().getSessionFile() != null);
        }
    }
}

