/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.scripting;

import com.bc.ceres.core.Assert;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.esa.snap.core.util.SystemUtils;

public class TransientAction
implements Action,
Serializable {
    private static final long serialVersionUID = 3069372659219673560L;
    private static final Map<String, Action> DELEGATES = new HashMap<String, Action>();
    private String path;
    private Action delegate;

    TransientAction(Action delegate, String path) {
        Assert.notNull((Object)delegate, (String)"delegate");
        Assert.notNull((Object)path, (String)"path");
        Assert.argument((boolean)path.endsWith(".instance"), (String)"path");
        Assert.argument((boolean)path.contains("/"), (String)"path");
        this.path = path;
        this.delegate = delegate;
        Action oldDelegate = DELEGATES.put(path, delegate);
        if (oldDelegate != null) {
            SystemUtils.LOG.info(String.format("Proxy action %s registered once more. Replacing the old action.%n", this.path));
        }
        SystemUtils.LOG.info(String.format("Proxy action added as %s%n", this.path));
    }

    static Action getAction(String path1) {
        return DELEGATES.get(path1);
    }

    static boolean hasAction(String path) {
        return DELEGATES.containsKey(path);
    }

    static Action removeAction(String path1) {
        return DELEGATES.remove(path1);
    }

    public Action getDelegate() {
        return this.delegate;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Object getValue(String key) {
        return this.delegate.getValue(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this.delegate.putValue(key, value);
    }

    @Override
    public void setEnabled(boolean b) {
        this.delegate.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.delegate.actionPerformed(e);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String path = in.readUTF();
        Action delegate = DELEGATES.get(path);
        if (delegate == null) {
            throw new IOException(String.format("Action delegate not found for file %s.\nPlease make sure to call removeAction() before SNAP shuts down.", path));
        }
        this.path = path;
        this.delegate = delegate;
        SystemUtils.LOG.info(String.format("Deserialized proxy action %s%n", this.path));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.path);
        SystemUtils.LOG.info(String.format("Serialized proxy action %s%n", this.path));
    }
}

