/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.quicklooks;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.media.jai.JAI;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.datamodel.quicklooks.Thumbnail;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.OpenRGBImageViewAction;
import org.esa.snap.rcp.quicklooks.Bundle;
import org.esa.snap.rcp.quicklooks.ThumbnailPanel;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="QuicklookToolView", iconBase="org/esa/snap/rcp/icons/quicklook.png", persistenceType=0)
public class QuicklookToolView
extends TopComponent
implements Thumbnail.ThumbnailListener {
    private Product currentProduct;
    private final SortedSet<Product> productSet;
    private final SortedSet<String> quicklookNameSet = new TreeSet<String>();
    private final JComboBox<String> quicklookNameCombo = new JComboBox();
    private final JLabel nameLabel = new JLabel();
    private final ImagePanel imgPanel = new ImagePanel();
    private final BufferedImage noDataImage;
    private JScrollPane imgScrollPanel;
    private JButton nextBtn;
    private JButton prevBtn;
    private JButton startBtn;
    private JButton endBtn;
    private JButton openBtn;
    private JButton closeBtn;
    private JButton refreshBtn;
    private JButton viewBtn;
    private ButtonActionListener actionListener = new ButtonActionListener();
    private boolean updateQuicklooks = false;
    private ProductNode oldNode = null;
    private int zoom = 1;
    private static final String DEFAULT_QUICKLOOK = "Default";
    private static final ImageIcon openIcon = TangoIcons.actions_document_open((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon closeIcon = TangoIcons.actions_list_remove((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon firstIcon = TangoIcons.actions_go_first((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon lastIcon = TangoIcons.actions_go_last((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon nextIcon = TangoIcons.actions_go_next((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon previousIcon = TangoIcons.actions_go_previous((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon refreshIcon = TangoIcons.actions_view_refresh((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon singleViewIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_single24.png", ThumbnailPanel.class);
    private static final ImageIcon thumbnailViewIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_thumbnails24.png", ThumbnailPanel.class);

    public QuicklookToolView() {
        this.setLayout(new BorderLayout());
        this.setDisplayName(Bundle.CTL_QuicklookToolView_Name());
        this.setToolTipText(Bundle.CTL_QuicklookToolView_Description());
        this.add(this.createPanel(), "Center");
        this.noDataImage = QuicklookToolView.createNoDataImage();
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)new ProductManagerListener());
        this.productSet = new TreeSet<Product>(new Comparator<Product>(){

            @Override
            public int compare(Product p1, Product p2) {
                int ref2;
                int ref1 = p1.getRefNo();
                return ref1 < (ref2 = p2.getRefNo()) ? -1 : (ref1 == ref2 ? 0 : 1);
            }
        });
        this.quicklookNameSet.add(DEFAULT_QUICKLOOK);
        this.addProducts();
        this.updateButtons();
        this.quicklookNameCombo.setSelectedItem(DEFAULT_QUICKLOOK);
        this.quicklookNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuicklookToolView.this.showProduct(QuicklookToolView.this.currentProduct);
            }
        });
        snapApp.getSelectionSupport(ProductNode.class).addHandler(new SelectionSupport.Handler<ProductNode>(){

            @Override
            public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                if (newValue != null && newValue != QuicklookToolView.this.oldNode) {
                    QuicklookToolView.this.showProduct(newValue.getProduct());
                    QuicklookToolView.this.oldNode = newValue;
                }
            }
        });
    }

    public JComponent createPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createTopPanel(), "North");
        panel.add((Component)this.createSidePanel(), "East");
        panel.add((Component)this.createImagePanel(), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JPanel createTopPanel() {
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.nameLabel, "Center");
        topPanel.add(this.quicklookNameCombo, "East");
        return topPanel;
    }

    private JPanel createSidePanel() {
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BoxLayout(sidePanel, 1));
        this.openBtn = QuicklookToolView.createButton("Open", "Open RGB", sidePanel, this.actionListener, openIcon);
        sidePanel.add(this.openBtn);
        this.closeBtn = QuicklookToolView.createButton("Close", "Close Product", sidePanel, this.actionListener, closeIcon);
        sidePanel.add(this.closeBtn);
        return sidePanel;
    }

    private JScrollPane createImagePanel() {
        this.imgScrollPanel = new JScrollPane(this.imgPanel);
        this.imgPanel.setComponentPopupMenu(this.createImagePopup());
        return this.imgScrollPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.startBtn = QuicklookToolView.createButton("Start", "Go to first product", buttonPanel, this.actionListener, firstIcon);
        this.prevBtn = QuicklookToolView.createButton("Prev", "Previous product", buttonPanel, this.actionListener, previousIcon);
        this.nextBtn = QuicklookToolView.createButton("Next", "Next product", buttonPanel, this.actionListener, nextIcon);
        this.endBtn = QuicklookToolView.createButton("End", "Go to last product", buttonPanel, this.actionListener, lastIcon);
        this.refreshBtn = QuicklookToolView.createButton("Refresh", "Update products", buttonPanel, this.actionListener, refreshIcon);
        buttonPanel.add(this.startBtn);
        buttonPanel.add(this.prevBtn);
        buttonPanel.add(this.nextBtn);
        buttonPanel.add(this.endBtn);
        buttonPanel.add(this.refreshBtn);
        return buttonPanel;
    }

    private static JButton createButton(String name, String text, JPanel panel, ButtonActionListener actionListener, ImageIcon icon) {
        JButton btn = (JButton)ToolButtonFactory.createButton((Icon)icon, (boolean)false);
        btn.setName(name);
        btn.setIcon(icon);
        if (panel != null) {
            btn.setBackground(panel.getBackground());
        }
        btn.setToolTipText(text);
        btn.setActionCommand(name);
        btn.addActionListener(actionListener);
        return btn;
    }

    private void updateButtons() {
        boolean hasProducts = !this.productSet.isEmpty();
        boolean hasPrevProd = this.getPreviousProduct() != null;
        boolean hasNextProd = this.getNextProduct() != null;
        this.startBtn.setEnabled(hasPrevProd);
        this.prevBtn.setEnabled(hasPrevProd);
        this.nextBtn.setEnabled(hasNextProd);
        this.endBtn.setEnabled(hasNextProd);
        this.openBtn.setEnabled(hasProducts);
        this.closeBtn.setEnabled(hasProducts);
        this.refreshBtn.setEnabled(hasProducts);
        if (!hasProducts) {
            this.imgPanel.setImage(null);
            this.nameLabel.setText("");
            this.currentProduct = null;
        }
    }

    private static BufferedImage createNoDataImage() {
        int w = 100;
        int h = 100;
        BufferedImage image = new BufferedImage(100, 100, 2);
        Graphics2D g = image.createGraphics();
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
        g.setColor(Color.DARK_GRAY);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(0, 0, 100, 100);
        g.drawLine(100, 0, 0, 100);
        g.drawRect(0, 0, 99, 99);
        return image;
    }

    private synchronized void loadProducts(String qlName) {
        try {
            final ArrayList threadList = new ArrayList();
            final int numConsecutiveThreads = Runtime.getRuntime().availableProcessors();
            final ArrayList<Quicklook> quicklooksToLoad = new ArrayList<Quicklook>();
            for (Product product : this.productSet) {
                Quicklook quicklook;
                if (product.getFileLocation() == null || (quicklook = qlName.equals(DEFAULT_QUICKLOOK) ? product.getDefaultQuicklook() : product.getQuicklook(qlName)) == null || quicklook.hasImage() || quicklook.hasCachedImage()) continue;
                quicklooksToLoad.add(quicklook);
            }
            if (quicklooksToLoad.isEmpty()) {
                this.updateQuicklooks = true;
                this.showProduct(this.currentProduct);
                return;
            }
            ProgressMonitorSwingWorker<Boolean, Object> worker = new ProgressMonitorSwingWorker<Boolean, Object>((Component)SnapApp.getDefault().getMainFrame(), "Loading quicklooks"){

                protected Boolean doInBackground(final ProgressMonitor pm) throws Exception {
                    int total = QuicklookToolView.this.productSet.size();
                    pm.beginTask("Generating quicklooks", total);
                    int cnt = 1;
                    for (final Quicklook quicklook : quicklooksToLoad) {
                        if (pm.isCanceled()) break;
                        Thread worker = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    quicklook.getImage(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                                }
                                catch (Throwable e) {
                                    SystemUtils.LOG.warning("Unable to create quicklook for " + quicklook.getProductFile() + '\n' + e.getMessage());
                                }
                            }
                        };
                        threadList.add(worker);
                        worker.start();
                        if (threadList.size() >= numConsecutiveThreads) {
                            for (Thread t : threadList) {
                                t.join();
                            }
                            threadList.clear();
                        }
                        JAI.getDefaultInstance().getTileCache().flush();
                        JAI.getDefaultInstance().getTileCache().memoryControl();
                        System.gc();
                        pm.setTaskName("Generating quicklooks " + cnt + " of " + total);
                        ++cnt;
                    }
                    pm.done();
                    if (!threadList.isEmpty()) {
                        for (Thread t : threadList) {
                            t.join();
                        }
                    }
                    return true;
                }

                protected void done() {
                    super.done();
                    QuicklookToolView.this.updateQuicklooks = true;
                    QuicklookToolView.this.showProduct(QuicklookToolView.this.currentProduct);
                }
            };
            worker.execute();
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to load quicklooks", e);
        }
    }

    public void setSelectedQuicklook(Quicklook ql) {
        this.updateQuicklooks = true;
        this.showProduct(ql.getProduct());
        this.quicklookNameCombo.setSelectedItem(ql.getName());
    }

    private synchronized void showProduct(Product product) {
        if (product == null) {
            return;
        }
        String qlName = (String)this.quicklookNameCombo.getSelectedItem();
        if (qlName != null) {
            Quicklook quicklook = qlName.equals(DEFAULT_QUICKLOOK) ? product.getDefaultQuicklook() : product.getQuicklook(qlName);
            if (quicklook != null) {
                quicklook.addListener((Thumbnail.ThumbnailListener)this);
                if (quicklook.hasImage() || quicklook.hasCachedImage()) {
                    this.setImage(product, quicklook);
                } else if (quicklook != null && this.updateQuicklooks) {
                    if (product.getFileLocation() != null) {
                        QuicklookToolView.loadImage(product, quicklook);
                    }
                } else {
                    this.setImage(product, null);
                }
            } else {
                this.setImage(product, null);
            }
        }
    }

    private static void loadImage(Product product, final Quicklook quicklook) {
        final StatusProgressMonitor qlPM = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        qlPM.beginTask("Creating quicklook " + product.getName() + "... ", 100);
        ProgressMonitorSwingWorker<BufferedImage, Object> loader = new ProgressMonitorSwingWorker<BufferedImage, Object>((Component)SnapApp.getDefault().getMainFrame(), "Loading quicklook image..."){

            protected BufferedImage doInBackground(ProgressMonitor pm) throws Exception {
                return quicklook.getImage((ProgressMonitor)qlPM);
            }

            protected void done() {
                qlPM.done();
            }
        };
        loader.execute();
    }

    private void setImage(Product product, Quicklook quicklook) {
        BufferedImage img = quicklook != null && (quicklook.hasImage() || quicklook.hasCachedImage()) ? quicklook.getImage(ProgressMonitor.NULL) : this.noDataImage;
        if (this.currentProduct == product && this.imgPanel.getImage() == img) {
            return;
        }
        this.currentProduct = product;
        this.nameLabel.setText(product.getDisplayName());
        this.imgPanel.setImage(img);
        this.updateButtons();
    }

    private void addProducts() {
        Product[] products;
        for (Product product : products = SnapApp.getDefault().getProductManager().getProducts()) {
            this.addProduct(product);
        }
    }

    private synchronized void addProduct(Product product) {
        this.productSet.add(product);
        for (int i = 0; i < product.getQuicklookGroup().getNodeCount(); ++i) {
            this.quicklookNameSet.add(((Quicklook)product.getQuicklookGroup().get(i)).getName());
        }
        this.updateQuicklookNameCombo();
    }

    private synchronized void removeProduct(Product product) {
        this.productSet.remove(product);
        this.cleanUpQuicklookNameSet();
        this.updateQuicklookNameCombo();
    }

    private void cleanUpQuicklookNameSet() {
        HashSet<String> toRemove = new HashSet<String>();
        for (String name : this.quicklookNameSet) {
            if (name.equals(DEFAULT_QUICKLOOK)) continue;
            boolean exists = false;
            block1: for (Product product : this.productSet) {
                for (int i = 0; i < product.getQuicklookGroup().getNodeCount(); ++i) {
                    if (!name.equals(((Quicklook)product.getQuicklookGroup().get(i)).getName())) continue;
                    exists = true;
                    continue block1;
                }
            }
            if (exists) continue;
            toRemove.add(name);
        }
        for (String name : toRemove) {
            this.quicklookNameSet.remove(name);
        }
    }

    private void updateQuicklookNameCombo() {
        String selected = (String)this.quicklookNameCombo.getSelectedItem();
        this.quicklookNameCombo.removeAllItems();
        for (String name : this.quicklookNameSet) {
            this.quicklookNameCombo.addItem(name);
        }
        if (selected != null && ((DefaultComboBoxModel)this.quicklookNameCombo.getModel()).getIndexOf(selected) != -1) {
            this.quicklookNameCombo.setSelectedItem(selected);
        } else {
            this.quicklookNameCombo.setSelectedItem(DEFAULT_QUICKLOOK);
        }
    }

    private Product getFirstProduct() {
        return this.productSet.isEmpty() ? null : this.productSet.first();
    }

    private Product getLastProduct() {
        return this.productSet.isEmpty() ? null : this.productSet.last();
    }

    private Product getNextProduct() {
        Iterator itr = this.productSet.iterator();
        while (itr.hasNext()) {
            Product p = (Product)itr.next();
            if (p != this.currentProduct) continue;
            if (itr.hasNext()) {
                return (Product)itr.next();
            }
            return null;
        }
        return null;
    }

    private Product getPreviousProduct() {
        Iterator itr = this.productSet.iterator();
        Product prev = null;
        while (itr.hasNext()) {
            Product p = (Product)itr.next();
            if (p == this.currentProduct) {
                return prev;
            }
            prev = p;
        }
        return null;
    }

    private void openProduct() {
        OpenRGBImageViewAction rgbAction = new OpenRGBImageViewAction((ProductNode)this.currentProduct);
        rgbAction.openProductSceneViewRGB(this.currentProduct, "");
    }

    private void closeProduct() {
        if (this.currentProduct != null) {
            Product productToClose = this.currentProduct;
            if (productToClose == this.getLastProduct()) {
                this.showProduct(this.getPreviousProduct());
            } else {
                this.showProduct(this.getNextProduct());
            }
            SnapApp.getDefault().getProductManager().removeProduct(productToClose);
        }
    }

    public JPopupMenu createImagePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem zoomInItem = new JMenuItem("Zoom in");
        zoomInItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QuicklookToolView.this.zoom < 10) {
                    QuicklookToolView.this.zoom = QuicklookToolView.this.zoom + 2;
                }
            }
        });
        popup.add(zoomInItem);
        JMenuItem zoomOutItem = new JMenuItem("Zoom out");
        zoomOutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QuicklookToolView.this.zoom > 2) {
                    QuicklookToolView.this.zoom = QuicklookToolView.this.zoom - 2;
                }
            }
        });
        popup.add(zoomOutItem);
        popup.addSeparator();
        JMenuItem closeItem = new JMenuItem("Close Product");
        closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuicklookToolView.this.closeProduct();
            }
        });
        popup.add(closeItem);
        return popup;
    }

    public void notifyImageUpdated(Thumbnail thumbnail) {
        this.showProduct(thumbnail.getProduct());
    }

    public class ProductManagerListener
    implements ProductManager.Listener {
        public void productAdded(ProductManager.Event event) {
            QuicklookToolView.this.addProduct(event.getProduct());
            QuicklookToolView.this.updateButtons();
        }

        public void productRemoved(ProductManager.Event event) {
            if (event.getProduct() == QuicklookToolView.this.currentProduct) {
                QuicklookToolView.this.getNextProduct();
            }
            QuicklookToolView.this.removeProduct(event.getProduct());
            QuicklookToolView.this.updateButtons();
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "Start": {
                    QuicklookToolView.this.showProduct(QuicklookToolView.this.getFirstProduct());
                    break;
                }
                case "Prev": {
                    QuicklookToolView.this.showProduct(QuicklookToolView.this.getPreviousProduct());
                    break;
                }
                case "Next": {
                    QuicklookToolView.this.showProduct(QuicklookToolView.this.getNextProduct());
                    break;
                }
                case "End": {
                    QuicklookToolView.this.showProduct(QuicklookToolView.this.getLastProduct());
                    break;
                }
                case "Refresh": {
                    if (QuicklookToolView.this.productSet.isEmpty()) break;
                    QuicklookToolView.this.loadProducts((String)QuicklookToolView.this.quicklookNameCombo.getSelectedItem());
                    break;
                }
                case "Open": {
                    QuicklookToolView.this.openProduct();
                    break;
                }
                case "Close": {
                    QuicklookToolView.this.closeProduct();
                }
            }
        }
    }

    private class ImagePanel
    extends JLabel
    implements MouseListener {
        private BufferedImage img = null;

        public ImagePanel() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.addMouseListener(this);
        }

        public BufferedImage getImage() {
            return this.img;
        }

        public void setImage(BufferedImage img) {
            this.img = img;
            if (img == null) {
                this.setIcon(null);
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.img != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                int w = QuicklookToolView.this.imgScrollPanel.getWidth() * QuicklookToolView.this.zoom - 10;
                int h = QuicklookToolView.this.imgScrollPanel.getHeight() * QuicklookToolView.this.zoom - 10;
                this.setIcon(new ImageIcon(new FixedSizeThumbnailMaker().size(w, h).keepAspectRatio(true).fitWithinDimensions(true).make(this.img)));
            }
            super.paintComponent(g);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 && QuicklookToolView.this.currentProduct != null) {
                QuicklookToolView.this.openProduct();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

