/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.magicwand;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.undo.UndoContext;
import com.bc.ceres.swing.undo.support.DefaultUndoContext;
import com.thoughtworks.xstream.XStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.magicwand.MagicWandInteractor;
import org.esa.snap.rcp.magicwand.MagicWandModel;
import org.esa.snap.rcp.magicwand.SpectralBandComparator;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.product.BandChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.ImageUtilities;

class MagicWandForm {
    public static final int TOLERANCE_SLIDER_RESOLUTION = 1000;
    public static final String PREFERENCES_KEY_LAST_DIR = "beam.magicWandTool.lastDir";
    private MagicWandInteractor interactor;
    private JSlider toleranceSlider;
    boolean adjustingSlider;
    private DefaultUndoContext undoContext;
    private AbstractButton redoButton;
    private AbstractButton undoButton;
    private BindingContext bindingContext;
    private File settingsFile;
    private JLabel infoLabel;
    private AbstractButton minusButton;
    private AbstractButton plusButton;
    private AbstractButton clearButton;
    private AbstractButton saveButton;

    MagicWandForm(MagicWandInteractor interactor) {
        this.interactor = interactor;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public JPanel createPanel() {
        this.undoContext = new DefaultUndoContext((Object)this);
        this.interactor.setUndoContext((UndoContext)this.undoContext);
        this.bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.interactor.getModel()));
        this.bindingContext.addPropertyChangeListener("tolerance", evt -> {
            this.adjustSlider();
            this.interactor.getModel().fireModelChanged(true);
        });
        this.infoLabel = new JLabel();
        this.infoLabel.setForeground(Color.DARK_GRAY);
        JLabel toleranceLabel = new JLabel("Tolerance:");
        toleranceLabel.setToolTipText("Sets the maximum Euclidian distance tolerated");
        JTextField toleranceField = new JTextField(10);
        this.bindingContext.bind("tolerance", toleranceField);
        toleranceField.setText(String.valueOf(this.interactor.getModel().getTolerance()));
        this.toleranceSlider = new JSlider(0, 1000);
        this.toleranceSlider.setSnapToTicks(false);
        this.toleranceSlider.setPaintTicks(false);
        this.toleranceSlider.setPaintLabels(false);
        this.toleranceSlider.addChangeListener(e -> {
            if (!this.adjustingSlider) {
                int sliderValue = this.toleranceSlider.getValue();
                this.bindingContext.getPropertySet().setValue("tolerance", (Object)this.sliderValueToTolerance(sliderValue));
            }
        });
        JTextField minToleranceField = new JTextField(4);
        JTextField maxToleranceField = new JTextField(4);
        this.bindingContext.bind("minTolerance", minToleranceField);
        this.bindingContext.bind("maxTolerance", maxToleranceField);
        PropertyChangeListener minMaxToleranceListener = evt -> this.adjustSlider();
        this.bindingContext.addPropertyChangeListener("minTolerance", minMaxToleranceListener);
        this.bindingContext.addPropertyChangeListener("maxTolerance", minMaxToleranceListener);
        JPanel toleranceSliderPanel = new JPanel(new BorderLayout(2, 2));
        toleranceSliderPanel.add((Component)minToleranceField, "West");
        toleranceSliderPanel.add((Component)this.toleranceSlider, "Center");
        toleranceSliderPanel.add((Component)maxToleranceField, "East");
        JCheckBox normalizeCheckBox = new JCheckBox("Normalize spectra");
        normalizeCheckBox.setToolTipText("Normalizes collected band sets by dividing their\nindividual values by the value of the first band");
        this.bindingContext.bind("normalize", normalizeCheckBox);
        this.bindingContext.addPropertyChangeListener("normalize", evt -> this.interactor.getModel().fireModelChanged(true));
        JLabel stLabel = new JLabel("Spectrum transformation:");
        JRadioButton stButton1 = new JRadioButton("Integral");
        JRadioButton stButton2 = new JRadioButton("Identity");
        JRadioButton stButton3 = new JRadioButton("Derivative");
        ButtonGroup stGroup = new ButtonGroup();
        stGroup.add(stButton1);
        stGroup.add(stButton2);
        stGroup.add(stButton3);
        stButton1.setToolTipText("<html>Pixel similarity comparison is performed<br>on the sums of subsequent band values");
        stButton2.setToolTipText("<html>Pixel similarity comparison is performed<br>on the original or normalised band values");
        stButton3.setToolTipText("<html>Pixel similarity comparison is performed<br>on the differences of subsequent band values");
        this.bindingContext.bind("spectrumTransform", stGroup);
        this.bindingContext.addPropertyChangeListener("spectrumTransform", evt -> this.interactor.getModel().fireModelChanged(true));
        JLabel ptLabel = new JLabel("Similarity metric:");
        JRadioButton ptButton1 = new JRadioButton("Distance");
        JRadioButton ptButton2 = new JRadioButton("Average");
        JRadioButton ptButton3 = new JRadioButton("Min-Max");
        ptButton1.setToolTipText("<html>Tests if the minimum of Euclidian distances of a pixel to<br>each collected bands set is below the threshold");
        ptButton2.setToolTipText("<html>Tests if the Euclidian distances of a pixel to<br>the average of all collected bands sets is below the threshold");
        ptButton3.setToolTipText("<html>Tests if a pixel is within the min/max limits<br>of collected bands plus/minus tolerance");
        ButtonGroup ptGroup = new ButtonGroup();
        ptGroup.add(ptButton1);
        ptGroup.add(ptButton2);
        ptGroup.add(ptButton3);
        this.bindingContext.bind("pixelTest", ptGroup);
        this.bindingContext.addPropertyChangeListener("pixelTest", evt -> this.interactor.getModel().fireModelChanged(true));
        this.plusButton = MagicWandForm.createToggleButton(TangoIcons.actions_list_add((TangoIcons.Res)TangoIcons.Res.R16));
        this.plusButton.setToolTipText("<html>Switches to pick mode 'plus':<br>collect spectra used for inclusion");
        this.plusButton.addActionListener(e -> {
            if (this.interactor.getModel().getPickMode() != MagicWandModel.PickMode.PLUS) {
                this.interactor.getModel().setPickMode(MagicWandModel.PickMode.PLUS);
            } else {
                this.interactor.getModel().setPickMode(MagicWandModel.PickMode.SINGLE);
            }
        });
        this.minusButton = MagicWandForm.createToggleButton(TangoIcons.actions_list_remove((TangoIcons.Res)TangoIcons.Res.R16));
        this.minusButton.setToolTipText("<html>Switches to pick mode 'minus':<br>collect spectra used for exclusion.");
        this.minusButton.addActionListener(e -> {
            if (this.interactor.getModel().getPickMode() != MagicWandModel.PickMode.MINUS) {
                this.interactor.getModel().setPickMode(MagicWandModel.PickMode.MINUS);
            } else {
                this.interactor.getModel().setPickMode(MagicWandModel.PickMode.SINGLE);
            }
        });
        this.bindingContext.addPropertyChangeListener("pickMode", evt -> this.interactor.getModel().fireModelChanged(false));
        AbstractButton newButton = MagicWandForm.createButton(TangoIcons.actions_document_new((TangoIcons.Res)TangoIcons.R16));
        newButton.setToolTipText("New settings");
        newButton.addActionListener(e -> this.newSettings());
        AbstractButton openButton = MagicWandForm.createButton(TangoIcons.actions_document_open((TangoIcons.Res)TangoIcons.R16));
        openButton.setToolTipText("Open settings");
        openButton.addActionListener(e -> this.openSettings((Component)e.getSource()));
        this.saveButton = MagicWandForm.createButton(TangoIcons.actions_document_save((TangoIcons.Res)TangoIcons.R16));
        this.saveButton.setToolTipText("Save settings");
        this.saveButton.addActionListener(e -> this.saveSettings((Component)e.getSource(), this.settingsFile));
        AbstractButton saveAsButton = MagicWandForm.createButton(TangoIcons.actions_document_save_as((TangoIcons.Res)TangoIcons.R16));
        saveAsButton.setToolTipText("Save settings as");
        saveAsButton.addActionListener(e -> this.saveSettings((Component)e.getSource(), null));
        this.undoButton = MagicWandForm.createButton(TangoIcons.actions_edit_undo((TangoIcons.Res)TangoIcons.R16));
        this.undoButton.addActionListener(e -> {
            if (this.undoContext.canUndo()) {
                this.undoContext.undo();
            }
        });
        this.redoButton = MagicWandForm.createButton(TangoIcons.actions_edit_redo((TangoIcons.Res)TangoIcons.Res.R16));
        this.redoButton.addActionListener(e -> {
            if (this.undoContext.canRedo()) {
                this.undoContext.redo();
            }
        });
        this.undoContext.addUndoableEditListener(e -> this.updateState());
        this.clearButton = MagicWandForm.createButton(TangoIcons.actions_edit_clear((TangoIcons.Res)TangoIcons.Res.R16));
        this.clearButton.setName("clearButton");
        this.clearButton.setToolTipText("Removes all collected band ses.");
        this.clearButton.addActionListener(e -> this.clearSpectra());
        AbstractButton filterButton = MagicWandForm.createButton(ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/Filter24.gif", (boolean)false));
        filterButton.setName("filterButton");
        filterButton.setToolTipText("Select bands to included.");
        filterButton.addActionListener(e -> this.showBandChooser());
        AbstractButton helpButton = MagicWandForm.createButton(TangoIcons.apps_help_browser((TangoIcons.Res)TangoIcons.Res.R16));
        helpButton.setName("helpButton");
        helpButton.setToolTipText("Help.");
        JPanel toolPanelN = new JPanel(new GridLayout(-1, 2));
        toolPanelN.add(newButton);
        toolPanelN.add(openButton);
        toolPanelN.add(this.saveButton);
        toolPanelN.add(saveAsButton);
        toolPanelN.add(this.clearButton);
        toolPanelN.add(filterButton);
        toolPanelN.add(this.undoButton);
        toolPanelN.add(this.redoButton);
        toolPanelN.add(this.plusButton);
        toolPanelN.add(this.minusButton);
        JPanel toolPanelS = new JPanel(new GridLayout(-1, 2));
        toolPanelS.add(new JLabel());
        toolPanelS.add(helpButton);
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTablePadding(2, 2);
        tableLayout.setCellColspan(1, 0, Integer.valueOf(tableLayout.getColumnCount()));
        Insets insets = new Insets(2, 10, 2, 2);
        tableLayout.setCellPadding(3, 0, insets);
        tableLayout.setCellPadding(4, 0, insets);
        tableLayout.setCellPadding(5, 0, insets);
        tableLayout.setCellPadding(6, 0, insets);
        tableLayout.setCellPadding(3, 1, insets);
        tableLayout.setCellPadding(4, 1, insets);
        tableLayout.setCellPadding(5, 1, insets);
        JPanel subPanel = new JPanel((LayoutManager)tableLayout);
        subPanel.add((Component)toleranceLabel, TableLayout.cell((int)0, (int)0));
        subPanel.add((Component)toleranceField, TableLayout.cell((int)0, (int)1));
        subPanel.add((Component)toleranceSliderPanel, TableLayout.cell((int)1, (int)0));
        subPanel.add((Component)stLabel, TableLayout.cell((int)2, (int)0));
        subPanel.add((Component)stButton1, TableLayout.cell((int)3, (int)0));
        subPanel.add((Component)stButton2, TableLayout.cell((int)4, (int)0));
        subPanel.add((Component)stButton3, TableLayout.cell((int)5, (int)0));
        subPanel.add((Component)ptLabel, TableLayout.cell((int)2, (int)1));
        subPanel.add((Component)ptButton1, TableLayout.cell((int)3, (int)1));
        subPanel.add((Component)ptButton2, TableLayout.cell((int)4, (int)1));
        subPanel.add((Component)ptButton3, TableLayout.cell((int)5, (int)1));
        subPanel.add((Component)normalizeCheckBox, TableLayout.cell((int)6, (int)0));
        subPanel.add((Component)this.infoLabel, TableLayout.cell((int)6, (int)1));
        JPanel toolPanel = new JPanel(new BorderLayout(4, 4));
        toolPanel.add((Component)toolPanelN, "North");
        toolPanel.add((Component)new JLabel(), "Center");
        toolPanel.add((Component)toolPanelS, "South");
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)subPanel, "Center");
        panel.add((Component)toolPanel, "East");
        this.adjustSlider();
        this.updateState();
        return panel;
    }

    private void newSettings() {
        if (this.proceedWithUnsavedChanges()) {
            this.settingsFile = null;
            this.interactor.getModel().clearSpectra();
        }
    }

    private void clearSpectra() {
        this.interactor.clearSpectra();
    }

    private void openSettings(Component parent) {
        if (this.proceedWithUnsavedChanges()) {
            File settingsFile = MagicWandForm.getFile(parent, this.settingsFile, true);
            if (settingsFile == null) {
                return;
            }
            try {
                MagicWandModel model = (MagicWandModel)this.createXStream().fromXML(FileUtils.readText((File)settingsFile));
                this.settingsFile = settingsFile;
                this.interactor.assignModel(model);
                this.undoContext.getUndoManager().discardAllEdits();
                this.interactor.setModelModified(false);
                this.updateState();
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Failed to open settings:\n{0}", e.getMessage());
                AbstractDialog.showErrorDialog((Component)parent, (String)msg, (String)"I/O Error");
            }
        }
    }

    private void saveSettings(Component parent, File settingsFile) {
        if (settingsFile == null && (settingsFile = MagicWandForm.getFile(parent, this.settingsFile, false)) == null) {
            return;
        }
        try {
            try (FileWriter writer = new FileWriter(settingsFile);){
                writer.write(this.createXStream().toXML((Object)this.interactor.getModel()));
            }
            this.settingsFile = settingsFile;
            this.undoContext.getUndoManager().discardAllEdits();
            this.interactor.setModelModified(false);
            this.interactor.updateForm();
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Failed to safe settings:\n{0}", e.getMessage());
            AbstractDialog.showErrorDialog((Component)parent, (String)msg, (String)"I/O Error");
        }
    }

    private XStream createXStream() {
        XStream xStream = new XStream();
        xStream.setClassLoader(MagicWandModel.class.getClassLoader());
        xStream.alias("magicWandSettings", MagicWandModel.class);
        return xStream;
    }

    private static File getFile(Component parent, File file, boolean open) {
        int resp2;
        JFileChooser fileChooser = new JFileChooser(Preferences.userRoot().get(PREFERENCES_KEY_LAST_DIR, System.getProperty("user.home")));
        if (file != null) {
            fileChooser.setSelectedFile(file);
        } else {
            fileChooser.setSelectedFile(new File(fileChooser.getCurrentDirectory(), "magic-wand-settings.xml"));
        }
        do {
            int resp = open ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
            File settingsFile = fileChooser.getSelectedFile();
            Preferences.userRoot().put(PREFERENCES_KEY_LAST_DIR, fileChooser.getCurrentDirectory().getPath());
            if (resp != 0) {
                return null;
            }
            if (open || !settingsFile.exists()) {
                return settingsFile;
            }
            String msg = MessageFormat.format("Settings file ''{0}'' already exists.\nOverwrite?", settingsFile.getName());
            resp2 = JOptionPane.showConfirmDialog(parent, msg, "File exists", 1);
            if (resp2 != 0) continue;
            return settingsFile;
        } while (resp2 != 2);
        return null;
    }

    void updateState() {
        this.bindingContext.setComponentsEnabled("spectrumTransform", this.interactor.getModel().getBandCount() != 1);
        this.bindingContext.setComponentsEnabled("normalize", this.interactor.getModel().getBandCount() != 1);
        MagicWandModel model = this.interactor.getModel();
        this.infoLabel.setText(String.format("%d(+), %d(-), %d bands", model.getPlusSpectrumCount(), model.getMinusSpectrumCount(), model.getBandCount()));
        this.plusButton.setSelected(model.getPickMode() == MagicWandModel.PickMode.PLUS);
        this.minusButton.setSelected(model.getPickMode() == MagicWandModel.PickMode.MINUS);
        this.saveButton.setEnabled(this.settingsFile != null && this.interactor.isModelModified());
        this.clearButton.setEnabled(model.getSpectrumCount() > 0);
        this.undoButton.setEnabled(this.undoContext.canUndo());
        this.redoButton.setEnabled(this.undoContext.canRedo());
    }

    private void adjustSlider() {
        this.adjustingSlider = true;
        double tolerance = this.interactor.getModel().getTolerance();
        this.toleranceSlider.setValue(this.toleranceToSliderValue(tolerance));
        this.adjustingSlider = false;
    }

    private int toleranceToSliderValue(double tolerance) {
        MagicWandModel model = this.interactor.getModel();
        double minTolerance = model.getMinTolerance();
        double maxTolerance = model.getMaxTolerance();
        return (int)Math.round(Math.abs(1000.0 * ((tolerance - minTolerance) / (maxTolerance - minTolerance))));
    }

    private double sliderValueToTolerance(int sliderValue) {
        MagicWandModel model = this.interactor.getModel();
        double minTolerance = model.getMinTolerance();
        double maxTolerance = model.getMaxTolerance();
        return minTolerance + (double)sliderValue * (maxTolerance - minTolerance) / 1000.0;
    }

    private static AbstractButton createButton(ImageIcon imageIcon) {
        return ToolButtonFactory.createButton((Icon)imageIcon, (boolean)false);
    }

    private static AbstractButton createToggleButton(ImageIcon imageIcon) {
        return ToolButtonFactory.createButton((Icon)imageIcon, (boolean)true);
    }

    void showBandChooser() {
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view == null) {
            Dialogs.showInformation("Please select an image view first.", null);
            return;
        }
        Product product = view.getProduct();
        Band[] bands = product.getBands();
        if (bands.length == 0) {
            Dialogs.showInformation("No bands in product.", null);
            return;
        }
        HashSet<String> oldBandNames = new HashSet<String>(this.interactor.getModel().getBandNames());
        HashSet<Band> oldBandSet = new HashSet<Band>();
        for (Band band : bands) {
            if (!oldBandNames.contains(band.getName())) continue;
            oldBandSet.add(band);
        }
        BandChooser bandChooser = new BandChooser(this.interactor.getOptionsWindow(), "Available Bands and Tie Point Grids", "", bands, oldBandSet.toArray(new Band[oldBandSet.size()]), product.getAutoGrouping(), true);
        if (bandChooser.show() == 1) {
            Band[] newBands = bandChooser.getSelectedBands();
            Arrays.sort(newBands, new SpectralBandComparator());
            ArrayList<String> newBandNames = new ArrayList<String>();
            for (Band newBand : newBands) {
                newBandNames.add(newBand.getName());
            }
            if (!oldBandNames.containsAll(newBandNames) || !newBandNames.containsAll(oldBandNames)) {
                this.interactor.getModel().setBandNames(newBandNames);
            }
        }
    }

    private boolean proceedWithUnsavedChanges() {
        if (this.settingsFile != null && this.interactor.isModelModified()) {
            String msg = MessageFormat.format("You have unsaved changes.\nProceed anyway?", this.settingsFile.getName());
            int resp = JOptionPane.showConfirmDialog(this.interactor.getOptionsWindow(), msg, "New Settings", 0);
            return resp == 0;
        }
        return true;
    }
}

