/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.ows.ServiceException;
import org.opengis.geometry.Envelope;

@LayerTypeMetadata(name="WmsLayerType", aliasNames={"org.esa.snap.rcp.layermanager.layersrc.wms.WmsLayerType"})
public class WmsLayerType
extends ImageLayer.Type {
    public static final String PROPERTY_NAME_RASTER = "raster";
    public static final String PROPERTY_NAME_URL = "serverUrl";
    public static final String PROPERTY_NAME_LAYER_INDEX = "layerIndex";
    public static final String PROPERTY_NAME_CRS_ENVELOPE = "crsEnvelope";
    public static final String PROPERTY_NAME_STYLE_NAME = "styleName";
    public static final String PROPERTY_NAME_IMAGE_SIZE = "imageSize";

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        WebMapServer mapServer;
        try {
            mapServer = WmsLayerType.getWmsServer(configuration);
        }
        catch (Exception e) {
            String message = String.format("Not able to access Web Mapping Server: %s", (Object[])configuration.getValue(PROPERTY_NAME_URL));
            throw new RuntimeException(message, e);
        }
        int layerIndex = (Integer)configuration.getValue(PROPERTY_NAME_LAYER_INDEX);
        org.geotools.data.ows.Layer wmsLayer = WmsLayerType.getLayer(mapServer, layerIndex);
        DefaultMultiLevelSource multiLevelSource = WmsLayerType.createMultiLevelSource(configuration, mapServer, wmsLayer);
        ImageLayer.Type imageLayerType = (ImageLayer.Type)LayerTypeRegistry.getLayerType(ImageLayer.Type.class);
        PropertySet config = imageLayerType.createLayerConfig(ctx);
        config.setValue("multiLevelSource", (Object)multiLevelSource);
        config.setValue("borderShown", (Object)false);
        config.setValue("pixelBorderShown", (Object)false);
        ImageLayer wmsImageLayer = new ImageLayer((ImageLayer.Type)this, (MultiLevelSource)multiLevelSource, config);
        wmsImageLayer.setName(wmsLayer.getName());
        return wmsImageLayer;
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertyContainer template = new PropertyContainer();
        template.addProperty(Property.create((String)PROPERTY_NAME_RASTER, RasterDataNode.class));
        template.addProperty(Property.create((String)PROPERTY_NAME_URL, URL.class));
        template.addProperty(Property.create((String)PROPERTY_NAME_LAYER_INDEX, Integer.class));
        template.addProperty(Property.create((String)PROPERTY_NAME_STYLE_NAME, String.class));
        template.addProperty(Property.create((String)PROPERTY_NAME_IMAGE_SIZE, Dimension.class));
        template.addProperty(Property.create((String)PROPERTY_NAME_CRS_ENVELOPE, CRSEnvelope.class));
        template.getDescriptor(PROPERTY_NAME_CRS_ENVELOPE).setDomConverter((DomConverter)new CRSEnvelopeDomConverter());
        return template;
    }

    private static DefaultMultiLevelSource createMultiLevelSource(PropertySet configuration, WebMapServer wmsServer, org.geotools.data.ows.Layer layer) {
        DefaultMultiLevelSource multiLevelSource;
        String styleName = (String)configuration.getValue(PROPERTY_NAME_STYLE_NAME);
        Dimension size = (Dimension)configuration.getValue(PROPERTY_NAME_IMAGE_SIZE);
        try {
            List styleList = layer.getStyles();
            StyleImpl style = null;
            if (!styleList.isEmpty()) {
                style = (StyleImpl)styleList.get(0);
                for (StyleImpl currentstyle : styleList) {
                    if (!currentstyle.getName().equals(styleName)) continue;
                    style = currentstyle;
                }
            }
            CRSEnvelope crsEnvelope = (CRSEnvelope)configuration.getValue(PROPERTY_NAME_CRS_ENVELOPE);
            GetMapRequest mapRequest = wmsServer.createGetMapRequest();
            mapRequest.addLayer(layer, style);
            mapRequest.setTransparent(true);
            mapRequest.setDimensions(size.width, size.height);
            mapRequest.setSRS(crsEnvelope.getEPSGCode());
            mapRequest.setBBox((Envelope)crsEnvelope);
            mapRequest.setFormat("image/png");
            PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)WmsLayerType.downloadWmsImage(mapRequest, wmsServer));
            RasterDataNode raster = (RasterDataNode)configuration.getValue(PROPERTY_NAME_RASTER);
            int sceneWidth = raster.getRasterWidth();
            int sceneHeight = raster.getRasterHeight();
            AffineTransform i2mTransform = Product.findImageToModelTransform((GeoCoding)raster.getGeoCoding());
            i2mTransform.scale((double)sceneWidth / (double)image.getWidth(), (double)sceneHeight / (double)image.getHeight());
            Rectangle2D bounds = DefaultMultiLevelModel.getModelBounds((AffineTransform)i2mTransform, (RenderedImage)image);
            DefaultMultiLevelModel multiLevelModel = new DefaultMultiLevelModel(1, i2mTransform, bounds);
            multiLevelSource = new DefaultMultiLevelSource((RenderedImage)image, (MultiLevelModel)multiLevelModel);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to access WMS: %s", (Object[])configuration.getValue(PROPERTY_NAME_URL)), e);
        }
        return multiLevelSource;
    }

    private static org.geotools.data.ows.Layer getLayer(WebMapServer server, int layerIndex) {
        return (org.geotools.data.ows.Layer)server.getCapabilities().getLayerList().get(layerIndex);
    }

    private static WebMapServer getWmsServer(PropertySet configuration) throws IOException, ServiceException {
        return new WebMapServer((URL)configuration.getValue(PROPERTY_NAME_URL));
    }

    private static BufferedImage downloadWmsImage(GetMapRequest mapRequest, WebMapServer wms) throws IOException, ServiceException {
        GetMapResponse mapResponse = wms.issueRequest(mapRequest);
        try (InputStream inputStream = mapResponse.getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    private static class CRSEnvelopeDomConverter
    implements DomConverter {
        private static final String SRS_NAME = "srsName";
        private static final String MIN_X = "minX";
        private static final String MIN_Y = "minY";
        private static final String MAX_X = "maxX";
        private static final String MAX_Y = "maxY";

        private CRSEnvelopeDomConverter() {
        }

        public Class<?> getValueType() {
            return CRSEnvelope.class;
        }

        public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
            try {
                String srsName = ((DomElement)parentElement.getChild(SRS_NAME)).getValue();
                double minX = Double.parseDouble(((DomElement)parentElement.getChild(MIN_X)).getValue());
                double minY = Double.parseDouble(((DomElement)parentElement.getChild(MIN_Y)).getValue());
                double maxX = Double.parseDouble(((DomElement)parentElement.getChild(MAX_X)).getValue());
                double maxY = Double.parseDouble(((DomElement)parentElement.getChild(MAX_Y)).getValue());
                value = new CRSEnvelope(srsName, minX, minY, maxX, maxY);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            return value;
        }

        public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            CRSEnvelope crsEnvelope = (CRSEnvelope)value;
            DomElement srsName = parentElement.createChild(SRS_NAME);
            srsName.setValue(crsEnvelope.getSRSName());
            DomElement minX = parentElement.createChild(MIN_X);
            minX.setValue(Double.toString(crsEnvelope.getMinX()));
            DomElement minY = parentElement.createChild(MIN_Y);
            minY.setValue(Double.toString(crsEnvelope.getMinY()));
            DomElement maxX = parentElement.createChild(MAX_X);
            maxX.setValue(Double.toString(crsEnvelope.getMaxX()));
            DomElement maxY = parentElement.createChild(MAX_Y);
            maxY.setValue(Double.toString(crsEnvelope.getMaxY()));
        }
    }
}

