/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.FeatureLayerType;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.SLDUtils;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.Fill;

class ShapefileLoader
extends ProgressMonitorSwingWorker<Layer, Object> {
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private final LayerSourcePageContext context;

    ShapefileLoader(LayerSourcePageContext context) {
        super((Component)context.getWindow(), "Loading Shapefile");
        this.context = context;
    }

    protected LayerSourcePageContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layer doInBackground(ProgressMonitor pm) throws Exception {
        try {
            pm.beginTask("Reading shapes", -1);
            ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
            Geometry clipGeometry = FeatureUtils.createGeoBoundaryPolygon((Product)sceneView.getProduct());
            File file = new File((String)this.context.getPropertyValue("fileName"));
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = this.getFeatureCollection(file);
            CoordinateReferenceSystem featureCrs = (CoordinateReferenceSystem)this.context.getPropertyValue("featureCollectionCrs");
            Style[] styles = this.getStyles(file, featureCollection);
            Style selectedStyle = this.getSelectedStyle(styles);
            LayerType type = LayerTypeRegistry.getLayerType((String)FeatureLayerType.class.getName());
            PropertySet configuration = type.createLayerConfig((LayerContext)sceneView);
            configuration.setValue("featureCollectionUrl", (Object)file.toURI().toURL());
            configuration.setValue("featureCollection", featureCollection);
            configuration.setValue("featureCollectionTargetCrs", (Object)featureCrs);
            configuration.setValue("featureCollectionClipGeometry", (Object)clipGeometry);
            configuration.setValue("sldStyle", (Object)selectedStyle);
            Layer featureLayer = type.createLayer((LayerContext)sceneView, configuration);
            featureLayer.setName(file.getName());
            featureLayer.setVisible(true);
            Layer layer = featureLayer;
            return layer;
        }
        finally {
            pm.done();
        }
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatureCollection(File file) throws IOException {
        Object featureCollectionValue = this.context.getPropertyValue("featureCollection");
        FeatureCollection featureCollection = featureCollectionValue == null ? FeatureUtils.getFeatureSource((URL)file.toURI().toURL()).getFeatures() : (FeatureCollection)featureCollectionValue;
        return featureCollection;
    }

    private Style getSelectedStyle(Style[] styles) {
        Style selectedStyle = (Style)this.context.getPropertyValue("selectedStyle");
        if (selectedStyle == null) {
            selectedStyle = styles[0];
            this.context.setPropertyValue("selectedStyle", (Object)styles[0]);
        }
        return selectedStyle;
    }

    private Style[] getStyles(File file, FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        Style[] styles = (Style[])this.context.getPropertyValue("styles");
        if (styles == null || styles.length == 0) {
            styles = ShapefileLoader.createStyle(file, featureCollection.getSchema());
            this.context.setPropertyValue("styles", (Object)styles);
        }
        return styles;
    }

    private static Style[] createStyle(File shapeFile, FeatureType schema) {
        Style[] styles = SLDUtils.loadSLD(shapeFile);
        if (styles != null && styles.length > 0) {
            return styles;
        }
        Class type = schema.getGeometryDescriptor().getType().getBinding();
        if (type.isAssignableFrom(Polygon.class) || type.isAssignableFrom(MultiPolygon.class)) {
            return new Style[]{ShapefileLoader.createPolygonStyle()};
        }
        if (type.isAssignableFrom(LineString.class) || type.isAssignableFrom(MultiLineString.class)) {
            return new Style[]{ShapefileLoader.createLineStyle()};
        }
        return new Style[]{ShapefileLoader.createPointStyle()};
    }

    private static Style createPointStyle() {
        PointSymbolizer symbolizer = styleFactory.createPointSymbolizer();
        symbolizer.getGraphic().setSize((Expression)filterFactory.literal(1));
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private static Style createLineStyle() {
        LineSymbolizer symbolizer = styleFactory.createLineSymbolizer();
        SLD.setLineColour((LineSymbolizer)symbolizer, (Color)Color.BLUE);
        symbolizer.getStroke().setWidth((Expression)filterFactory.literal(1));
        symbolizer.getStroke().setColor((Expression)filterFactory.literal((Object)Color.BLUE));
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private static Style createPolygonStyle() {
        PolygonSymbolizer symbolizer = styleFactory.createPolygonSymbolizer();
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)"#FFAA00"), (Expression)filterFactory.literal(0.5));
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLACK), (Expression)filterFactory.literal(1));
        symbolizer.setFill((Fill)fill);
        symbolizer.setStroke((org.opengis.style.Stroke)stroke);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }
}

