/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.image;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerTypeRegistry;
import java.awt.geom.AffineTransform;
import java.io.File;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.image.ImageFileAssistantPage1;
import org.esa.snap.rcp.layermanager.layersrc.image.ImageFileLayerType;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSource;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.esa.snap.ui.product.ProductSceneView;

public class ImageFileLayerSource
implements LayerSource {
    static final String PROPERTY_NAME_IMAGE_FILE_PATH = "imageFilePath";
    static final String PROPERTY_NAME_WORLD_FILE_PATH = "worldFilePath";
    static final String PROPERTY_NAME_WORLD_TRANSFORM = "worldTransform";

    public boolean isApplicable(LayerSourcePageContext pageContext) {
        return true;
    }

    public boolean hasFirstPage() {
        return true;
    }

    public AbstractLayerSourceAssistantPage getFirstPage(LayerSourcePageContext pageContext) {
        return new ImageFileAssistantPage1();
    }

    public boolean canFinish(LayerSourcePageContext pageContext) {
        return false;
    }

    public boolean performFinish(LayerSourcePageContext pageContext) {
        return false;
    }

    public void cancel(LayerSourcePageContext pageContext) {
        pageContext.setPropertyValue(PROPERTY_NAME_IMAGE_FILE_PATH, null);
    }

    static boolean insertImageLayer(LayerSourcePageContext pageContext) {
        AffineTransform transform = (AffineTransform)pageContext.getPropertyValue(PROPERTY_NAME_WORLD_TRANSFORM);
        String imageFilePath = (String)pageContext.getPropertyValue(PROPERTY_NAME_IMAGE_FILE_PATH);
        try {
            ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
            ImageFileLayerType type = (ImageFileLayerType)LayerTypeRegistry.getLayerType(ImageFileLayerType.class);
            PropertySet configuration = type.createLayerConfig((LayerContext)sceneView);
            configuration.setValue("filePath", (Object)new File(imageFilePath));
            configuration.setValue(PROPERTY_NAME_WORLD_TRANSFORM, (Object)transform);
            Layer layer = type.createLayer((LayerContext)sceneView, configuration);
            layer.setName(FileUtils.getFileNameFromPath((String)imageFilePath));
            Layer rootLayer = sceneView.getRootLayer();
            rootLayer.getChildren().add(sceneView.getFirstImageLayerIndex(), layer);
            return true;
        }
        catch (Exception e) {
            pageContext.showErrorDialog(e.getMessage());
            return false;
        }
    }
}

