/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.editors;

import com.bc.ceres.swing.TableLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.FeatureLayer;
import org.esa.snap.ui.layer.AbstractLayerEditor;

public class FeatureLayerEditor
extends AbstractLayerEditor {
    private JSlider polyFillTransparency;
    private JSlider polyStrokeTransparency;
    private JSlider textTransparency;

    protected FeatureLayer getCurrentLayer() {
        return (FeatureLayer)super.getCurrentLayer();
    }

    public JComponent createControl() {
        Hashtable<Integer, JLabel> sliderLabelTable = new Hashtable<Integer, JLabel>();
        sliderLabelTable.put(0, this.createSliderLabel("0%"));
        sliderLabelTable.put(127, this.createSliderLabel("50%"));
        sliderLabelTable.put(255, this.createSliderLabel("100%"));
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setColumnWeightX(0, Double.valueOf(0.4));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.6));
        tableLayout.setRowWeightY(3, Double.valueOf(1.0));
        tableLayout.setTablePadding(4, 4);
        JPanel control = new JPanel((LayoutManager)tableLayout);
        JLabel fillLabel = new JLabel("Fill transparency:");
        control.add(fillLabel);
        this.polyFillTransparency = new JSlider(0, 255, 255);
        this.polyFillTransparency.setToolTipText("Set the opacity of fillings");
        this.polyFillTransparency.setLabelTable(sliderLabelTable);
        this.polyFillTransparency.setPaintLabels(true);
        this.polyFillTransparency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FeatureLayerEditor.this.getCurrentLayer().setPolyFillOpacity(1.0 - (double)FeatureLayerEditor.this.polyFillTransparency.getValue() / 255.0);
            }
        });
        control.add(this.polyFillTransparency);
        JLabel lineLabel = new JLabel("Line transparency:");
        control.add(lineLabel);
        this.polyStrokeTransparency = new JSlider(0, 255, 255);
        this.polyStrokeTransparency.setToolTipText("Set the transparency of lines");
        this.polyStrokeTransparency.setLabelTable(sliderLabelTable);
        this.polyStrokeTransparency.setPaintLabels(true);
        this.polyStrokeTransparency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FeatureLayerEditor.this.getCurrentLayer().setPolyStrokeOpacity(1.0 - (double)FeatureLayerEditor.this.polyStrokeTransparency.getValue() / 255.0);
            }
        });
        control.add(this.polyStrokeTransparency);
        JLabel labelLabel = new JLabel("Label transparency:");
        control.add(labelLabel);
        this.textTransparency = new JSlider(0, 255, 255);
        this.textTransparency.setToolTipText("Set the transparency of labels");
        this.textTransparency.setLabelTable(sliderLabelTable);
        this.textTransparency.setPaintLabels(true);
        this.textTransparency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FeatureLayerEditor.this.getCurrentLayer().setTextOpacity(1.0 - (double)FeatureLayerEditor.this.textTransparency.getValue() / 255.0);
            }
        });
        control.add(this.textTransparency);
        control.add(new JPanel());
        return control;
    }

    private JLabel createSliderLabel(String text) {
        JLabel label = new JLabel(text);
        Font oldFont = label.getFont();
        Font newFont = oldFont.deriveFont(oldFont.getSize2D() * 0.85f);
        label.setFont(newFont);
        return label;
    }

    public void handleLayerContentChanged() {
        this.polyFillTransparency.setValue((int)Math.round((1.0 - this.getCurrentLayer().getPolyFillOpacity()) * 255.0));
        this.polyStrokeTransparency.setValue((int)Math.round((1.0 - this.getCurrentLayer().getPolyStrokeOpacity()) * 255.0));
        this.textTransparency.setValue((int)Math.round((1.0 - this.getCurrentLayer().getTextOpacity()) * 255.0));
    }
}

