/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter.model;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.rcp.imgfilter.model.Filter;

public class FilterSet
implements Filter.Listener {
    String name;
    boolean editable;
    ArrayList<Filter> filters;
    transient List<Listener> listeners;

    public FilterSet() {
        this("", true);
    }

    public FilterSet(String name, boolean editable) {
        this.name = name;
        this.editable = editable;
        this.filters = new ArrayList();
        this.listeners = new ArrayList<Listener>();
    }

    public String getName() {
        return this.name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public Filter getFilter(int index) {
        return this.filters.get(index);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean containsFilter(Filter filter) {
        return this.filters.contains(filter);
    }

    public int getFilterIndex(Filter filter) {
        return this.filters.indexOf(filter);
    }

    public void addFilter(String tag, Filter ... filters) {
        for (Filter filter : filters) {
            filter.getTags().add(tag);
            this.addFilter(filter);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        filter.addListener(this);
        this.fireFilterAdded(filter);
    }

    public void removeFilter(Filter filter) {
        if (this.filters.remove(filter)) {
            filter.removeListener(this);
            this.fireFilterModelRemoved(filter);
        }
    }

    public static XStream createXStream() {
        XStream xStream = Filter.createXStream();
        xStream.alias("filterSet", FilterSet.class);
        return xStream;
    }

    private Object readResolve() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter filter : this.filters) {
            filter.removeListener(this);
            filter.addListener(this);
        }
        return this;
    }

    @Override
    public void filterChanged(Filter filter, String propertyName) {
        this.fireFilterChanged(filter, propertyName);
    }

    void fireFilterChanged(Filter filter, String propertyName) {
        for (Listener listener : this.listeners) {
            listener.filterChanged(this, filter, propertyName);
        }
    }

    void fireFilterAdded(Filter filter) {
        for (Listener listener : this.listeners) {
            listener.filterAdded(this, filter);
        }
    }

    void fireFilterModelRemoved(Filter filter) {
        for (Listener listener : this.listeners) {
            listener.filterRemoved(this, filter);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static interface Listener {
        public void filterAdded(FilterSet var1, Filter var2);

        public void filterRemoved(FilterSet var1, Filter var2);

        public void filterChanged(FilterSet var1, Filter var2, String var3);
    }
}

