/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberPlainDocument
extends PlainDocument {
    private final int minimumNumber;
    private final int maximumNumber;

    public NumberPlainDocument(int minimumNumber, int maximumNumber) {
        this.minimumNumber = minimumNumber;
        this.maximumNumber = maximumNumber;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int number;
        int startIndex;
        StringBuilder text = new StringBuilder();
        text.append(this.getText(0, offs));
        text.append(str);
        text.append(this.getText(offs, this.getLength() - offs));
        for (int i = startIndex = text.charAt(0) == '-' ? 1 : 0; i < text.length(); ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return;
        }
        boolean canConvert = true;
        if (text.charAt(0) == '-' && text.length() == 1) {
            canConvert = false;
        }
        if (canConvert && ((number = Integer.parseInt(text.toString())) < this.minimumNumber || number > this.maximumNumber)) {
            return;
        }
        super.insertString(offs, str, a);
    }
}

