/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.color.ColorComboBox;
import org.esa.snap.ui.color.ColorComboBoxAdapter;

class MoreOptionsForm {
    static final String NO_DATA_COLOR_PROPERTY = "noDataColor";
    static final String HISTOGRAM_MATCHING_PROPERTY = "histogramMatching";
    private JPanel contentPanel;
    private GridBagConstraints constraints;
    private BindingContext bindingContext;
    private ColorManipulationChildForm childForm;
    private boolean hasHistogramMatching;
    private List<Row> contentRows;

    MoreOptionsForm(ColorManipulationChildForm childForm, boolean hasHistogramMatching) {
        this.childForm = childForm;
        PropertyContainer propertyContainer = new PropertyContainer();
        propertyContainer.addProperty(Property.create((String)NO_DATA_COLOR_PROPERTY, (Object)ImageInfo.NO_COLOR));
        this.hasHistogramMatching = hasHistogramMatching;
        if (this.hasHistogramMatching) {
            propertyContainer.addProperty(Property.create((String)HISTOGRAM_MATCHING_PROPERTY, (Object)ImageInfo.HistogramMatching.None));
            propertyContainer.getDescriptor(HISTOGRAM_MATCHING_PROPERTY).setNotNull(true);
            propertyContainer.getDescriptor(HISTOGRAM_MATCHING_PROPERTY).setValueSet(new ValueSet((Object[])new ImageInfo.HistogramMatching[]{ImageInfo.HistogramMatching.None, ImageInfo.HistogramMatching.Equalize, ImageInfo.HistogramMatching.Normalize}));
        }
        this.contentPanel = new JPanel(new GridBagLayout());
        this.contentRows = new ArrayList<Row>();
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.anchor = 18;
        this.constraints.weightx = 0.5;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(1, 0, 1, 0);
        this.bindingContext = new BindingContext((PropertySet)propertyContainer);
        JLabel noDataColorLabel = new JLabel("No-data colour: ");
        ColorComboBox noDataColorComboBox = new ColorComboBox();
        Binding noDataColorBinding = this.bindingContext.bind(NO_DATA_COLOR_PROPERTY, (ComponentAdapter)new ColorComboBoxAdapter(noDataColorComboBox));
        noDataColorBinding.addComponent((JComponent)noDataColorLabel);
        this.addRow(noDataColorLabel, (JComponent)noDataColorComboBox);
        if (this.hasHistogramMatching) {
            JLabel histogramMatchingLabel = new JLabel("Histogram matching: ");
            JComboBox histogramMatchingBox = new JComboBox();
            Binding histogramMatchingBinding = this.bindingContext.bind(HISTOGRAM_MATCHING_PROPERTY, histogramMatchingBox);
            histogramMatchingBinding.addComponent((JComponent)histogramMatchingLabel);
            this.addRow(histogramMatchingLabel, histogramMatchingBox);
        }
        this.bindingContext.addPropertyChangeListener(evt -> {
            ImageInfo.HistogramMatching matching = this.getHistogramMatching();
            if (matching != null && matching != ImageInfo.HistogramMatching.None) {
                String message = "<html>Histogram matching will be applied to the currently displayed image.<br/>Sample values of the colour palette will not longer translate into<br/>their associated colours.</html>";
                Dialogs.showInformation("Histogram Matching", "<html>Histogram matching will be applied to the currently displayed image.<br/>Sample values of the colour palette will not longer translate into<br/>their associated colours.</html>", "warningHistogramMatching");
            }
            this.updateModel();
        });
    }

    private ImageInfo getImageInfo() {
        return this.getParentForm().getFormModel().getModifiedImageInfo();
    }

    public ColorManipulationForm getParentForm() {
        return this.childForm.getParentForm();
    }

    public ColorManipulationChildForm getChildForm() {
        return this.childForm;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void insertRow(int index, JLabel label, JComponent editor) {
        if (this.contentRows != null) {
            this.contentRows.add(index, new Row(label, editor));
        } else {
            this.addRowImpl(label, editor);
        }
    }

    public void addRow(JLabel label, JComponent editor) {
        if (this.contentRows != null) {
            this.contentRows.add(new Row(label, editor));
        } else {
            this.addRowImpl(label, editor);
        }
    }

    public void addRow(JComponent editor) {
        if (this.contentRows != null) {
            this.contentRows.add(new Row(null, editor));
        } else {
            this.addRowImpl(null, editor);
        }
    }

    private void addRowImpl(JComponent label, JComponent editor) {
        ++this.constraints.gridy;
        this.constraints.gridx = 0;
        if (label == null) {
            this.constraints.gridwidth = 2;
            this.contentPanel.add((Component)editor, this.constraints);
        } else {
            this.constraints.gridwidth = 1;
            this.contentPanel.add((Component)label, this.constraints);
            this.constraints.gridx = 1;
            this.contentPanel.add((Component)editor, this.constraints);
        }
    }

    public void updateForm() {
        this.setNoDataColor(this.getImageInfo().getNoDataColor());
        if (this.hasHistogramMatching) {
            this.setHistogramMatching(this.getImageInfo().getHistogramMatching());
        }
        this.getParentForm().getFormModel().updateMoreOptionsFromImageInfo(this);
    }

    public void updateModel() {
        this.getImageInfo().setNoDataColor(this.getNoDataColor());
        if (this.hasHistogramMatching) {
            this.getImageInfo().setHistogramMatching(this.getHistogramMatching());
        }
        this.getParentForm().getFormModel().updateImageInfoFromMoreOptions(this);
        this.getParentForm().applyChanges();
    }

    public JPanel getContentPanel() {
        if (this.contentRows != null) {
            Row[] rows;
            for (Row row : rows = this.contentRows.toArray(new Row[this.contentRows.size()])) {
                this.addRowImpl(row.label, row.editor);
            }
            this.contentRows.clear();
            this.contentRows = null;
        }
        return this.contentPanel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.bindingContext.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        this.bindingContext.addPropertyChangeListener(propertyName, propertyChangeListener);
    }

    private Color getNoDataColor() {
        return (Color)this.getBindingContext().getBinding(NO_DATA_COLOR_PROPERTY).getPropertyValue();
    }

    private void setNoDataColor(Color color) {
        this.getBindingContext().getBinding(NO_DATA_COLOR_PROPERTY).setPropertyValue((Object)color);
    }

    private ImageInfo.HistogramMatching getHistogramMatching() {
        Binding binding = this.getBindingContext().getBinding(HISTOGRAM_MATCHING_PROPERTY);
        return binding != null ? (ImageInfo.HistogramMatching)binding.getPropertyValue() : null;
    }

    private void setHistogramMatching(ImageInfo.HistogramMatching histogramMatching) {
        Binding binding = this.getBindingContext().getBinding(HISTOGRAM_MATCHING_PROPERTY);
        if (binding != null) {
            binding.setPropertyValue((Object)histogramMatching);
        }
    }

    private static class Row {
        final JComponent label;
        final JComponent editor;

        private Row(JComponent label, JComponent editor) {
            this.label = label;
            this.editor = editor;
        }
    }
}

