/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.RasterDataNode;

public class BrightnessContrastData {
    private final Map<RasterDataNode, ImageInfo> initialImageInfoMap = new HashMap<RasterDataNode, ImageInfo>();
    private ImageInfo initialImageInfo;
    private int brightnessSliderValue;
    private int contrastSliderValue;
    private int saturationSliderValue;

    public BrightnessContrastData(ImageInfo initialImageInfo) {
        this.initialImageInfo = initialImageInfo;
        this.brightnessSliderValue = 0;
        this.contrastSliderValue = 0;
        this.saturationSliderValue = 0;
    }

    public void putImageInfo(RasterDataNode rasterDataNode, ImageInfo imageInfo) {
        this.initialImageInfoMap.put(rasterDataNode, imageInfo);
    }

    public ImageInfo getInitialImageInfo(RasterDataNode rasterDataNode) {
        return this.initialImageInfoMap.get(rasterDataNode);
    }

    public ImageInfo getInitialImageInfo() {
        return this.initialImageInfo;
    }

    public int getBrightnessSliderValue() {
        return this.brightnessSliderValue;
    }

    public int getContrastSliderValue() {
        return this.contrastSliderValue;
    }

    public int getSaturationSliderValue() {
        return this.saturationSliderValue;
    }

    public void setInitialImageInfo(ImageInfo initialImageInfo) {
        this.initialImageInfo = initialImageInfo;
    }

    public void setSliderValues(int brightnessSliderValue, int contrastSliderValue, int saturationSliderValue) {
        this.brightnessSliderValue = brightnessSliderValue;
        this.contrastSliderValue = contrastSliderValue;
        this.saturationSliderValue = saturationSliderValue;
    }
}

