/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.esa.snap.core.datamodel.GeometryDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.PointDescriptor;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.ModalDialog;
import org.opengis.feature.simple.SimpleFeatureType;

class TypeDialog
extends ModalDialog {
    private InterpretationMethod interpretationMethod;
    private PlacemarkDescriptor placemarkDescriptor;

    TypeDialog(Window parent, SimpleFeatureType featureType) {
        super(parent, "Point Data Interpretation", 161, "interpretPointData");
        this.createUI(featureType);
    }

    private void createUI(SimpleFeatureType featureType) {
        this.getJDialog().setPreferredSize(new Dimension(400, 250));
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        panel.add(new JLabel("<html>" + SnapApp.getDefault().getAppContext().getApplicationName() + " can interpret the imported point data in various ways.<br>" + "Please select:<br><br></html>"));
        ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
        this.placemarkDescriptor = PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor(GeometryDescriptor.class);
        this.interpretationMethod = InterpretationMethod.LEAVE_UNCHANGED;
        buttons.add(this.createButton("<html>Leave imported data <b>unchanged</b></html>.", true, InterpretationMethod.LEAVE_UNCHANGED, this.placemarkDescriptor));
        buttons.add(this.createButton("<html>Interpret each point as vertex of a single <b>line or polygon</b><br>(This will remove all attributes from points)</html>", false, InterpretationMethod.CONVERT_TO_SHAPE, PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor(PointDescriptor.class)));
        TreeSet<PlacemarkDescriptor> placemarkDescriptors = new TreeSet<PlacemarkDescriptor>(new Comparator<PlacemarkDescriptor>(){

            @Override
            public int compare(PlacemarkDescriptor o1, PlacemarkDescriptor o2) {
                return o1.getRoleLabel().compareTo(o2.getRoleLabel());
            }
        });
        placemarkDescriptors.addAll(PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptors(featureType));
        placemarkDescriptors.remove(PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor(GeometryDescriptor.class));
        placemarkDescriptors.remove(PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor(PointDescriptor.class));
        for (PlacemarkDescriptor descriptor : placemarkDescriptors) {
            buttons.add(this.createButton("<html>Interpret each point as <b>" + descriptor.getRoleLabel() + "</br></html>", false, InterpretationMethod.APPLY_DESCRIPTOR, descriptor));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : buttons) {
            buttonGroup.add(abstractButton);
            panel.add(abstractButton);
        }
        this.setContent(panel);
    }

    private JRadioButton createButton(String text, boolean selected, final InterpretationMethod im, final PlacemarkDescriptor pd) {
        JRadioButton button = new JRadioButton(text, selected);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeDialog.this.interpretationMethod = im;
                TypeDialog.this.placemarkDescriptor = pd;
            }
        });
        return button;
    }

    public InterpretationMethod getInterpretationMethod() {
        return this.interpretationMethod;
    }

    public PlacemarkDescriptor getPlacemarkDescriptor() {
        return this.placemarkDescriptor;
    }

    protected void onOK() {
        super.onOK();
        this.getParent().setVisible(true);
    }

    protected void onCancel() {
        super.onCancel();
        this.getParent().setVisible(true);
    }

    protected void onHelp() {
        super.onHelp();
    }

    public static enum InterpretationMethod {
        LEAVE_UNCHANGED,
        CONVERT_TO_SHAPE,
        APPLY_DESCRIPTOR;

    }
}

