/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.tools;

import com.bc.ceres.core.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingWorker;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.tools.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class DetachPixelGeoCodingAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lookup;

    public DetachPixelGeoCodingAction() {
        this(Utilities.actionsGlobalContext());
    }

    public DetachPixelGeoCodingAction(Lookup lkp) {
        super(Bundle.CTL_DetachPixelGeoCodingActionText());
        this.lookup = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.putValue("ShortDescription", "Detach a pixel based geo-coding from the selected product");
        this.setEnableState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DetachPixelGeoCodingAction.detachPixelGeoCoding(((ProductNode)this.lookup.lookup(ProductNode.class)).getProduct());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DetachPixelGeoCodingAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    private static void detachPixelGeoCoding(final Product product) {
        SwingWorker<Throwable, Object> swingWorker = new SwingWorker<Throwable, Object>(){

            @Override
            protected Throwable doInBackground() throws Exception {
                try {
                    GeoCoding geoCoding = product.getSceneGeoCoding();
                    if (geoCoding instanceof BasicPixelGeoCoding) {
                        BasicPixelGeoCoding pixelGeoCoding = (BasicPixelGeoCoding)geoCoding;
                        GeoCoding delegate = pixelGeoCoding.getPixelPosEstimator();
                        product.setSceneGeoCoding(delegate);
                        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(product);
                        if (undoManager != null) {
                            undoManager.addEdit(new UndoableDetachGeoCoding<BasicPixelGeoCoding>(product, pixelGeoCoding));
                        }
                    }
                }
                catch (Throwable e) {
                    return e;
                }
                return null;
            }

            @Override
            public void done() {
                try {
                    Throwable value;
                    try {
                        value = (Throwable)this.get();
                    }
                    catch (Exception e) {
                        value = e;
                    }
                    String dialogTitle = Bundle.CTL_DetachPixelGeoCodingDialogTitle();
                    if (value != null) {
                        Dialogs.showError(dialogTitle, "An internal error occurred:\n" + value.getMessage());
                    } else {
                        Dialogs.showInformation(dialogTitle, "Pixel geo-coding has been detached.", null);
                    }
                }
                finally {
                    UIUtils.setRootFrameDefaultCursor((Component)SnapApp.getDefault().getMainFrame());
                }
            }
        };
        UIUtils.setRootFrameWaitCursor((Component)SnapApp.getDefault().getMainFrame());
        swingWorker.execute();
    }

    private void setEnableState() {
        Product product;
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null && (product = productNode.getProduct()) != null) {
            state = product.getSceneGeoCoding() instanceof BasicPixelGeoCoding;
        }
        this.setEnabled(state);
    }

    private static class UndoableDetachGeoCoding<T extends BasicPixelGeoCoding>
    extends AbstractUndoableEdit {
        private Product product;
        private T pixelGeoCoding;

        public UndoableDetachGeoCoding(Product product, T pixelGeoCoding) {
            Assert.notNull((Object)product, (String)"product");
            Assert.notNull(pixelGeoCoding, (String)"pixelGeoCoding");
            this.product = product;
            this.pixelGeoCoding = pixelGeoCoding;
        }

        @Override
        public String getPresentationName() {
            return Bundle.CTL_DetachPixelGeoCodingDialogTitle();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.product.setSceneGeoCoding(this.pixelGeoCoding);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.product.getSceneGeoCoding() == this.pixelGeoCoding) {
                this.product.setSceneGeoCoding(this.pixelGeoCoding.getPixelPosEstimator());
            }
        }

        @Override
        public void die() {
            this.pixelGeoCoding = null;
            this.product = null;
        }
    }
}

