/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.layer.overlay;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.support.LayerUtils;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.layer.WorldMapLayerType;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.layer.overlay.AbstractOverlayAction;
import org.esa.snap.rcp.actions.layer.overlay.Bundle;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.openide.util.ImageUtilities;

public final class OverlayWorldMapLayerAction
extends AbstractOverlayAction {
    private static final String WORLDMAP_TYPE_PROPERTY_NAME = "worldmap.type";
    private static final String DEFAULT_LAYER_TYPE = "BlueMarbleLayerType";

    @Override
    protected void initActionProperties() {
        this.putValue("Name", Bundle.CTL_OverlayWorldMapLayerActionName());
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/WorldMapOverlay.png", (boolean)false));
        this.putValue("SwingLargeIconKey", ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/WorldMapOverlay24.png", (boolean)false));
        this.putValue("ShortDescription", Bundle.CTL_OverlayWorldMapLayerActionToolTip());
    }

    @Override
    protected boolean getActionSelectionState(ProductSceneView view) {
        Layer worldMapLayer = this.findWorldMapLayer(view);
        return worldMapLayer != null && worldMapLayer.isVisible();
    }

    @Override
    protected boolean getActionEnabledState(ProductSceneView view) {
        RasterDataNode raster = view.getRaster();
        return this.isGeographicLatLon(raster.getGeoCoding());
    }

    @Override
    protected void setOverlayEnableState(ProductSceneView view) {
        if (view != null) {
            Layer rootLayer = view.getRootLayer();
            Layer worldMapLayer = this.findWorldMapLayer(view);
            if (this.isSelected()) {
                if (worldMapLayer == null) {
                    worldMapLayer = this.createWorldMapLayer();
                    rootLayer.getChildren().add(worldMapLayer);
                }
                worldMapLayer.setVisible(true);
            } else {
                worldMapLayer.getParent().getChildren().remove(worldMapLayer);
            }
        }
    }

    private Layer createWorldMapLayer() {
        LayerType layerType = this.getWorldMapLayerType();
        PropertySet template = layerType.createLayerConfig(null);
        return layerType.createLayer(null, template);
    }

    private LayerType getWorldMapLayerType() {
        SnapApp visatApp = SnapApp.getDefault();
        String layerTypeClassName = visatApp.getPreferences().get(WORLDMAP_TYPE_PROPERTY_NAME, DEFAULT_LAYER_TYPE);
        return LayerTypeRegistry.getLayerType((String)layerTypeClassName);
    }

    private Layer findWorldMapLayer(ProductSceneView view) {
        return LayerUtils.getChildLayer((Layer)view.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, layer -> layer.getLayerType() instanceof WorldMapLayerType);
    }

    private boolean isGeographicLatLon(GeoCoding geoCoding) {
        if (geoCoding instanceof MapGeoCoding) {
            MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
            MapTransformDescriptor transformDescriptor = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform().getDescriptor();
            String typeID = transformDescriptor.getTypeID();
            if (typeID.equals("Identity")) {
                return true;
            }
        } else if (geoCoding instanceof CrsGeoCoding) {
            return CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
        }
        return false;
    }
}

