/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.CloseProductAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class CloseOtherProductsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;
    private Product[] products;
    private static Collection selectedProductList;

    public CloseOtherProductsAction() {
        this(Utilities.actionsGlobalContext());
    }

    public CloseOtherProductsAction(Lookup lkp) {
        super(Bundle.CTL_CloseAllOthersActionName());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        productManager.addListener((ProductManager.Listener)new CloseOtherProductListener());
        this.setEnableState();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CloseOtherProductsAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
        Lookup.Result result = (Lookup.Result)ev.getSource();
        selectedProductList = result.allInstances();
    }

    private void setEnableState() {
        this.products = SnapApp.getDefault().getProductManager().getProducts();
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        this.setEnabled(productNode != null && this.products.length > 1);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        this.products = SnapApp.getDefault().getProductManager().getProducts();
        List selectedProduct = selectedProductList.stream().collect(Collectors.toList());
        HashSet<Product> productsToClose = new HashSet<Product>();
        for (Product product : this.products) {
            if (selectedProduct.contains(product)) continue;
            productsToClose.add(product);
        }
        CloseProductAction.closeProducts(productsToClose);
        this.setEnableState();
    }

    private class CloseOtherProductListener
    implements ProductManager.Listener {
        private CloseOtherProductListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            CloseOtherProductsAction.this.setEnableState();
        }
    }
}

