/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.BrowserUtils;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;

public class SnapAboutBox
extends JPanel {
    private static final String releaseNotesHTTP = "https://github.com/senbox-org/snap-desktop/blob/master/ReleaseNotes.md";
    private JLabel versionText;

    public SnapAboutBox() {
        super(new BorderLayout(4, 4));
        ModuleInfo desktopModuleInfo = Modules.getDefault().ownerOf(SnapAboutBox.class);
        ModuleInfo engineModuleInfo = Modules.getDefault().ownerOf(Product.class);
        ImageIcon image = new ImageIcon(SnapAboutBox.class.getResource("SNAP_Banner.png"));
        JLabel banner = new JLabel(image);
        this.versionText = new JLabel("<html><b>SNAP " + SystemUtils.getReleaseVersion() + "</b>");
        JLabel infoText = new JLabel("<html>This program is free software: you can redistribute it and/or modify it<br>under the terms of the <b>GNU General Public License</b> as published by<br>the Free Software Foundation, either version 3 of the License, or<br>(at your option) any later version.<br><br><b>SNAP Desktop implementation version: </b>" + desktopModuleInfo.getImplementationVersion() + "<br>" + "<b>SNAP Engine implementation version: </b>" + engineModuleInfo.getImplementationVersion() + "<br>" + "<b>JRE: </b>" + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + "<br>" + "<b>JVM: </b>" + System.getProperty("java.vm.name") + " by " + System.getProperty("java.vendor") + "<br>" + "<b>Memory: </b>" + Math.round((double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0) + " MiB<br>");
        Font font = this.versionText.getFont();
        if (font != null) {
            infoText.setFont(font.deriveFont((float)font.getSize() * 0.9f));
        }
        JPanel innerPanel = new JPanel(new BorderLayout(4, 4));
        innerPanel.add((Component)this.createVersionPanel(), "North");
        innerPanel.add((Component)infoText, "South");
        this.add((Component)banner, "West");
        this.add((Component)innerPanel, "Center");
    }

    private JPanel createVersionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.versionText);
        URI releaseNotesURI = this.getReleaseNotesURI();
        if (releaseNotesURI != null) {
            JLabel releaseNoteLabel = new JLabel("<html><a href=\"" + releaseNotesURI.toString() + "\">Release Notes</a>");
            releaseNoteLabel.setCursor(new Cursor(12));
            releaseNoteLabel.addMouseListener(new BrowserUtils.URLClickAdaptor(releaseNotesHTTP));
            panel.add(releaseNoteLabel);
        }
        return panel;
    }

    private URI getReleaseNotesURI() {
        try {
            return new URI(releaseNotesHTTP);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

