/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.dataio.dimap.DimapProductReader;
import org.esa.snap.core.dataio.dimap.EnviHeader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.FileUtils;

public class EnviProductWriter
extends AbstractProductWriter {
    protected File _outputDir;
    protected File _outputFile;
    private Map _bandOutputStreams;
    private boolean _incremental = true;

    public EnviProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    protected void writeProductNodesImpl() throws IOException {
        Object output = this.getOutput();
        File outputFile = null;
        if (output instanceof String) {
            outputFile = new File((String)output);
        } else if (output instanceof File) {
            outputFile = (File)output;
        }
        Debug.assertNotNull(outputFile);
        this.initDirs(outputFile);
        this.ensureNamingConvention();
        this.getSourceProduct().setProductWriter((ProductWriter)this);
        this.getSourceProduct().setFileLocation(this._outputDir);
        this.deleteRemovedNodes();
    }

    protected void initDirs(File outputFile) {
        String name = FileUtils.getFilenameWithoutExtension((File)outputFile);
        this._outputDir = outputFile.getParentFile();
        if (this._outputDir == null) {
            this._outputDir = new File(".");
        }
        this._outputDir = new File(this._outputDir, name);
        this._outputDir.mkdirs();
        this._outputFile = new File(this._outputDir, outputFile.getName());
    }

    protected void ensureNamingConvention() {
        if (this._outputFile != null) {
            this.getSourceProduct().setName(FileUtils.getFilenameWithoutExtension((File)this._outputFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull((String)"sourceBand", (Object)sourceBand);
        Guardian.assertNotNull((String)"sourceBuffer", (Object)sourceBuffer);
        EnviProductWriter.checkBufferSize(sourceWidth, sourceHeight, sourceBuffer);
        int sourceBandWidth = sourceBand.getRasterWidth();
        int sourceBandHeight = sourceBand.getRasterHeight();
        EnviProductWriter.checkSourceRegionInsideBandRegion(sourceWidth, sourceBandWidth, sourceHeight, sourceBandHeight, sourceOffsetX, sourceOffsetY);
        ImageOutputStream outputStream = this.getOrCreateImageOutputStream(sourceBand);
        long outputPos = (long)sourceOffsetY * (long)sourceBandWidth + (long)sourceOffsetX;
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", 1);
        try {
            long max = sourceHeight * sourceWidth;
            int sourcePos = 0;
            while ((long)sourcePos < max) {
                sourceBuffer.writeTo(sourcePos, sourceWidth, outputStream, outputPos);
                outputPos += (long)sourceBandWidth;
                sourcePos += sourceWidth;
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    public void deleteOutput() throws IOException {
        this.flush();
        this.close();
        if (this._outputFile != null && this._outputFile.exists() && this._outputFile.isFile()) {
            this._outputFile.delete();
        }
    }

    private static void checkSourceRegionInsideBandRegion(int sourceWidth, int sourceBandWidth, int sourceHeight, int sourceBandHeight, int sourceOffsetX, int sourceOffsetY) {
        Guardian.assertWithinRange((String)"sourceWidth", (long)sourceWidth, (long)1L, (long)sourceBandWidth);
        Guardian.assertWithinRange((String)"sourceHeight", (long)sourceHeight, (long)1L, (long)sourceBandHeight);
        Guardian.assertWithinRange((String)"sourceOffsetX", (long)sourceOffsetX, (long)0L, (long)(sourceBandWidth - sourceWidth));
        Guardian.assertWithinRange((String)"sourceOffsetY", (long)sourceOffsetY, (long)0L, (long)(sourceBandHeight - sourceHeight));
    }

    private static void checkBufferSize(int sourceWidth, int sourceHeight, ProductData sourceBuffer) {
        long expectedBufferSize = (long)sourceWidth * (long)sourceHeight;
        long actualBufferSize = sourceBuffer.getNumElems();
        Guardian.assertEquals((String)"sourceWidth * sourceHeight", (long)actualBufferSize, (long)expectedBufferSize);
    }

    public void flush() throws IOException {
        if (this._bandOutputStreams == null) {
            return;
        }
        for (Object o : this._bandOutputStreams.values()) {
            ((ImageOutputStream)o).flush();
        }
    }

    public void close() throws IOException {
        if (this._bandOutputStreams == null) {
            return;
        }
        for (Object o : this._bandOutputStreams.values()) {
            ((ImageOutputStream)o).close();
        }
        this._bandOutputStreams.clear();
        this._bandOutputStreams = null;
    }

    private ImageOutputStream getOrCreateImageOutputStream(Band band) throws IOException {
        ImageOutputStream outputStream = this.getImageOutputStream(band);
        if (outputStream == null) {
            outputStream = this.createImageOutputStream(band);
            if (this._bandOutputStreams == null) {
                this._bandOutputStreams = new HashMap();
            }
            this._bandOutputStreams.put(band, outputStream);
        }
        return outputStream;
    }

    private ImageOutputStream getImageOutputStream(Band band) {
        if (this._bandOutputStreams != null) {
            return (ImageOutputStream)this._bandOutputStreams.get(band);
        }
        return null;
    }

    protected File getValidImageFile(Band band) throws IOException {
        this.writeEnviHeader(band);
        File file = this.getImageFile(band);
        if (file.exists()) {
            if (file.length() != EnviProductWriter.getImageFileSize((RasterDataNode)band)) {
                EnviProductWriter.createPhysicalImageFile(band, file);
            }
        } else {
            EnviProductWriter.createPhysicalImageFile(band, file);
        }
        return file;
    }

    private static void createPhysicalImageFile(Band band, File file) throws IOException {
        EnviProductWriter.createPhysicalFile(file, EnviProductWriter.getImageFileSize((RasterDataNode)band));
    }

    protected void writeEnviHeader(Band band) throws IOException {
        EnviHeader.createPhysicalFile((File)this.getEnviHeaderFile(band), (RasterDataNode)band, (int)band.getRasterWidth(), (int)band.getRasterHeight());
    }

    protected ImageOutputStream createImageOutputStream(Band band) throws IOException {
        return new FileImageOutputStream(this.getValidImageFile(band));
    }

    private static long getImageFileSize(RasterDataNode band) {
        return (long)ProductData.getElemSize((int)band.getDataType()) * (long)band.getRasterWidth() * (long)band.getRasterHeight();
    }

    protected File getEnviHeaderFile(Band band) {
        return new File(this._outputDir, this.createEnviHeaderFilename(band));
    }

    protected String createEnviHeaderFilename(Band band) {
        return band.getName() + ".hdr";
    }

    private File getImageFile(Band band) {
        return new File(this._outputDir, this.createImageFilename(band));
    }

    protected String createImageFilename(Band band) {
        return band.getName() + ".img";
    }

    private static void createPhysicalFile(File file, long fileSize) throws IOException {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.setLength(fileSize);
        randomAccessFile.close();
    }

    public boolean shouldWrite(ProductNode node) {
        if (node instanceof VirtualBand) {
            return false;
        }
        if (node instanceof FilterBand) {
            return false;
        }
        if (node.isModified()) {
            return true;
        }
        if (!this.isIncrementalMode()) {
            return true;
        }
        if (!(node instanceof Band)) {
            return true;
        }
        File imageFile = this.getImageFile((Band)node);
        return imageFile == null || !imageFile.exists();
    }

    public void setIncrementalMode(boolean enabled) {
        this._incremental = enabled;
    }

    public boolean isIncrementalMode() {
        return this._incremental;
    }

    private void deleteRemovedNodes() throws IOException {
        ProductNode[] removedNodes;
        Product product = this.getSourceProduct();
        ProductReader productReader = product.getProductReader();
        if (productReader instanceof DimapProductReader && (removedNodes = product.getRemovedChildNodes()).length > 0) {
            productReader.close();
            for (ProductNode removedNode : removedNodes) {
                removedNode.removeFromFile((ProductWriter)this);
            }
        }
    }

    public void removeBand(Band band) {
        if (band != null) {
            String headerFilename = this.createEnviHeaderFilename(band);
            String imageFilename = this.createImageFilename(band);
            File[] files = null;
            if (this._outputDir != null && this._outputDir.exists()) {
                files = this._outputDir.listFiles();
            }
            if (files == null) {
                return;
            }
            for (File file : files) {
                String name = file.getName();
                if (!file.isFile() || !name.equals(headerFilename) && !name.equals(imageFilename)) continue;
                file.delete();
            }
        }
    }

    protected File getOutputDir() {
        return this._outputDir;
    }
}

