/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class AddElevationOpUI
extends BaseOperatorUI {
    private final JComboBox<String> demName = new JComboBox<String>(DEMFactory.getDEMNameList());
    private final JComboBox demResamplingMethod = new JComboBox<String>(DEMFactory.getDEMResamplingMethods());
    private final JTextField externalDEMFile = new JTextField("");
    private final JTextField externalDEMNoDataValue = new JTextField("");
    private final JButton externalDEMBrowseButton = new JButton("...");
    private final JLabel externalDEMFileLabel = new JLabel("External DEM:");
    private final JLabel externalDEMNoDataValueLabel = new JLabel("DEM No Data Value:");
    private Double extNoDataValue = 0.0;
    private final DialogUtils.TextAreaKeyListener textAreaKeyListener = new DialogUtils.TextAreaKeyListener();
    private static final String externalDEMStr = "External DEM";
    private final JTextField elevationBandName = new JTextField("");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.demName.addItem(externalDEMStr);
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.demName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (((String)AddElevationOpUI.this.demName.getSelectedItem()).startsWith(AddElevationOpUI.externalDEMStr)) {
                    AddElevationOpUI.this.enableExternalDEM(true);
                } else {
                    AddElevationOpUI.this.externalDEMFile.setText("");
                    AddElevationOpUI.this.enableExternalDEM(false);
                }
            }
        });
        this.externalDEMFile.setColumns(30);
        this.enableExternalDEM(((String)this.demName.getSelectedItem()).startsWith(externalDEMStr));
        this.externalDEMBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External DEM File", (boolean)false, null, (String)"snap.externalDEMDir");
                AddElevationOpUI.this.externalDEMFile.setText(file.getAbsolutePath());
                AddElevationOpUI.this.extNoDataValue = OperatorUIUtils.getNoDataValue((File)file);
                AddElevationOpUI.this.externalDEMNoDataValue.setText(String.valueOf(AddElevationOpUI.this.extNoDataValue));
            }
        });
        this.externalDEMNoDataValue.addKeyListener((KeyListener)this.textAreaKeyListener);
        return new JScrollPane(panel);
    }

    public void initParameters() {
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            ElevationModelDescriptor descriptor = ElevationModelRegistry.getInstance().getDescriptor(demNameParam);
            if (descriptor != null) {
                this.demName.setSelectedItem(DEMFactory.getDEMDisplayName((ElevationModelDescriptor)descriptor));
            } else {
                this.demName.setSelectedItem(demNameParam);
            }
        }
        this.demResamplingMethod.setSelectedItem(this.paramMap.get("demResamplingMethod"));
        File extFile = (File)this.paramMap.get("externalDEMFile");
        if (extFile != null) {
            this.externalDEMFile.setText(extFile.getAbsolutePath());
            this.extNoDataValue = (Double)this.paramMap.get("externalDEMNoDataValue");
            if (this.extNoDataValue != null && !this.textAreaKeyListener.isChangedByUser()) {
                this.externalDEMNoDataValue.setText(String.valueOf(this.extNoDataValue));
            }
        }
        this.elevationBandName.setText(String.valueOf(this.paramMap.get("elevationBandName")));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("demName", DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem())));
        this.paramMap.put("demResamplingMethod", this.demResamplingMethod.getSelectedItem());
        String extFileStr = this.externalDEMFile.getText();
        if (!extFileStr.isEmpty()) {
            this.paramMap.put("externalDEMFile", new File(extFileStr));
            this.paramMap.put("externalDEMNoDataValue", Double.parseDouble(this.externalDEMNoDataValue.getText()));
        }
        this.paramMap.put("elevationBandName", this.elevationBandName.getText());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMFileLabel, (JComponent)this.externalDEMFile);
        gbc.gridx = 2;
        contentPane.add((Component)this.externalDEMBrowseButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"DEM Resampling Method:", (JComponent)this.demResamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Elevation Band Name:", (JComponent)this.elevationBandName);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableExternalDEM(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue, (boolean)flag);
        this.externalDEMBrowseButton.setVisible(flag);
    }
}

