/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.template.Template;
import org.esa.snap.core.gpf.descriptor.template.TemplateContext;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class TemplateEngine<C> {
    private static final String LINE_SEPARATOR = "\r\n|\n";
    protected ToolAdapterOperatorDescriptor operatorDescriptor;
    protected TemplateContext<C> context;
    protected TemplateContext<C> lastContext;

    protected TemplateEngine(ToolAdapterOperatorDescriptor descriptor) {
        this.operatorDescriptor = descriptor;
    }

    public abstract void parse(Template var1) throws TemplateException;

    public abstract String execute(Template var1, Map<String, Object> var2) throws TemplateException;

    public abstract TemplateType getType();

    public TemplateContext<C> getContext() {
        return this.context != null ? this.context : this.lastContext;
    }

    public static TemplateEngine createInstance(ToolAdapterOperatorDescriptor descriptor, TemplateType templateType) {
        return TemplateEngine.createInstance(descriptor, templateType, false);
    }

    public static TemplateEngine createInstance(ToolAdapterOperatorDescriptor descriptor, TemplateType templateType, boolean stateful) {
        if (templateType == null) {
            throw new IllegalArgumentException("null template");
        }
        switch (templateType) {
            case JAVASCRIPT: {
                return new JavascriptEngine(descriptor, stateful);
            }
            case XSLT: {
                return new XsltEngine(descriptor, stateful);
            }
        }
        return new ApacheVelocityEngine(descriptor, stateful);
    }

    public List<String> getLines(Template template, Map<String, Object> parameters) throws TemplateException {
        if (template == null) {
            throw new IllegalArgumentException("null template");
        }
        String result = this.execute(template, parameters);
        return Arrays.asList(result.split(LINE_SEPARATOR));
    }

    public Path getTemplateBasePath() {
        Path adapterPath = null;
        if (this.operatorDescriptor != null) {
            adapterPath = ToolAdapterIO.getAdaptersPath().resolve(this.operatorDescriptor.getAlias());
        }
        return adapterPath;
    }

    static class XsltEngine
    extends TemplateEngine<Transformer> {
        XsltEngine(ToolAdapterOperatorDescriptor descriptor, boolean stateful) {
            super(descriptor);
        }

        @Override
        public void parse(Template template) throws TemplateException {
            if (template == null) {
                throw new TemplateException("null template");
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                String templateContents = template.getContents();
                saxParser.parse(new InputSource(new StringReader(templateContents)), new DefaultHandler());
            }
            catch (Exception ex) {
                throw new TemplateException(ex);
            }
        }

        @Override
        public String execute(Template template, Map<String, Object> parameters) throws TemplateException {
            String result;
            try {
                StreamSource stringSource = new StreamSource(new StringReader(template.getContents()));
                this.context = new XsltContext(TransformerFactory.newInstance().newTransformer(stringSource));
                Transformer transformContext = (Transformer)this.context.getContext();
                if (parameters != null) {
                    for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                        if (entry.getValue() == null) continue;
                        transformContext.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                transformContext.setOutputProperty("method", "xml");
                transformContext.setOutputProperty("indent", "yes");
                StringWriter writer = new StringWriter();
                transformContext.transform(new DOMSource(), new StreamResult(writer));
                result = writer.toString();
                this.lastContext = this.context;
            }
            catch (Exception ex) {
                throw new TemplateException(ex);
            }
            return result;
        }

        @Override
        public TemplateType getType() {
            return TemplateType.XSLT;
        }

        static class XsltContext
        extends TemplateContext<Transformer> {
            public XsltContext(Transformer transformer) {
                super(transformer);
            }

            @Override
            public Object getValue(String name) {
                return this.context != null ? ((Transformer)this.context).getParameter(name) : null;
            }
        }
    }

    static class JavascriptEngine
    extends TemplateEngine<ScriptContext> {
        private ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("nashorn");

        JavascriptEngine(ToolAdapterOperatorDescriptor descriptor, boolean stateful) {
            super(descriptor);
        }

        @Override
        public void parse(Template template) throws TemplateException {
            try {
                if (template == null) {
                    throw new ScriptException("null template");
                }
                String contents = template.getContents();
                this.scriptEngine.eval(contents);
            }
            catch (IOException | ScriptException ex) {
                throw new TemplateException(ex);
            }
        }

        @Override
        public String execute(Template template, Map<String, Object> parameters) throws TemplateException {
            String result;
            SimpleBindings bindings = new SimpleBindings(parameters);
            this.scriptEngine.setBindings(bindings, 100);
            StringWriter writer = new StringWriter();
            ScriptContext context = this.scriptEngine.getContext();
            context.setWriter(writer);
            try {
                String contents = template.getContents();
                this.scriptEngine.eval(contents);
                this.lastContext = new JavaScriptCtx(this.scriptEngine.getContext());
                result = writer.toString();
            }
            catch (IOException | ScriptException e) {
                throw new TemplateException(e);
            }
            return result;
        }

        @Override
        public TemplateType getType() {
            return TemplateType.JAVASCRIPT;
        }

        static class JavaScriptCtx
        extends TemplateContext<ScriptContext> {
            JavaScriptCtx(ScriptContext wrappedContext) {
                super(wrappedContext);
            }

            @Override
            public Object getValue(String name) {
                return this.context != null ? ((ScriptContext)this.context).getAttribute(name) : null;
            }
        }
    }

    static class ApacheVelocityEngine
    extends TemplateEngine<VelocityContext> {
        private String macroTemplateContents;

        ApacheVelocityEngine(ToolAdapterOperatorDescriptor descriptor, boolean stateful) {
            super(descriptor);
            if (stateful) {
                this.context = new VelocityCtx(new VelocityContext());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("macros.vm")));){
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                if (builder.length() > 0) {
                    builder.setLength(builder.length() - 1);
                    this.macroTemplateContents = builder.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void parse(Template template) throws TemplateException {
            boolean evalResult;
            VelocityEngine veloEngine = new VelocityEngine();
            if (!template.isInMemory()) {
                File templateFile = template.getPath();
                veloEngine.setProperty("file.resource.loader.path", (Object)templateFile.getParent());
            }
            List<SystemVariable> variables = this.operatorDescriptor.getVariables();
            for (SystemVariable variable : variables) {
                String variableValue = variable.getValue();
                if (variableValue == null) {
                    variableValue = "";
                }
                veloEngine.addProperty(variable.getKey(), (Object)variableValue);
            }
            veloEngine.init();
            try {
                String contents = template.getContents();
                evalResult = veloEngine.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), template.getName(), contents);
            }
            catch (Exception inner) {
                throw new TemplateException(inner);
            }
            if (!evalResult) {
                throw new TemplateException("Template evaluation failed");
            }
        }

        @Override
        public String execute(Template template, Map<String, Object> parameters) throws TemplateException {
            try {
                File templateFile;
                VelocityContext veloContext;
                VelocityEngine veloEngine = new VelocityEngine();
                VelocityContext velocityContext = veloContext = this.context != null ? (VelocityContext)this.context.getContext() : new VelocityContext();
                if (!template.isInMemory() && (templateFile = template.getPath()).getParent() != null) {
                    veloEngine.setProperty("file.resource.loader.path", (Object)templateFile.getParent());
                }
                List<SystemVariable> variables = this.operatorDescriptor.getVariables();
                for (SystemVariable systemVariable : variables) {
                    String variableValue = systemVariable.getValue();
                    if (variableValue == null) {
                        variableValue = "";
                    }
                    veloEngine.addProperty(systemVariable.getKey(), (Object)variableValue);
                    veloContext.put(systemVariable.getKey(), (Object)variableValue);
                }
                veloEngine.init();
                org.apache.velocity.Template veloTemplate = this.createTemplate(veloEngine, template);
                for (String key : parameters.keySet()) {
                    veloContext.put(key, parameters.get(key));
                }
                StringWriter stringWriter = new StringWriter();
                veloTemplate.merge((Context)veloContext, (Writer)stringWriter);
                this.lastContext = new VelocityCtx(veloContext);
                return stringWriter.toString();
            }
            catch (Exception inner) {
                throw new TemplateException(inner);
            }
        }

        @Override
        public TemplateType getType() {
            return TemplateType.VELOCITY;
        }

        private org.apache.velocity.Template createTemplate(VelocityEngine engine, Template internalTemplate) throws ParseException, IOException {
            org.apache.velocity.Template template;
            if (this.macroTemplateContents != null && !this.macroTemplateContents.isEmpty()) {
                RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
                String veloTemplate = this.macroTemplateContents + "\n" + (internalTemplate.isInMemory() ? internalTemplate.getContents() : new String(Files.readAllBytes(internalTemplate.getPath().toPath())));
                StringReader reader = new StringReader(veloTemplate);
                SimpleNode node = runtimeServices.parse((Reader)reader, internalTemplate.getName());
                template = new org.apache.velocity.Template();
                template.setRuntimeServices(runtimeServices);
                template.setData((Object)node);
                template.initDocument();
            } else {
                template = engine.getTemplate(internalTemplate.getName());
            }
            return template;
        }

        static class VelocityCtx
        extends TemplateContext<VelocityContext> {
            VelocityCtx(VelocityContext wrappedContext) {
                super(wrappedContext);
            }

            @Override
            public Object getValue(String name) {
                return this.context != null ? ((VelocityContext)this.context).get(name) : null;
            }
        }
    }
}

