/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.template;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.esa.snap.core.gpf.descriptor.template.FileTemplate;
import org.esa.snap.core.gpf.descriptor.template.MemoryTemplate;
import org.esa.snap.core.gpf.descriptor.template.Template;

public class TemplateConverter
implements Converter {
    private final Converter defaultConverter;
    private final ReflectionProvider reflectionProvider;

    public TemplateConverter(Converter defaultConverter, ReflectionProvider reflectionProvider) {
        this.defaultConverter = defaultConverter;
        this.reflectionProvider = reflectionProvider;
    }

    public boolean canConvert(Class type) {
        return Template.class.isAssignableFrom(type);
    }

    public void marshal(Object o, HierarchicalStreamWriter out, MarshallingContext context) {
        this.defaultConverter.marshal(o, out, context);
    }

    public Object unmarshal(HierarchicalStreamReader in, UnmarshallingContext context) {
        String type = in.getAttribute("type");
        Class<MemoryTemplate> resultType = type == null || "simple".equals(type) ? MemoryTemplate.class : FileTemplate.class;
        Object result = this.reflectionProvider.newInstance(resultType);
        return context.convertAnother(result, resultType, this.defaultConverter);
    }
}

