/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.template;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.IOException;
import org.esa.snap.core.gpf.descriptor.template.Template;
import org.esa.snap.core.gpf.descriptor.template.TemplateEngine;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;

@XStreamAlias(value="template")
public class MemoryTemplate
implements Template {
    private static final String DEFAULT_NAME = "Command Template";
    @XStreamOmitField
    private TemplateType templateType;
    @XStreamOmitField
    private TemplateEngine engine;
    @XStreamOmitField
    private String name;
    @XStreamAlias(value="contents")
    private String contents;
    @XStreamAsAttribute
    private String type = "simple";

    public MemoryTemplate() {
        this.name = DEFAULT_NAME;
    }

    public MemoryTemplate(TemplateType templateType) {
        this.templateType = templateType;
        this.name = DEFAULT_NAME;
    }

    public MemoryTemplate(TemplateEngine templateEngine) {
        this(templateEngine, null);
    }

    public MemoryTemplate(TemplateEngine templateEngine, String templateName) {
        this.engine = templateEngine;
        this.templateType = this.engine.getType();
        if (templateName != null) {
            this.setName(templateName);
        } else {
            this.setName(DEFAULT_NAME);
        }
    }

    @Override
    public void associateWith(TemplateEngine engine) throws TemplateException {
        if (engine == null) {
            throw new TemplateException("Null template engine");
        }
        if (this.templateType != null && !engine.getType().equals((Object)this.templateType)) {
            throw new TemplateException("Wrong template engine type");
        }
        this.engine = engine;
    }

    @Override
    public String getContents() throws IOException {
        return this.contents;
    }

    @Override
    public void setContents(String text, boolean shouldParse) throws TemplateException {
        String oldValue = this.contents;
        this.contents = text;
        if (this.contents != null) {
            this.contents = this.contents.replace("\r", "");
        }
        try {
            if (shouldParse) {
                this.engine.parse(this);
            }
        }
        catch (TemplateException e) {
            this.contents = oldValue;
            throw e;
        }
    }

    @Override
    public String getName() {
        return this.name == null ? DEFAULT_NAME : this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public TemplateType getType() {
        return this.templateType;
    }

    @Override
    public void setType(TemplateType value) {
        this.templateType = value;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public File getPath() {
        return new File(this.getName());
    }

    @Override
    public Template copy() throws IOException {
        MemoryTemplate newTemplate = new MemoryTemplate(this.templateType);
        newTemplate.contents = this.contents;
        return newTemplate;
    }
}

