/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.template;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.esa.snap.core.gpf.descriptor.template.Template;
import org.esa.snap.core.gpf.descriptor.template.TemplateEngine;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.util.io.FileUtils;

@XStreamAlias(value="template")
public class FileTemplate
implements Template {
    private static final String defaultNamePattern = "template%s.%s";
    private static int counter = 1;
    @XStreamOmitField
    private TemplateType templateType;
    @XStreamOmitField
    private TemplateEngine engine;
    @XStreamAlias(value="file")
    private String fileName;
    @XStreamOmitField
    private String contents;
    @XStreamAsAttribute
    private String type = "file";

    static Template fromFile(String path) throws TemplateException, IOException {
        FileTemplate template = null;
        if (path != null) {
            File file = new File(path);
            String extension = FileUtils.getExtension((File)file);
            TemplateType templateType = FileTemplate.getTypeByExtension(extension);
            if (templateType == null) {
                throw new TemplateException("Unsupported template extension");
            }
            template = new FileTemplate(templateType);
            template.setName(file.getName());
            template.read();
        }
        return template;
    }

    public FileTemplate() {
    }

    public FileTemplate(TemplateType templateType) {
        this.templateType = templateType;
    }

    public FileTemplate(TemplateEngine templateEngine) {
        this(templateEngine, null);
    }

    public FileTemplate(TemplateEngine templateEngine, String templateFileName) {
        this.engine = templateEngine;
        this.templateType = this.engine.getType();
        if (templateFileName != null) {
            this.setName(templateFileName);
        }
    }

    @Override
    public String getContents() throws IOException {
        if (this.contents == null) {
            this.read();
        }
        return this.contents;
    }

    @Override
    public void setContents(String text, boolean shouldParse) throws TemplateException {
        String oldValue = this.contents;
        this.contents = text;
        if (this.contents != null) {
            this.contents = this.contents.replace("\r", "");
        }
        try {
            if (shouldParse) {
                this.engine.parse(this);
            }
        }
        catch (TemplateException e) {
            this.contents = oldValue;
            throw e;
        }
    }

    @Override
    public String getName() {
        if (this.fileName == null) {
            this.fileName = String.format(defaultNamePattern, counter++, this.getExtension());
        }
        return this.fileName;
    }

    @Override
    public void setName(String value) {
        String extension = FileUtils.getExtension((String)value);
        this.templateType = FileTemplate.getTypeByExtension(extension);
        if (this.templateType == null) {
            throw new IllegalArgumentException("Unsupported file extension");
        }
        this.fileName = FileUtils.getFileNameFromPath((String)value);
    }

    @Override
    public void associateWith(TemplateEngine engine) throws TemplateException {
        if (engine == null) {
            throw new TemplateException("Null template engine");
        }
        if (this.templateType != null && !engine.getType().equals((Object)this.templateType)) {
            throw new TemplateException("Wrong template engine type");
        }
        this.engine = engine;
    }

    @Override
    public File getPath() {
        Path thisPath;
        if (this.engine != null) {
            Path adapterPath = this.engine.getTemplateBasePath();
            thisPath = adapterPath.resolve(this.getName());
        } else {
            thisPath = Paths.get(this.getName(), new String[0]);
        }
        return thisPath.toFile();
    }

    @Override
    public TemplateType getType() {
        if (this.templateType == null) {
            this.templateType = this.fileName != null ? FileTemplate.getTypeByExtension(FileUtils.getExtension((String)this.fileName)) : TemplateType.VELOCITY;
        }
        return this.templateType;
    }

    @Override
    public void setType(TemplateType value) {
        this.templateType = value;
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public void save() throws IOException {
        File path = this.getPath();
        if (path != null) {
            try (FileWriter writer = new FileWriter(path);){
                writer.write(this.getContents());
                writer.flush();
                writer.close();
            }
        }
    }

    @Override
    public Template copy() throws IOException {
        FileTemplate newTemplate = new FileTemplate(this.templateType);
        newTemplate.fileName = this.fileName;
        newTemplate.contents = this.getContents();
        return newTemplate;
    }

    public String toString() {
        return this.getName();
    }

    private String getExtension() {
        String ext;
        switch (this.getType()) {
            case JAVASCRIPT: {
                ext = "js";
                break;
            }
            case XSLT: {
                ext = "xsl";
                break;
            }
            default: {
                ext = "vm";
            }
        }
        return ext;
    }

    private static TemplateType getTypeByExtension(String extension) {
        TemplateType templateType = null;
        if (extension != null && !extension.isEmpty()) {
            switch (extension = extension.toLowerCase()) {
                case ".vm": {
                    templateType = TemplateType.VELOCITY;
                    break;
                }
                case ".js": {
                    templateType = TemplateType.JAVASCRIPT;
                    break;
                }
                case ".xsl": {
                    templateType = TemplateType.XSLT;
                }
            }
        }
        return templateType;
    }

    private String read() throws IOException {
        if (this.contents == null) {
            Path templatePath = this.getPath().toPath();
            byte[] encoded = Files.readAllBytes(templatePath);
            this.contents = new String(encoded, Charset.defaultCharset());
        }
        return this.contents;
    }
}

