/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.dependency;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.descriptor.OSFamily;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.dependency.BundleLocation;
import org.esa.snap.core.gpf.descriptor.dependency.BundleType;
import org.esa.snap.core.gpf.descriptor.template.MemoryTemplate;
import org.esa.snap.core.gpf.descriptor.template.TemplateEngine;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;

@XStreamAlias(value="dependencyBundle")
public class Bundle {
    @XStreamOmitField
    private ToolAdapterOperatorDescriptor parent;
    private BundleType bundleType;
    private BundleLocation bundleLocation;
    private String downloadURL;
    private File source;
    private TemplateParameterDescriptor templateparameter;
    private String targetLocation;
    private String entryPoint;
    private String updateVariable;
    @XStreamOmitField
    private OSFamily operatingSystem;

    private static Bundle initializeBundle(OSFamily osFamily) {
        Bundle bundle = new Bundle(new ToolAdapterOperatorDescriptor("bundle", ToolAdapterOp.class), BundleType.NONE, SystemUtils.getAuxDataPath().toString());
        bundle.setOS(osFamily);
        return bundle;
    }

    public static OSFamily getCurrentOS() {
        return Enum.valueOf(OSFamily.class, ToolAdapterIO.getOsFamily());
    }

    public Bundle() {
        this.bundleType = BundleType.NONE;
        this.bundleLocation = BundleLocation.REMOTE;
        Bundle.initializeBundle(OSFamily.windows);
        Bundle.initializeBundle(OSFamily.linux);
        Bundle.initializeBundle(OSFamily.macosx);
    }

    public Bundle(ToolAdapterOperatorDescriptor descriptor, BundleType bundleType, String targetLocation) {
        this.bundleType = BundleType.NONE;
        this.parent = descriptor;
        this.bundleLocation = BundleLocation.REMOTE;
        this.setBundleType(bundleType);
        this.setTargetLocation(targetLocation);
        this.operatingSystem = Bundle.getCurrentOS();
    }

    public Bundle(Bundle original) {
        this.parent = original.parent;
        this.bundleType = original.bundleType;
        this.bundleLocation = original.bundleLocation;
        this.downloadURL = original.downloadURL;
        this.source = original.source;
        this.templateparameter = original.templateparameter;
        this.targetLocation = original.targetLocation != null ? original.targetLocation.toString().replace("\\", "/") : null;
        this.entryPoint = original.entryPoint;
        this.updateVariable = original.updateVariable;
        this.operatingSystem = original.operatingSystem;
    }

    public ToolAdapterOperatorDescriptor getParent() {
        return this.parent;
    }

    public void setParent(ToolAdapterOperatorDescriptor descriptor) {
        this.parent = descriptor;
    }

    public BundleType getBundleType() {
        return this.bundleType;
    }

    public void setBundleType(BundleType bundleType) {
        this.bundleType = bundleType;
        if (this.bundleType != BundleType.NONE) {
            this.initArgumentsParameter();
        }
    }

    public BundleLocation getLocation() {
        return this.bundleLocation;
    }

    public void setLocation(BundleLocation value) {
        this.bundleLocation = value;
        if (this.bundleLocation.equals((Object)BundleLocation.REMOTE)) {
            this.setSource(null);
        } else {
            this.setDownloadURL(null);
        }
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File value) {
        this.source = value;
        if (value != null) {
            this.setEntryPoint(value.getName());
        }
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(String targetLocation) {
        this.checkEmpty(targetLocation, "targetLocation");
        this.targetLocation = targetLocation;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String url) {
        this.downloadURL = url;
        if (url != null && url.length() > 0) {
            this.setEntryPoint(this.lastSegmentFromUrl(url));
        }
    }

    public boolean isLocal() {
        return this.bundleLocation == BundleLocation.LOCAL;
    }

    public boolean isInstalled() {
        boolean installed = false;
        if (this.bundleType != BundleType.NONE) {
            try {
                if (this.targetLocation != null && this.entryPoint != null && this.parent != null) {
                    Path path = this.parent.resolveVariables(this.targetLocation).toPath().resolve(FileUtils.getFilenameWithoutExtension((String)this.entryPoint));
                    installed = Files.exists(path, new LinkOption[0]) && Files.list(path).count() > 0L;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return installed;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    private void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public TemplateParameterDescriptor getArgumentsParameter() {
        this.initArgumentsParameter();
        return this.templateparameter;
    }

    public void setArgumentsParameter(TemplateParameterDescriptor value) {
        this.templateparameter = value;
    }

    public String getUpdateVariable() {
        return this.updateVariable;
    }

    public void setUpdateVariable(String name) {
        this.updateVariable = name;
    }

    public OSFamily getOS() {
        return this.operatingSystem;
    }

    public void setOS(OSFamily operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getCommandLine() {
        String cmdLine = null;
        if (this.templateparameter != null && this.parent != null) {
            try {
                TemplateEngine templateEngine = this.parent.getTemplateEngine();
                this.templateparameter.setTemplateEngine(templateEngine);
                HashMap<String, Object> params = new HashMap<String, Object>(){
                    {
                        this.put("targetLocation", Bundle.this.parent.resolveVariables(Bundle.this.targetLocation));
                    }
                };
                cmdLine = templateEngine.execute(this.templateparameter.getTemplate(), (Map<String, Object>)params);
            }
            catch (TemplateException e) {
                SystemUtils.LOG.warning(e.getMessage());
            }
        }
        return cmdLine == null || "null".equals(cmdLine) ? "" : cmdLine;
    }

    String[] getCommandLineArguments() {
        String[] args = null;
        String output = this.getCommandLine();
        if (!StringUtils.isNullOrEmpty((String)output)) {
            args = output.replace("\r", "").replace("\t", "").split("\n");
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].trim();
            }
        }
        return args;
    }

    private void initArgumentsParameter() {
        if (this.templateparameter == null || this.templateparameter.getName() == null) {
            this.templateparameter = new TemplateParameterDescriptor("arguments", File.class);
            this.templateparameter.setParameterType("TemplateParameter");
            MemoryTemplate template = new MemoryTemplate(TemplateType.VELOCITY);
            this.templateparameter.setOutputFile(new File(template.getName()));
            ToolParameterDescriptor parameterDescriptor = new ToolParameterDescriptor("targetLocation", File.class);
            parameterDescriptor.setDefaultValue(String.valueOf(this.targetLocation));
            this.templateparameter.addParameterDescriptor(parameterDescriptor);
            if (this.parent != null) {
                try {
                    TemplateEngine templateEngine = this.parent.getTemplateEngine();
                    template.associateWith(templateEngine);
                    this.templateparameter.setTemplateEngine(templateEngine);
                    this.templateparameter.setTemplate(template);
                }
                catch (TemplateException e) {
                    SystemUtils.LOG.warning(e.getMessage());
                }
            }
        }
    }

    private String lastSegmentFromUrl(String url) {
        URI uri = URI.create(url);
        Path urlPath = Paths.get(uri.getPath(), new String[0]);
        return urlPath.getFileName().toString();
    }

    private void checkEmpty(Object value, String property) {
        if (this.bundleType != BundleType.NONE && (value == null || value instanceof String && ((String)value).isEmpty())) {
            throw new IllegalArgumentException(String.format("Property Bundle.%s cannot be empty", property));
        }
    }
}

