/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;

public abstract class VariableResolver {
    private static Map<ToolAdapterOperatorDescriptor, VariableResolver> resolverMap = new HashMap<ToolAdapterOperatorDescriptor, VariableResolver>();
    VariableResolver nextResolver;
    protected ToolAdapterOperatorDescriptor descriptor;

    static VariableResolver newInstance(ToolAdapterOperatorDescriptor descriptor) {
        if (!resolverMap.containsKey(descriptor)) {
            SimpleVariableResolver simpleResolver = new SimpleVariableResolver(descriptor);
            SystemPathVariableResolver systemPathResolver = new SystemPathVariableResolver(descriptor);
            super.setNextResolver(systemPathResolver);
            resolverMap.put(descriptor, simpleResolver);
        }
        return resolverMap.get(descriptor);
    }

    VariableResolver(ToolAdapterOperatorDescriptor operatorDescriptor) {
        this.descriptor = operatorDescriptor;
    }

    public abstract String resolveString(String var1);

    public abstract File resolve(String var1);

    private void setNextResolver(VariableResolver resolver) {
        this.nextResolver = resolver;
    }

    boolean isValidFileName(String fileName) {
        File f = new File(fileName);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    String recursiveResolve(String input) {
        Map<String, String> lookupVars = this.descriptor.getVariables().stream().collect(Collectors.toMap(SystemVariable::getKey, systemVariable -> systemVariable.getValue() != null ? systemVariable.getValue() : ""));
        for (int maxLevels = 3; input.contains("$") && maxLevels > 0; --maxLevels) {
            for (String key : lookupVars.keySet()) {
                input = input.replace("$" + key, lookupVars.get(key));
            }
        }
        return input;
    }

    static class SystemPathVariableResolver
    extends VariableResolver {
        private final String[] systemPath;

        SystemPathVariableResolver(ToolAdapterOperatorDescriptor operatorDescriptor) {
            super(operatorDescriptor);
            String sysPath = System.getenv("PATH");
            this.systemPath = sysPath.split(File.pathSeparator);
        }

        @Override
        public String resolveString(String input) {
            File resolvedFile;
            String resolved = input;
            if (resolved != null && (resolvedFile = this.resolve(input)) != null) {
                resolved = resolvedFile.getAbsolutePath();
            }
            return resolved;
        }

        @Override
        public File resolve(String input) {
            if (input == null) {
                return null;
            }
            File resolved = new File(input);
            if (!resolved.exists()) {
                for (String sysPath : this.systemPath) {
                    File current = new File(sysPath, resolved.getPath());
                    if (!current.exists()) continue;
                    resolved = current;
                    break;
                }
                if (this.nextResolver != null) {
                    resolved = this.nextResolver.resolve(input);
                }
            }
            return resolved;
        }
    }

    static class SimpleVariableResolver
    extends VariableResolver {
        SimpleVariableResolver(ToolAdapterOperatorDescriptor operatorDescriptor) {
            super(operatorDescriptor);
        }

        @Override
        public String resolveString(String input) {
            String resolved = input;
            if (input != null) {
                resolved = this.recursiveResolve(resolved);
                if (this.nextResolver != null && this.isValidFileName(resolved)) {
                    resolved = this.nextResolver.resolveString(resolved);
                }
            }
            return resolved;
        }

        @Override
        public File resolve(String input) {
            if (input == null) {
                return null;
            }
            File resolved = new File(input);
            if (!resolved.exists()) {
                String expandedValue = this.recursiveResolve(resolved.getPath());
                resolved = new File(expandedValue);
                if (this.nextResolver != null && !resolved.exists()) {
                    resolved = this.nextResolver.resolve(resolved.toString());
                }
            }
            return resolved;
        }
    }
}

