/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance;

import Jama.Matrix;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.AbstractDistance;

public class MahalanobisDistance
extends AbstractDistance {
    private static final long serialVersionUID = -5844297515283628612L;

    @Override
    public double measure(Instance i, Instance j) {
        double[][] del = new double[3][1];
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 1; ++n) {
                del[m][n] = i.value(m) - j.value(m);
            }
        }
        Matrix M1 = new Matrix(del);
        Matrix M2 = M1.transpose();
        double[][] covar = new double[3][3];
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 3; ++n) {
                double[] dArray = covar[m];
                int n2 = n;
                dArray[n2] = dArray[n2] + (i.value(m) - j.value(m)) * (i.value(n) - j.value(n));
            }
        }
        Matrix cov = new Matrix(covar);
        Matrix covInv = cov.inverse();
        Matrix temp1 = M2.times(covInv);
        Matrix temp2 = temp1.times(M1);
        double dist = temp2.trace();
        if (dist > 0.0) {
            dist = Math.sqrt(dist);
        }
        return dist;
    }
}

