/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class SOM
implements Clusterer {
    private static final long serialVersionUID = -2023942260277855655L;
    private GridType gridType;
    private LearningType learningType;
    private NeighbourhoodFunction neighbourhoodFunction;
    private int xdim;
    private int ydim;
    private int iterations;
    private int initialRadius;
    private double learningRate;
    private DistanceMeasure dm;
    private WeightVectors wV;

    private double getDistance(double[] x, double[] y) {
        return this.dm.measure(new DenseInstance(x), new DenseInstance(y));
    }

    public SOM() {
        this(2, 2, GridType.HEXAGONAL, 1000, 0.1, 8, LearningType.LINEAR, NeighbourhoodFunction.STEP);
    }

    public SOM(int xdim, int ydim, GridType grid, int iterations, double learningRate, int initialRadius, LearningType learning, NeighbourhoodFunction nbf) {
        this(xdim, ydim, grid, iterations, learningRate, initialRadius, learning, nbf, new EuclideanDistance());
    }

    public SOM(int xdim, int ydim, GridType grid, int iterations, double learningRate, int initialRadius, LearningType learning, NeighbourhoodFunction nbf, DistanceMeasure dm) {
        this.gridType = grid;
        this.learningType = learning;
        this.neighbourhoodFunction = nbf;
        this.xdim = xdim;
        this.ydim = ydim;
        this.iterations = iterations;
        this.learningRate = learningRate;
        this.initialRadius = initialRadius;
        this.dm = dm;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        this.wV = new WeightVectors(this.xdim, this.ydim, data.noAttributes(), this.gridType.toString());
        InputVectors iV = this.convertDataset(data);
        JSomTraining jst = new JSomTraining(iV);
        jst.setTrainingInstructions(this.iterations, this.learningRate, this.initialRadius, this.learningType.toString(), this.neighbourhoodFunction.toString());
        jst.doTraining();
        Vector<Dataset> clusters = new Vector<Dataset>();
        for (int i = 0; i < this.wV.size(); ++i) {
            clusters.add(new DefaultDataset());
        }
        this.wV = this.doLabeling(this.wV, iV, data, clusters);
        int nonEmptyClusterCount = 0;
        for (int i = 0; i < clusters.size(); ++i) {
            if (clusters.get(i).size() <= 0) continue;
            ++nonEmptyClusterCount;
        }
        Dataset[] output = new Dataset[nonEmptyClusterCount];
        int index = 0;
        for (Dataset tmp : clusters) {
            if (tmp.size() <= 0) continue;
            output[index] = tmp;
            ++index;
        }
        return output;
    }

    private WeightVectors doLabeling(WeightVectors wVector, InputVectors iVector, Dataset data, Vector<Dataset> clusters) {
        for (int i = 0; i < data.size(); ++i) {
            int index = this.resolveIndexOfWinningNeuron(iVector.getNodeValuesAt(i));
            clusters.get(index).add(data.instance(i));
            wVector.setNodeLabelAt(index, iVector.getNodeLabelAt(i));
        }
        return wVector;
    }

    private int resolveIndexOfWinningNeuron(double[] values) {
        double bestDistance = this.getDistance(values, this.wV.getNodeValuesAt(0));
        int index = 0;
        for (int i = 1; i < this.wV.size(); ++i) {
            double dist = this.getDistance(values, this.wV.getNodeValuesAt(i));
            if (!(dist < bestDistance)) continue;
            index = i;
            bestDistance = dist;
        }
        return index;
    }

    private InputVectors convertDataset(Dataset data) {
        InputVectors iVS = new InputVectors();
        for (int i = 0; i < data.size(); ++i) {
            Double[] values = data.instance(i).values().toArray(new Double[0]);
            SomNode tmp = new SomNode("node_" + i, values);
            iVS.add(tmp);
        }
        return iVS;
    }

    public static enum LearningType {
        EXPONENTIAL("exponential"),
        INVERSE("inverse"),
        LINEAR("linear");

        private String tag;

        private LearningType(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }

    public static enum NeighbourhoodFunction {
        GAUSSIAN("gaussian"),
        STEP("step");

        private String tag;

        private NeighbourhoodFunction(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }

    public static enum GridType {
        HEXAGONAL("hexa"),
        RECTANGLES("rect");

        private String tag;

        private GridType(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }

    private class JSomTraining {
        private int index;
        private JSomMath math;
        private InputVectors iVector;
        private String neigh;
        private int steps;
        private double lrate;
        private String lrateType;
        private double width;
        private Random generator;
        private int wVectorSize;
        private int iVectorSize;

        private JSomTraining(InputVectors iVector) {
            this.iVector = iVector;
            this.math = new JSomMath(SOM.this.wV.getDimensionalityOfNodes());
            this.generator = new Random();
        }

        private void setTrainingInstructions(int steps, double lrate, int radius, String lrateType, String neigh) {
            this.steps = steps;
            this.lrate = lrate;
            this.lrateType = lrateType;
            this.neigh = neigh;
            this.width = radius;
        }

        private void doTraining() {
            this.iVectorSize = this.iVector.getCount();
            this.wVectorSize = SOM.this.wV.getCount();
            if (this.lrateType.equals("exponential") && this.neigh.equals("step")) {
                this.doBubbleExpAdaptation();
            } else if (this.lrateType.equals("linear") && this.neigh.equals("step")) {
                this.doBubbleLinAdaptation();
            } else if (this.lrateType.equals("inverse") && this.neigh.equals("step")) {
                this.doBubbleInvAdaptation();
            } else if (this.lrateType.equals("exponential") && this.neigh.equals("gaussian")) {
                this.doGaussianExpAdaptation();
            } else if (this.lrateType.equals("linear") && this.neigh.equals("gaussian")) {
                this.doGaussianLinAdaptation();
            } else {
                this.doGaussianInvAdaptation();
            }
        }

        private void doBubbleExpAdaptation() {
            double s = this.steps;
            for (int n = 0; n < this.steps; ++n) {
                double wCache = Math.ceil(this.width * (1.0 - (double)n / s));
                double exp = this.math.expLRP(n, this.lrate, this.steps);
                double[] input = this.iVector.getNodeValuesAt(this.generator.nextInt(this.iVectorSize));
                this.index = SOM.this.resolveIndexOfWinningNeuron(input);
                double[] wLocation = SOM.this.wV.getNodeLocationAt(this.index);
                for (int h = 0; h < this.wVectorSize; ++h) {
                    SOM.this.wV.setNodeValuesAt(h, this.math.bubbleAdaptation(input, SOM.this.wV.getNodeValuesAt(h), wLocation, SOM.this.wV.getNodeLocationAt(h), wCache, exp));
                }
            }
        }

        private void doBubbleLinAdaptation() {
            double s = this.steps;
            for (int n = 0; n < this.steps; ++n) {
                double wCache = Math.ceil(this.width * (1.0 - (double)n / s));
                double lin = this.math.linLRP(n, this.lrate, this.steps);
                double[] input = this.iVector.getNodeValuesAt(this.generator.nextInt(this.iVectorSize));
                this.index = SOM.this.resolveIndexOfWinningNeuron(input);
                double[] wLocation = SOM.this.wV.getNodeLocationAt(this.index);
                for (int h = 0; h < this.wVectorSize; ++h) {
                    SOM.this.wV.setNodeValuesAt(h, this.math.bubbleAdaptation(input, SOM.this.wV.getNodeValuesAt(h), wLocation, SOM.this.wV.getNodeLocationAt(h), wCache, lin));
                }
            }
        }

        private void doBubbleInvAdaptation() {
            double s = this.steps;
            double A = (double)this.steps / 100.0;
            for (int n = 0; n < this.steps; ++n) {
                double wCache = Math.ceil(this.width * (1.0 - (double)n / s));
                double inv = this.math.invLRP(n, this.lrate, A, A);
                double[] input = this.iVector.getNodeValuesAt(this.generator.nextInt(this.iVectorSize));
                this.index = SOM.this.resolveIndexOfWinningNeuron(input);
                double[] wLocation = SOM.this.wV.getNodeLocationAt(this.index);
                for (int h = 0; h < this.wVectorSize; ++h) {
                    SOM.this.wV.setNodeValuesAt(h, this.math.bubbleAdaptation(input, SOM.this.wV.getNodeValuesAt(h), wLocation, SOM.this.wV.getNodeLocationAt(h), wCache, inv));
                }
            }
        }

        private void doGaussianExpAdaptation() {
            for (int n = 0; n < this.steps; ++n) {
                double wCache = this.math.gaussianWidth(this.width, n, this.steps);
                double exp = this.math.expLRP(n, this.lrate, this.steps);
                double[] input = this.iVector.getNodeValuesAt(this.generator.nextInt(this.iVectorSize));
                this.index = SOM.this.resolveIndexOfWinningNeuron(input);
                double[] wLocation = SOM.this.wV.getNodeLocationAt(this.index);
                for (int h = 0; h < this.wVectorSize; ++h) {
                    SOM.this.wV.setNodeValuesAt(h, this.math.gaussianAdaptation(input, SOM.this.wV.getNodeValuesAt(h), wLocation, SOM.this.wV.getNodeLocationAt(h), wCache, exp));
                }
            }
        }

        private void doGaussianLinAdaptation() {
            for (int n = 0; n < this.steps; ++n) {
                double wCache = this.math.gaussianWidth(this.width, n, this.steps);
                double lin = this.math.linLRP(n, this.lrate, this.steps);
                double[] input = this.iVector.getNodeValuesAt(this.generator.nextInt(this.iVectorSize));
                this.index = SOM.this.resolveIndexOfWinningNeuron(input);
                double[] wLocation = SOM.this.wV.getNodeLocationAt(this.index);
                for (int h = 0; h < this.wVectorSize; ++h) {
                    SOM.this.wV.setNodeValuesAt(h, this.math.gaussianAdaptation(input, SOM.this.wV.getNodeValuesAt(h), wLocation, SOM.this.wV.getNodeLocationAt(h), wCache, lin));
                }
            }
        }

        private void doGaussianInvAdaptation() {
            double A = (double)this.steps / 100.0;
            for (int n = 0; n < this.steps; ++n) {
                double wCache = this.math.gaussianWidth(this.width, n, this.steps);
                double inv = this.math.invLRP(n, this.lrate, A, A);
                double[] input = this.iVector.getNodeValuesAt(this.generator.nextInt(this.iVectorSize));
                this.index = SOM.this.resolveIndexOfWinningNeuron(input);
                double[] wLocation = SOM.this.wV.getNodeLocationAt(this.index);
                for (int h = 0; h < this.wVectorSize; ++h) {
                    SOM.this.wV.setNodeValuesAt(h, this.math.gaussianAdaptation(input, SOM.this.wV.getNodeValuesAt(h), wLocation, SOM.this.wV.getNodeLocationAt(h), wCache, inv));
                }
            }
        }
    }

    private class SomNode {
        private String label;
        private double[] values;
        private double[] location;

        public String toString() {
            String out = "";
            out = out + "\tVAL: " + Arrays.toString(this.values);
            out = out + "\n\tPOS: " + Arrays.toString(this.location);
            out = out + "\n\tLAB: " + this.label;
            out = out + "\n";
            return out;
        }

        private SomNode() {
            this.label = "";
            this.values = new double[1];
            this.location = new double[1];
        }

        private SomNode(String label, Double[] values) {
            this.label = label;
            this.values = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = values[i];
            }
            this.location = new double[1];
        }

        private SomNode(double[] values, double[] location) {
            this.label = "";
            this.values = (double[])values.clone();
            this.location = (double[])location.clone();
        }

        private void setValues(double[] values) {
            this.values = (double[])values.clone();
        }

        private double[] getValues() {
            return (double[])this.values.clone();
        }

        private void setLabel(String label) {
            this.label = label;
        }

        private void addLabel(String label) {
            this.label = this.label + ", " + label;
        }

        private String getLabel() {
            return this.label;
        }

        private double[] getLocation() {
            return (double[])this.location.clone();
        }

        private boolean isLabeled() {
            return this.label.length() > 0;
        }
    }

    private class WeightVectors
    extends ArrayList<SomNode> {
        private static final long serialVersionUID = -8922053499602333314L;
        private double[] values;
        private double[] location;
        private String lattice;
        private Random generator;
        private int dimension;
        private final double YVALUE = 0.866;

        private WeightVectors(int xDim, int yDim, int dimension, String type) {
            super(xDim * yDim);
            this.YVALUE = 0.866;
            int size = xDim * yDim;
            this.dimension = dimension;
            this.values = new double[dimension];
            this.location = new double[2];
            this.generator = new Random();
            this.lattice = type;
            int yCounter = 0;
            int xCounter = 0;
            double xValue = 0.0;
            double yValue = 0.0;
            boolean evenRow = false;
            if (this.lattice.equals("rect")) {
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < dimension; ++j) {
                        this.values[j] = this.generator.nextDouble();
                    }
                    if (xCounter < xDim) {
                        this.location[0] = xCounter;
                        this.location[1] = yCounter;
                        ++xCounter;
                    } else {
                        xCounter = 0;
                        this.location[0] = xCounter;
                        this.location[1] = ++yCounter;
                        ++xCounter;
                    }
                    this.add(new SomNode(this.values, this.location));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < dimension; ++j) {
                        this.values[j] = this.generator.nextDouble();
                    }
                    if (xCounter < xDim) {
                        this.location[0] = xValue;
                        this.location[1] = yValue;
                        xValue += 1.0;
                        ++xCounter;
                    } else {
                        xCounter = 0;
                        yValue += 0.866;
                        if (evenRow) {
                            xValue = 0.0;
                            evenRow = false;
                        } else {
                            xValue = 0.5;
                            evenRow = true;
                        }
                        this.location[0] = xValue;
                        this.location[1] = yValue;
                        xValue += 1.0;
                        ++xCounter;
                    }
                    this.add(new SomNode(this.values, this.location));
                }
            }
        }

        private double[] getNodeValuesAt(int index) {
            SomNode cache = (SomNode)this.get(index);
            return cache.getValues();
        }

        private void setNodeValuesAt(int index, double[] values) {
            SomNode cache = (SomNode)this.get(index);
            cache.setValues(values);
            this.set(index, cache);
        }

        private double[] getNodeLocationAt(int index) {
            SomNode cache = (SomNode)this.get(index);
            return cache.getLocation();
        }

        private int getDimensionalityOfNodes() {
            return this.dimension;
        }

        private int getCount() {
            return this.size();
        }

        private void setNodeLabelAt(int index, String label) {
            SomNode cache = (SomNode)this.get(index);
            if (cache.isLabeled()) {
                cache.addLabel(label);
            } else {
                cache.setLabel(label);
            }
            this.set(index, cache);
        }
    }

    private class InputVectors
    extends ArrayList<SomNode> {
        private static final long serialVersionUID = 703966236164827750L;

        private InputVectors() {
            super(1000);
        }

        private InputVectors(int capacity) {
            super(capacity);
        }

        private double[] getNodeValuesAt(int index) {
            SomNode cache = (SomNode)this.get(index);
            return cache.getValues();
        }

        private String getNodeLabelAt(int index) {
            SomNode cache = (SomNode)this.get(index);
            return cache.getLabel();
        }

        private int getCount() {
            return this.size();
        }
    }

    private class JSomMath {
        private double[] cacheVector;
        private int sizeVector;
        private double gaussianCache;

        private JSomMath(int vectorSize) {
            this.cacheVector = new double[vectorSize];
            this.sizeVector = this.cacheVector.length;
        }

        private double expLRP(int n, double a, int A) {
            return a * Math.exp(-1.0 * (double)n / (double)A);
        }

        private double linLRP(int n, double a, int A) {
            return a * (1.0 - (double)n / (double)A);
        }

        private double invLRP(int n, double a, double A, double B) {
            return a * (A / (B + (double)n));
        }

        private double gaussianWidth(double g, int n, int t) {
            return g * Math.exp(-1.0 * (double)n / (double)t);
        }

        private double gaussianNF(double[] i, double[] j, double width) {
            this.gaussianCache = SOM.this.getDistance(i, j);
            return Math.exp(-1.0 * this.gaussianCache * this.gaussianCache / (2.0 * width * width));
        }

        private boolean bubbleNF(double[] i, double[] j, double g) {
            return SOM.this.getDistance(i, j) <= g;
        }

        private double[] bubbleAdaptation(double[] x, double[] w, double[] i, double[] j, double g, double lrp) {
            if (this.bubbleNF(i, j, g)) {
                for (int k = 0; k < this.sizeVector; ++k) {
                    this.cacheVector[k] = w[k] + lrp * (x[k] - w[k]);
                }
            } else {
                return w;
            }
            return this.cacheVector;
        }

        private double[] gaussianAdaptation(double[] x, double[] w, double[] i, double[] j, double width, double lrp) {
            this.gaussianCache = this.gaussianNF(i, j, width);
            for (int k = 0; k < this.sizeVector; ++k) {
                this.cacheVector[k] = w[k] + lrp * this.gaussianCache * (x[k] - w[k]);
            }
            return this.cacheVector;
        }
    }
}

