/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.clustering.KMeans;
import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class IterativeKMeans
implements Clusterer {
    private int kMin;
    private int kMax;
    private ClusterEvaluation ce;
    private DistanceMeasure dm;
    private int iterations;

    public IterativeKMeans(ClusterEvaluation ce) {
        this(2, 10, 100, new EuclideanDistance(), ce);
    }

    public IterativeKMeans(int kMin, int kMax, ClusterEvaluation ce) {
        this(kMin, kMax, 100, new EuclideanDistance(), ce);
    }

    public IterativeKMeans(int kMin, int kMax, int iterations, DistanceMeasure dm, ClusterEvaluation ce) {
        this.kMin = kMin;
        this.kMax = kMax;
        this.iterations = iterations;
        this.dm = dm;
        this.ce = ce;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        KMeans km = new KMeans(this.kMin, this.iterations, this.dm);
        Dataset[] bestClusters = km.cluster(data);
        double bestScore = this.ce.score(bestClusters);
        for (int i = this.kMin + 1; i <= this.kMax; ++i) {
            km = new KMeans(i, this.iterations, this.dm);
            Dataset[] tmpClusters = km.cluster(data);
            double tmpScore = this.ce.score(tmpClusters);
            if (!this.ce.compareScore(bestScore, tmpScore)) continue;
            bestScore = tmpScore;
            bestClusters = tmpClusters;
        }
        return bestClusters;
    }
}

