/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import javax.media.jai.JAI;
import javax.media.jai.SourcelessOpImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.image.ImageHeader;
import org.esa.snap.core.util.ImageUtils;

class TemporaryMODISImage
extends SourcelessOpImage {
    private final Product[] products;
    private int count = 0;
    private Strategy strategy;

    public TemporaryMODISImage(ImageHeader imageHeader, Product[] products, int mode) {
        super(imageHeader.getImageLayout(), null, ImageUtils.createSingleBandedSampleModel((int)0, (int)imageHeader.getImageLayout().getSampleModel(null).getWidth(), (int)imageHeader.getImageLayout().getSampleModel(null).getHeight()), imageHeader.getImageLayout().getMinX(null), imageHeader.getImageLayout().getMinY(null), imageHeader.getImageLayout().getWidth(null), imageHeader.getImageLayout().getHeight(null));
        this.products = products;
        this.strategy = mode == 0 ? new NorthStrategy() : new SouthStrategy();
        this.setTileCache(JAI.createTileCache((long)0x3200000L));
    }

    public Raster computeTile(int tileX, int tileY) {
        ++this.count;
        int numTiles = this.getNumXTiles() * this.getNumYTiles();
        System.out.println("Writing tile '" + tileX + ", " + tileY + "', which is tile " + this.count + "/" + numTiles + ".");
        Point location = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.getSampleModel(), location);
        PixelPos pixelPos = new PixelPos();
        for (int x = dest.getMinX(); x < dest.getMinX() + dest.getWidth(); ++x) {
            block1: for (int y = dest.getMinY(); y < dest.getMinY() + dest.getHeight(); ++y) {
                Product[] products;
                if (this.strategy.isSourceInvalid(x, y)) {
                    dest.setSample(x, y, 0, 0);
                    continue;
                }
                int xOffset = this.strategy.xOffset(x);
                int yOffset = this.strategy.yOffset(y);
                dest.setSample(x, y, 0, 1);
                GeoPos geoPos = this.strategy.getGeoPos(x + xOffset, y + yOffset);
                for (Product product : products = this.getProducts(geoPos)) {
                    product.getSceneGeoCoding().getPixelPos(geoPos, pixelPos);
                    Band band = product.getBand("water_mask");
                    MultiLevelImage sourceImage = band.getSourceImage();
                    Raster tile = sourceImage.getTile(sourceImage.XToTileX((int)pixelPos.x), sourceImage.YToTileY((int)pixelPos.y));
                    int sample = tile.getSample((int)pixelPos.x, (int)pixelPos.y, 0);
                    if ((double)sample == band.getNoDataValue()) continue;
                    dest.setSample(x, y, 0, sample);
                    continue block1;
                }
            }
        }
        return dest;
    }

    private Product[] getProducts(GeoPos geoPos) {
        ArrayList<Product> result = new ArrayList<Product>();
        for (Product product : this.products) {
            PixelPos pixelPos = product.getSceneGeoCoding().getPixelPos(geoPos, null);
            if (!pixelPos.isValid() || !(pixelPos.x > 0.0) || !(pixelPos.x < (double)product.getSceneRasterWidth()) || !(pixelPos.y > 0.0) || !(pixelPos.y < (double)product.getSceneRasterHeight())) continue;
            result.add(product);
        }
        return result.toArray(new Product[result.size()]);
    }

    private class NorthStrategy
    implements Strategy {
        private NorthStrategy() {
        }

        @Override
        public int xOffset(int x) {
            return 0;
        }

        @Override
        public int yOffset(int y) {
            return 0;
        }

        @Override
        public boolean isSourceInvalid(int x, int y) {
            return false;
        }

        @Override
        public GeoPos getGeoPos(int x, int y) {
            double pixelSizeX = 0.0023148148148148147;
            double pixelSizeY = 0.0023148148148148147;
            double lon = -180.0 + (double)x * 0.0023148148148148147;
            double lat = -90.0 + (double)y * 0.0023148148148148147;
            return new GeoPos((double)((float)lat), (double)((float)lon));
        }
    }

    private class SouthStrategy
    implements Strategy {
        private SouthStrategy() {
        }

        @Override
        public int xOffset(int x) {
            int xOffset = 0;
            if (x == 77758) {
                xOffset = -1;
            } else if (x == 77759) {
                xOffset = -2;
            } else if (x == 77760) {
                xOffset = 1;
            }
            return xOffset;
        }

        @Override
        public int yOffset(int y) {
            int yOffset = 0;
            if (y == 4286 || y == 8601) {
                yOffset = -1;
            }
            return yOffset;
        }

        @Override
        public boolean isSourceInvalid(int x, int y) {
            return y > 10860 || y > 10473 && x > 154127 || y > 10486 && x < 1436 || y > 10491 && x > 153820 || y > 10548 && x > 1432 && x < 1675;
        }

        @Override
        public GeoPos getGeoPos(int x, int y) {
            double pixelSizeX = 0.0023148148148148147;
            double pixelSizeY = -0.0023148148148148147;
            double lon = -180.0 + (double)x * 0.0023148148148148147;
            double lat = -60.0 + (double)y * -0.0023148148148148147;
            return new GeoPos((double)((float)lat), (double)((float)lon));
        }
    }

    private static interface Strategy {
        public GeoPos getGeoPos(int var1, int var2);

        public int xOffset(int var1);

        public int yOffset(int var1);

        public boolean isSourceInvalid(int var1, int var2);
    }
}

