/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.rcp;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.landcover.dataio.LandCoverFactory;
import org.esa.snap.landcover.gpf.AddLandCoverOp;
import org.esa.snap.landcover.rcp.Bundle;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.ModalDialog;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class AddLandCoverAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
HelpCtx.Provider {
    private static final String HELP_ID = "addLandCoverBand";
    private final Lookup lkp;
    private Product product;
    public static final String DIALOG_TITLE = "Add Land Cover Band";

    public AddLandCoverAction() {
        this(Utilities.actionsGlobalContext());
    }

    public AddLandCoverAction(Lookup lkp) {
        super(Bundle.CTL_AddLandCoverAction_MenuText());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.setEnableState();
        this.putValue("ShortDescription", Bundle.CTL_AddLandCoverAction_ShortDescription());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AddLandCoverAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null) {
            this.product = productNode.getProduct();
            state = this.product.getSceneGeoCoding() != null;
        }
        this.setEnabled(state);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            AddLandCoverOp.LandCoverParameters param = this.requestDialogData(this.product);
            if (param == null) {
                return;
            }
            AddLandCoverOp.AddLandCover((Product)this.product, (AddLandCoverOp.LandCoverParameters)param);
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError(e.getMessage(), (Throwable)e);
        }
    }

    private AddLandCoverOp.LandCoverParameters requestDialogData(Product product) {
        String[] Names = LandCoverFactory.getNameList();
        List<String> sortedNames = Arrays.asList(Names);
        Collections.sort(sortedNames);
        Names = sortedNames.toArray(new String[sortedNames.size()]);
        AddLandCoverOp.LandCoverParameters dialogData = new AddLandCoverOp.LandCoverParameters(Names[0], "NEAREST_NEIGHBOUR");
        PropertyContainer propertySet = PropertyContainer.createObjectBacked((Object)dialogData);
        AddLandCoverAction.configureNameProperty((PropertySet)propertySet, "name", Names, Names[0]);
        AddLandCoverAction.configureNameProperty((PropertySet)propertySet, "resamplingMethod", ResamplingFactory.resamplingNames, "NEAREST_NEIGHBOUR");
        AddLandCoverAction.configureBandNameProperty((PropertySet)propertySet, "bandName", product);
        BindingContext ctx = new BindingContext((PropertySet)propertySet);
        JList landCoverList = new JList();
        landCoverList.setVisibleRowCount(10);
        ctx.bind("name", (ComponentAdapter)new SingleSelectionListComponentAdapter(landCoverList, product));
        JTextField bandNameField = new JTextField();
        bandNameField.setColumns(30);
        ctx.bind("bandName", bandNameField);
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(4, 4);
        for (int i = 0; i < 8; ++i) {
            tableLayout.setCellColspan(i, 0, Integer.valueOf(2));
        }
        JPanel parameterPanel = new JPanel((LayoutManager)tableLayout);
        parameterPanel.add(new JLabel("Land Cover Model:"));
        parameterPanel.add(new JScrollPane(landCoverList));
        parameterPanel.add(new JLabel("Resampling method:"));
        JComboBox<String> resamplingCombo = new JComboBox<String>(ResamplingFactory.resamplingNames);
        parameterPanel.add(resamplingCombo);
        ctx.bind("resamplingMethod", resamplingCombo);
        parameterPanel.add(new JLabel("Integer data types will use nearest neighbour"));
        parameterPanel.add(new JLabel("Land cover band name:"));
        parameterPanel.add(bandNameField);
        ModalDialog dialog = new ModalDialog((Window)SnapApp.getDefault().getMainFrame(), DIALOG_TITLE, 33, HELP_ID);
        dialog.setContent((Component)parameterPanel);
        if (dialog.show() == 1) {
            return dialogData;
        }
        return null;
    }

    private static void configureNameProperty(PropertySet propertySet, String propertyName, String[] names, String defaultValue) {
        PropertyDescriptor descriptor = propertySet.getProperty(propertyName).getDescriptor();
        descriptor.setValueSet(new ValueSet((Object[])names));
        descriptor.setDefaultValue((Object)defaultValue);
        descriptor.setNotNull(true);
        descriptor.setNotEmpty(true);
    }

    private static void configureBandNameProperty(PropertySet propertySet, String propertyName, Product product) {
        Property property = propertySet.getProperty(propertyName);
        PropertyDescriptor descriptor = property.getDescriptor();
        descriptor.setNotNull(true);
        descriptor.setNotEmpty(true);
        descriptor.setValidator((Validator)new BandNameValidator(product));
    }

    private static class BandNameValidator
    implements Validator {
        private final Product product;

        public BandNameValidator(Product product) {
            this.product = product;
        }

        public void validateValue(Property property, Object value) throws ValidationException {
            String bandName = value.toString().trim();
            if (!ProductNode.isValidNodeName((String)bandName)) {
                throw new ValidationException(MessageFormat.format("The band name ''{0}'' appears not to be valid.\nPlease choose another one.", bandName));
            }
            if (this.product.containsBand(bandName)) {
                throw new ValidationException(MessageFormat.format("The selected product already contains a band named ''{0}''.\nPlease choose another one.", bandName));
            }
        }
    }

    private static class SingleSelectionListComponentAdapter
    extends ComponentAdapter
    implements ListSelectionListener,
    PropertyChangeListener {
        private final JList list;
        private final Product product;

        public SingleSelectionListComponentAdapter(JList list, Product product) {
            this.list = list;
            this.product = product;
            list.setSelectionMode(0);
        }

        public JComponent[] getComponents() {
            return new JComponent[]{this.list};
        }

        public void bindComponents() {
            this.updateListModel();
            this.getPropertyDescriptor().addAttributeChangeListener((PropertyChangeListener)this);
            this.list.addListSelectionListener(this);
        }

        public void unbindComponents() {
            this.getPropertyDescriptor().removeAttributeChangeListener((PropertyChangeListener)this);
            this.list.removeListSelectionListener(this);
        }

        public void adjustComponents() {
            Object value = this.getBinding().getPropertyValue();
            if (value != null) {
                this.list.setSelectedValue(value, true);
            } else {
                this.list.clearSelection();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.getPropertyDescriptor() && evt.getPropertyName().equals("valueSet")) {
                this.updateListModel();
            }
        }

        private PropertyDescriptor getPropertyDescriptor() {
            return this.getBinding().getContext().getPropertySet().getDescriptor(this.getBinding().getPropertyName());
        }

        private void updateListModel() {
            ValueSet valueSet = this.getPropertyDescriptor().getValueSet();
            if (valueSet != null) {
                this.list.setListData(valueSet.getItems());
                this.adjustComponents();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (this.getBinding().isAdjustingComponents()) {
                return;
            }
            Property property = this.getBinding().getContext().getPropertySet().getProperty(this.getBinding().getPropertyName());
            Object selectedValue = this.list.getSelectedValue();
            try {
                property.setValue(selectedValue);
                Property bandNameProperty = this.getBinding().getContext().getPropertySet().getProperty("bandName");
                bandNameProperty.setValueFromText(AddLandCoverOp.getValidBandName((String)((String)selectedValue), (Product)this.product));
                this.getBinding().clearProblem();
            }
            catch (ValidationException e) {
                this.getBinding().reportProblem((BindingException)e);
            }
        }
    }
}

