/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.landcover.dataio.LandCoverFactory;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.SnapFileChooser;

public class AddLandCoverOpUI
extends BaseOperatorUI {
    private final JList<String> landCoverNamesList = new JList();
    private final JList<File> externalFileList = new JList();
    private final JButton externalFileBrowseButton = new JButton("...");
    private final JComboBox<String> resamplingMethodCombo = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private static final String lastLandcoverPathKey = "snap.external.landcoverDir";

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        String[] Names = LandCoverFactory.getNameList();
        List<String> sortedNames = Arrays.asList(Names);
        Collections.sort(sortedNames);
        Names = sortedNames.toArray(new String[sortedNames.size()]);
        this.landCoverNamesList.setListData((String[])Names);
        this.initParameters();
        this.externalFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files = AddLandCoverOpUI.getSelectedFiles();
                if (files != null) {
                    AddLandCoverOpUI.this.externalFileList.removeAll();
                    AddLandCoverOpUI.this.externalFileList.setListData(files);
                    AddLandCoverOpUI.this.externalFileList.setSelectionInterval(0, AddLandCoverOpUI.this.externalFileList.getModel().getSize() - 1);
                    AddLandCoverOpUI.this.landCoverNamesList.clearSelection();
                }
            }
        });
        return new JScrollPane(panel);
    }

    private static File[] getSelectedFiles() {
        JFileChooser fileChooser = AddLandCoverOpUI.createFileChooserDialog(lastLandcoverPathKey);
        int result = fileChooser.showOpenDialog(SnapApp.getDefault().getMainFrame());
        if (fileChooser.getCurrentDirectory() != null) {
            SnapApp.getDefault().getPreferences().put(lastLandcoverPathKey, fileChooser.getCurrentDirectory().getPath());
        }
        if (result == 0) {
            return fileChooser.getSelectedFiles();
        }
        return null;
    }

    private static JFileChooser createFileChooserDialog(String preferencesKey) {
        SnapFileChooser chooser = new SnapFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(true);
        String lastDir = SnapApp.getDefault().getPreferences().get(preferencesKey, SystemUtils.getUserHomeDir().getPath());
        chooser.setCurrentDirectory(new File(lastDir));
        Iterator iterator = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        List sortedFileFilters = SnapFileFilter.getSortedFileFilters((Iterator)iterator);
        sortedFileFilters.forEach(((JFileChooser)chooser)::addChoosableFileFilter);
        chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        return chooser;
    }

    public void initParameters() {
        String[] selectedLandCoverNames = (String[])this.paramMap.get("landCoverNames");
        if (selectedLandCoverNames != null) {
            int[] sel = AddLandCoverOpUI.getListIndices(selectedLandCoverNames, LandCoverFactory.getNameList());
            this.landCoverNamesList.setSelectedIndices(sel);
            int[] nArray = this.landCoverNamesList.getSelectedIndices();
        }
        this.resamplingMethodCombo.setSelectedItem(this.paramMap.get("resamplingMethod"));
        File[] files = (File[])this.paramMap.get("externalFiles");
        if (files != null) {
            this.externalFileList.setListData((File[])files);
        } else {
            File file = (File)this.paramMap.get("externalFile");
            if (file != null) {
                this.externalFileList.setListData((File[])new File[]{file});
            }
        }
        if (this.externalFileList.getModel().getSize() > 0) {
            this.externalFileList.setSelectionInterval(0, this.externalFileList.getModel().getSize() - 1);
        }
    }

    private static int[] getListIndices(String[] selectedList, String[] fullList) {
        int[] selectionIndices = new int[selectedList.length];
        int j = 0;
        block0: for (String n : selectedList) {
            for (int i = 0; i < fullList.length; ++i) {
                if (!fullList[i].equals(n)) continue;
                selectionIndices[j++] = i;
                continue block0;
            }
        }
        return selectionIndices;
    }

    private static String[] getListStrings(int[] selectedList, String[] fullList) {
        ArrayList<String> stringList = new ArrayList<String>(selectedList.length);
        for (int i : selectedList) {
            stringList.add(fullList[i]);
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (!this.hasSourceProducts()) {
            return;
        }
        String[] names = AddLandCoverOpUI.getListStrings(this.landCoverNamesList.getSelectedIndices(), LandCoverFactory.getNameList());
        if (names.length > 0) {
            this.paramMap.put("landCoverNames", names);
        } else {
            this.paramMap.put("landCoverNames", new String[0]);
        }
        this.paramMap.put("resamplingMethod", this.resamplingMethodCombo.getSelectedItem());
        if (!this.externalFileList.getSelectedValuesList().isEmpty()) {
            File[] files = this.externalFileList.getSelectedValuesList().toArray(new File[this.externalFileList.getSelectedValuesList().size()]);
            this.paramMap.put("externalFiles", files);
        }
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Land Cover Model:", this.landCoverNamesList);
        ++gbc.gridy;
        this.externalFileList.setFixedCellWidth(500);
        DialogUtils.addInnerPanel((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)new JLabel("External Files"), this.externalFileList, (JComponent)this.externalFileBrowseButton);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Method:", this.resamplingMethodCombo);
        ++gbc.gridy;
        gbc.gridx = 1;
        contentPane.add((Component)new JLabel("Integer data types will use nearest neighbour"), gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

