/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;

public class LandCoverModule {
    public static void installColorPalettes(Class callingClass, String path) {
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath((Class)callingClass);
        Path auxdataDir = LandCoverModule.getColorPalettesDir();
        Path sourcePath = moduleBasePath.resolve(path);
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourcePath, auxdataDir);
        try {
            resourceInstaller.install(".*.cpd", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to install colour palettes " + moduleBasePath + " to " + auxdataDir + " " + e.getMessage());
        }
    }

    private static Path getColorPalettesDir() {
        return SystemUtils.getAuxDataPath().resolve("color_palettes");
    }

    public static class StartOp
    implements Runnable {
        @Override
        public void run() {
            LandCoverModule.installColorPalettes(this.getClass(), "org/esa/snap/landcover/auxdata/color_palettes/");
        }
    }
}

