/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

public class XmlLinkConsumer {
    public String readLink(XMLStreamReader reader, EdmEntitySet entitySet) throws EntityProviderException {
        try {
            reader.next();
            return this.readLink(reader);
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private String readLink(XMLStreamReader reader) throws XMLStreamException {
        return this.readTag(reader, "http://schemas.microsoft.com/ado/2007/08/dataservices", "uri");
    }

    private String readTag(XMLStreamReader reader, String namespaceURI, String localName) throws XMLStreamException {
        reader.require(1, namespaceURI, localName);
        String result = reader.getElementText();
        reader.require(2, namespaceURI, localName);
        return result;
    }

    public List<String> readLinks(XMLStreamReader reader, EdmEntitySet entitySet) throws EntityProviderException {
        try {
            ArrayList<String> links = new ArrayList<String>();
            reader.nextTag();
            reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices", "links");
            reader.nextTag();
            while (!reader.isEndElement()) {
                if (reader.getLocalName().equals("count")) {
                    this.readTag(reader, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "count");
                } else {
                    String link = this.readLink(reader);
                    links.add(link);
                }
                reader.nextTag();
            }
            reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices", "links");
            return links;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }
}

