/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.DeletedEntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.consumer.XmlEntryConsumer;
import org.apache.olingo.odata2.core.ep.entry.DeletedEntryMetadataImpl;
import org.apache.olingo.odata2.core.ep.feed.FeedMetadataImpl;
import org.apache.olingo.odata2.core.ep.feed.ODataDeltaFeedImpl;

public class XmlFeedConsumer {
    public ODataDeltaFeed readFeed(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties) throws EntityProviderException {
        try {
            reader.require(7, null, null);
            reader.nextTag();
            reader.require(1, "http://www.w3.org/2005/Atom", "feed");
            Map<String, String> foundPrefix2NamespaceUri = this.extractNamespacesFromTag(reader);
            foundPrefix2NamespaceUri.putAll(readProperties.getValidatedPrefixNamespaceUris());
            this.checkAllMandatoryNamespacesAvailable(foundPrefix2NamespaceUri);
            EntityProviderReadProperties entryReadProperties = EntityProviderReadProperties.initFrom((EntityProviderReadProperties)readProperties).addValidatedPrefixes(foundPrefix2NamespaceUri).build();
            return this.readFeedData(reader, eia, entryReadProperties);
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private ODataDeltaFeed readFeedData(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties entryReadProperties) throws XMLStreamException, EntityProviderException {
        FeedMetadataImpl metadata = new FeedMetadataImpl();
        XmlEntryConsumer xec = new XmlEntryConsumer();
        ArrayList<ODataEntry> results = new ArrayList<ODataEntry>();
        ArrayList<DeletedEntryMetadata> deletedEntries = new ArrayList<DeletedEntryMetadata>();
        while (reader.hasNext() && !this.isFeedEndTag(reader)) {
            if ("entry".equals(reader.getLocalName())) {
                ODataEntry entry = xec.readEntry(reader, eia, entryReadProperties, true);
                results.add(entry);
            } else if ("deleted-entry".equals(reader.getLocalName())) {
                reader.require(1, "http://purl.org/atompub/tombstones/1.0", "deleted-entry");
                DeletedEntryMetadataImpl deletedEntryMetadata = this.readDeletedEntryMetadata(reader);
                deletedEntries.add(deletedEntryMetadata);
                reader.next();
            } else if ("count".equals(reader.getLocalName())) {
                reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "count");
                this.readInlineCount(reader, metadata);
            } else if ("link".equals(reader.getLocalName())) {
                String uri;
                reader.require(1, "http://www.w3.org/2005/Atom", "link");
                String rel = reader.getAttributeValue(null, "rel");
                if ("next".equals(rel)) {
                    uri = reader.getAttributeValue(null, "href");
                    metadata.setNextLink(uri);
                } else if ("delta".equals(rel)) {
                    uri = reader.getAttributeValue(null, "href");
                    metadata.setDeltaLink(uri);
                }
                reader.next();
            } else {
                reader.next();
            }
            this.readTillNextStartTag(reader);
        }
        return new ODataDeltaFeedImpl(results, metadata, deletedEntries);
    }

    private DeletedEntryMetadataImpl readDeletedEntryMetadata(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        try {
            DeletedEntryMetadataImpl deletedEntryMetadata = new DeletedEntryMetadataImpl();
            String uri = reader.getAttributeValue(null, "ref");
            String whenStr = reader.getAttributeValue(null, "when");
            Date when = EdmDateTimeOffset.getInstance().valueOfString(whenStr, EdmLiteralKind.DEFAULT, null, Date.class);
            deletedEntryMetadata.setUri(uri);
            deletedEntryMetadata.setWhen(when);
            return deletedEntryMetadata;
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderException(EntityProviderException.INVALID_DELETED_ENTRY_METADATA);
        }
    }

    private void readInlineCount(XMLStreamReader reader, FeedMetadataImpl metadata) throws XMLStreamException, EntityProviderException {
        String inlineCountString = reader.getElementText();
        if (inlineCountString != null) {
            try {
                int inlineCountNumber = Integer.valueOf(inlineCountString);
                if (inlineCountNumber < 0) {
                    throw new EntityProviderException(EntityProviderException.INLINECOUNT_INVALID.addContent(new Object[]{inlineCountNumber}));
                }
                metadata.setInlineCount(inlineCountNumber);
            }
            catch (NumberFormatException e) {
                throw new EntityProviderException(EntityProviderException.INLINECOUNT_INVALID.addContent(new Object[]{""}), (Throwable)e);
            }
        }
    }

    private void readTillNextStartTag(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && !reader.isStartElement()) {
            reader.next();
        }
    }

    private boolean isFeedEndTag(XMLStreamReader reader) {
        return reader.isEndElement() && "http://www.w3.org/2005/Atom".equals(reader.getNamespaceURI()) && "feed".equals(reader.getLocalName());
    }

    private Map<String, String> extractNamespacesFromTag(XMLStreamReader reader) {
        HashMap<String, String> foundPrefix2NamespaceUri = new HashMap<String, String>();
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            String namespaceUri = reader.getNamespaceURI(i);
            foundPrefix2NamespaceUri.put(namespacePrefix, namespaceUri);
        }
        return foundPrefix2NamespaceUri;
    }

    private void checkAllMandatoryNamespacesAvailable(Map<String, String> foundPrefix2NamespaceUri) throws EntityProviderException {
        if (!foundPrefix2NamespaceUri.containsValue("http://schemas.microsoft.com/ado/2007/08/dataservices")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{"http://schemas.microsoft.com/ado/2007/08/dataservices"}));
        }
        if (!foundPrefix2NamespaceUri.containsValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata"}));
        }
        if (!foundPrefix2NamespaceUri.containsValue("http://www.w3.org/2005/Atom")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{"http://www.w3.org/2005/Atom"}));
        }
    }
}

