/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.nbmgen;

import com.bc.ceres.nbmgen.CeresModuleProject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class NbCodeGenTool
implements CeresModuleProject.Processor {
    final File projectDir;
    final boolean dryRun;
    final File outputDir;
    VelocityEngine velocityEngine;
    HashMap<String, Converter> converters;

    public NbCodeGenTool(File projectDir, boolean dryRun, File outputDir) {
        this.projectDir = projectDir;
        this.dryRun = dryRun;
        this.outputDir = outputDir;
        this.velocityEngine = NbCodeGenTool.createVelocityEngine();
        this.converters = new HashMap();
        this.initConverters();
    }

    private void initConverters() {
        Converter NULL = (project, point, extensionElement) -> this.warnNotImplemented(point);
        this.converters.put("snap-ui:actions", new ActionConverter());
        this.converters.put("snap-ceres-core:applications", NULL);
        this.converters.put("snap-ceres-core:serviceProviders", NULL);
        this.converters.put("snap-ceres-core:adapters", NULL);
        this.converters.put("snap-core:rgbProfiles", NULL);
        this.converters.put("snap-ui:applicationDescriptors", NULL);
        this.converters.put("snap-ui:helpSets", NULL);
        this.converters.put("snap-ui:actionGroups", NULL);
        this.converters.put("snap-ui:toolViews", NULL);
        this.converters.put("snap-ui:layerSources", NULL);
        this.converters.put("snap-ui:layerEditors", NULL);
        this.converters.put("snap-graph-builder:OperatorUIs", NULL);
    }

    private String getActionBaseName(String name) {
        int i = name.lastIndexOf(46);
        String simpleName = i > 0 ? name.substring(i + 1) : name;
        if (simpleName.endsWith("Action")) {
            return simpleName.substring(0, simpleName.length() - "Action".length());
        }
        if (simpleName.endsWith("ActionGroup")) {
            return simpleName.substring(0, simpleName.length() - "ActionGroup".length());
        }
        return simpleName;
    }

    public static void main(String[] args) throws JDOMException, IOException {
        File projectDir = new File(args[0]);
        boolean dryRun = args[1].equals("true");
        File outputDir = args.length > 2 ? new File(args[2]) : projectDir;
        NbCodeGenTool processor = new NbCodeGenTool(projectDir, dryRun, outputDir);
        CeresModuleProject.processParentDir(projectDir, processor);
        if (dryRun) {
            NbCodeGenTool.warnModuleDetail("dry run: file system not modified");
        }
    }

    @Override
    public void process(CeresModuleProject project) throws JDOMException, IOException {
        System.out.println("Project [" + project.projectDir.getName() + "]:");
        Element moduleElement = project.moduleDocument.getRootElement();
        List extensionPointElements = moduleElement.getChildren("extensionPoint");
        for (Element extensionPointElement : extensionPointElements) {
            String id = extensionPointElement.getAttributeValue("id");
            NbCodeGenTool.infoModuleDetail("Found extensionPoint.id = " + id);
        }
        List extensionElements = moduleElement.getChildren("extension");
        for (Element extensionElement : extensionElements) {
            String point = extensionElement.getAttributeValue("point");
            NbCodeGenTool.infoModuleDetail("Found extension.point = " + point);
            List extensionConfigs = extensionElement.getChildren();
            for (Element extensionConfig : extensionConfigs) {
                Converter converter = this.converters.get(point);
                if (converter != null) {
                    converter.convert(project, point, extensionConfig);
                    continue;
                }
                NbCodeGenTool.warnModuleDetail("No converter for extension point: " + point);
            }
        }
    }

    private void evaluate(VelocityContext velocityContext, String resourceName, Writer writer) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(resourceName));){
            this.evaluate(velocityContext, reader, writer);
        }
    }

    private void evaluate(VelocityContext velocityContext, Reader reader, Writer writer) {
        this.velocityEngine.evaluate((Context)velocityContext, writer, this.getClass().getSimpleName(), reader);
    }

    private void warnNotImplemented(String point) {
        NbCodeGenTool.warnModuleDetail("converter not implemented for extension point: " + point);
    }

    private static void infoModuleDetail(String msg) {
        System.out.println("- " + msg);
    }

    private static void warnModuleDetail(String msg) {
        System.out.println("- WARNING: " + msg);
    }

    private static VelocityEngine createVelocityEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            velocityEngine.init();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize velocity engine", e);
        }
        return velocityEngine;
    }

    private class ActionConverter
    implements Converter {
        Map<String, Integer> classNameBases = new HashMap<String, Integer>();

        private ActionConverter() {
        }

        @Override
        public void convert(CeresModuleProject project, String point, Element extensionElement) throws IOException {
            HashMap<String, String> parentToPath = new HashMap<String, String>();
            parentToPath.put("file", "Menu/File");
            parentToPath.put("importVectorData", "Menu/File/Import Vector Data");
            parentToPath.put("importRasterData", "Menu/File/Import Raster Data");
            parentToPath.put("importSAR", "Menu/File/Import Raster Data/SAR Data");
            parentToPath.put("importMultispectral", "Menu/File/Import Raster Data/Multispectral Data");
            parentToPath.put("importFileFormats", "Menu/File/Import Raster Data/Generic Formats");
            parentToPath.put("exportOther", "Menu/File/Other Exports");
            parentToPath.put("edit", "Menu/Edit");
            parentToPath.put("view", "Menu/View");
            parentToPath.put("tools", "Toolbars/Tools");
            parentToPath.put("layoutToolViews", "Menu/View/Tool Window Layout");
            parentToPath.put("toolBars", "Menu/Tools/Toolbars");
            parentToPath.put("Graphs", "Menu/Graphs");
            parentToPath.put("help", "Menu/Help");
            parentToPath.put("processing", "Menu/Processing");
            parentToPath.put("processing.preProcessing", "Menu/Processing/Pre-Processing");
            parentToPath.put("processing.thematicLand", "Menu/Processing/Thematic Land Processing");
            parentToPath.put("processing.thematicWater", "Menu/Processing/Thematic Water Processing");
            parentToPath.put("processing.imageAnalysis", "Menu/Processing/Image Analysis");
            parentToPath.put("processing.geomOperations", "Menu/Processing/Geometric Operations");
            String id = extensionElement.getChildTextTrim("id");
            String parent = extensionElement.getChildTextTrim("parent");
            String placeAfter = extensionElement.getChildTextTrim("placeAfter");
            String placeBefore = extensionElement.getChildTextTrim("placeBefore");
            String separatorAfter = extensionElement.getChildTextTrim("separatorAfter");
            String separatorBefore = extensionElement.getChildTextTrim("separatorBefore");
            String actionClassName = extensionElement.getChildTextTrim("class");
            String interactor = extensionElement.getChildTextTrim("interactor");
            String interactorListener = extensionElement.getChildTextTrim("interactorListener");
            String text = extensionElement.getChildTextTrim("text");
            String shortDescr = extensionElement.getChildTextTrim("shortDescr");
            String longDescr = extensionElement.getChildTextTrim("longDescr");
            String helpId = extensionElement.getChildTextTrim("helpId");
            String accelerator = extensionElement.getChildTextTrim("accelerator");
            String mnemonic = extensionElement.getChildTextTrim("mnemonic");
            String context = extensionElement.getChildTextTrim("context");
            String popuptext = extensionElement.getChildTextTrim("popuptext");
            String toggle = extensionElement.getChildTextTrim("toggle");
            String selected = extensionElement.getChildTextTrim("selected");
            String smallIcon = extensionElement.getChildTextTrim("smallIcon");
            String largeIcon = extensionElement.getChildTextTrim("largeIcon");
            String useAllFileFilter = extensionElement.getChildTextTrim("useAllFileFilter");
            String formatName = extensionElement.getChildTextTrim("formatName");
            String sortChildren = extensionElement.getChildTextTrim("sortChildren");
            String operatorName = extensionElement.getChildTextTrim("operatorName");
            String dialogTitle = extensionElement.getChildTextTrim("dialogTitle");
            String targetProductNameSuffix = extensionElement.getChildTextTrim("targetProductNameSuffix");
            if ("org.esa.snap.visat.actions.ActionGroup".equals(actionClassName)) {
                NbCodeGenTool.warnModuleDetail("ActionGroup not converted: id = " + id);
                return;
            }
            String classNameBase = NbCodeGenTool.this.getActionBaseName(actionClassName);
            String path = parent != null ? (String)parentToPath.get(parent) : "Menu/Extras";
            String packageName = "org.esa.snap.rcp.action";
            String category = "SNAP";
            String baseClassName = "AbstractAction";
            int position = 100;
            switch (actionClassName) {
                case "org.esa.snap.visat.actions.ProductImportAction": {
                    packageName = packageName + ".file.pimp";
                    classNameBase = "Import_" + formatName.replace('-', '_').replace(' ', '_').replace('.', '_').replace('/', '_') + "_";
                    baseClassName = packageName + ".ProductImportAction";
                    break;
                }
                case "org.esa.snap.visat.actions.ProductExportAction": {
                    packageName = packageName + ".file.pexp";
                    classNameBase = "Export_" + formatName.replace('-', '_').replace(' ', '_').replace('.', '_').replace('/', '_') + "_";
                    baseClassName = packageName + ".ProductExportAction";
                    break;
                }
                case "org.esa.snap.visat.actions.DefaultOperatorAction": {
                    packageName = packageName + ".op";
                    classNameBase = "Invoke_" + operatorName + "_";
                    baseClassName = packageName + ".DefaultOperatorAction";
                    break;
                }
                case "org.esa.snap.visat.actions.ShowToolBarAction": {
                    packageName = packageName + ".view";
                    classNameBase = Character.toUpperCase(id.charAt(0)) + id.substring(1);
                    baseClassName = packageName + ".ShowToolBarAction";
                    break;
                }
                case "org.esa.snap.visat.actions.ToolAction": {
                    packageName = packageName + ".tool";
                    classNameBase = Character.toUpperCase(id.charAt(0)) + id.substring(1);
                    baseClassName = packageName + ".ToolAction";
                    break;
                }
                case "org.esa.snap.visat.actions.PlacemarkToolAction": {
                    packageName = packageName + ".tool";
                    classNameBase = Character.toUpperCase(id.charAt(0)) + id.substring(1);
                    baseClassName = packageName + ".PlacemarkToolAction";
                }
            }
            Integer count = this.classNameBases.get(classNameBase);
            if (count != null) {
                count = count + 1;
                this.classNameBases.put(classNameBase, count);
                String classNameBaseOld = classNameBase;
                if (count > 1) {
                    classNameBase = classNameBase.endsWith("_") ? classNameBase + count + "_" : classNameBase + count;
                }
                String msg = String.format("Class base name already seen: %s, renamed to %s", classNameBaseOld, classNameBase);
                NbCodeGenTool.warnModuleDetail(msg);
            } else {
                this.classNameBases.put(classNameBase, 1);
            }
            NbCodeGenTool.infoModuleDetail("Action template parameters:");
            NbCodeGenTool.infoModuleDetail("  package = " + packageName);
            NbCodeGenTool.infoModuleDetail("  classNameBase = " + classNameBase);
            NbCodeGenTool.infoModuleDetail("  path = " + path);
            NbCodeGenTool.infoModuleDetail("  text = " + text);
            NbCodeGenTool.infoModuleDetail("  position = " + position);
            NbCodeGenTool.infoModuleDetail("  category = " + category);
            if (path == null) {
                throw new IllegalStateException("path == null");
            }
            VelocityContext velocityContext = new VelocityContext();
            this.addProperty(velocityContext, "package", (Object)packageName);
            this.addProperty(velocityContext, "path", (Object)path);
            this.addProperty(velocityContext, "position", position);
            this.addProperty(velocityContext, "displayName", (Object)text);
            this.addProperty(velocityContext, "icon", (Object)(smallIcon != null ? smallIcon : largeIcon));
            this.addProperty(velocityContext, "smallIcon", (Object)smallIcon);
            this.addProperty(velocityContext, "largeIcon", (Object)largeIcon);
            this.addProperty(velocityContext, "popupText", (Object)(popuptext != null ? popuptext : text));
            this.addProperty(velocityContext, "category", (Object)category);
            this.addProperty(velocityContext, "classNameBase", (Object)classNameBase);
            this.addProperty(velocityContext, "baseClassName", (Object)baseClassName);
            this.addProperty(velocityContext, "separatorBefore", "true".equals(separatorBefore) ? Integer.valueOf(position - 10) : null);
            this.addProperty(velocityContext, "separatorAfter", "true".equals(separatorAfter) ? Integer.valueOf(position + 10) : null);
            this.addProperty(velocityContext, "shortDescription", (Object)shortDescr);
            this.addProperty(velocityContext, "longDescription", (Object)longDescr);
            this.addProperty(velocityContext, "selected", (Object)selected);
            this.addProperty(velocityContext, "mnemonic", (Object)mnemonic);
            this.addProperty(velocityContext, "accelerator", (Object)accelerator);
            LinkedHashMap<String, String> unusedProperties = new LinkedHashMap<String, String>();
            this.addProperty(unusedProperties, "placeBefore", placeBefore);
            this.addProperty(unusedProperties, "placeAfter", placeAfter);
            this.addProperty(unusedProperties, "interactor", interactor);
            this.addProperty(unusedProperties, "interactorListener", interactorListener);
            this.addProperty(unusedProperties, "helpId", helpId);
            this.addProperty(unusedProperties, "context", context);
            this.addProperty(unusedProperties, "toggle", toggle);
            this.addProperty(unusedProperties, "useAllFileFilter", useAllFileFilter);
            this.addProperty(unusedProperties, "sortChildren", sortChildren);
            this.addProperty(unusedProperties, "dialogTitle", dialogTitle);
            this.addProperty(unusedProperties, "targetProductNameSuffix", targetProductNameSuffix);
            this.addProperty(velocityContext, "properties", unusedProperties);
            File javaFile = CeresModuleProject.getFile(NbCodeGenTool.this.outputDir, project.projectDir.getName(), "src", "main", "java", packageName.replace('.', File.separatorChar), classNameBase + "Action.java");
            if (!NbCodeGenTool.this.dryRun) {
                javaFile.getParentFile().mkdirs();
                try (FileWriter writer = new FileWriter(javaFile);){
                    NbCodeGenTool.this.evaluate(velocityContext, "Action.vm", writer);
                }
            }
            NbCodeGenTool.infoModuleDetail("Written Java source: " + javaFile);
        }

        private void addProperty(VelocityContext properties, String key, Object value) {
            if (value != null) {
                properties.put(key, value);
            }
        }

        private void addProperty(Map<String, String> properties, String key, String value) {
            if (value != null) {
                properties.put(key, value);
            }
        }
    }

    static interface Converter {
        public void convert(CeresModuleProject var1, String var2, Element var3) throws IOException;
    }
}

