/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.NullProgressMonitor;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.RuntimeConfig;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class SplashScreenProgressMonitor
extends NullProgressMonitor {
    private static final String CONFIG_KEY_SPLASH_IMAGE = "splash.image";
    private static final String CONFIG_KEY_SPLASH_PROGRESS_BAR_COLOR = "splash.progressBar.color";
    private static final String CONFIG_KEY_SPLASH_PROGRESS_BAR_AREA = "splash.progressBar.area";
    private static final String CONFIG_KEY_TASK_LABEL_ENABLED = "splash.taskLabel.enabled";
    private static final String CONFIG_KEY_TASK_LABEL_FONT = "splash.taskLabel.font";
    private static final String CONFIG_KEY_TASK_LABEL_COLOR = "splash.taskLabel.color";
    private static final String CONFIG_KEY_TASK_LABEL_POS = "splash.taskLabel.pos";
    private static final String CONFIG_KEY_SPLASH_VERSION_TEXT = "splash.version.text";
    private static final String CONFIG_KEY_VERSION_ENABLED = "splash.version.enabled";
    private static final String CONFIG_KEY_VERSION_FONT = "splash.version.font";
    private static final String CONFIG_KEY_VERSION_COLOR = "splash.version.color";
    private static final String CONFIG_KEY_VERSION_POS = "splash.version.pos";
    private Splash splashScreen;
    private String taskName;
    private String subTaskName;
    private double totalWork;
    private double currentWork;
    private int lastPixelsWorked;
    private Graphics2D graphics;
    private Rectangle splashArea;
    private int progressBarHeight;
    private boolean taskLabelEnabled;
    private Font taskLabelFont;
    private Color taskLabelColor;
    private Point taskLabelPos;
    private boolean versionLabelEnabled;
    private Font versionLabelFont;
    private Color versionLabelColor;
    private Point versionLabelPos;
    private Color progressBarColor;
    private Rectangle progressBarArea;
    private int pixelsWorked;
    private String message;
    private String versionText;

    public static ProgressMonitor createProgressMonitor(RuntimeConfig config) {
        String imageFilePath = config.getContextProperty(CONFIG_KEY_SPLASH_IMAGE);
        if (imageFilePath != null) {
            BufferedImage bufferedImage = SplashScreenProgressMonitor.loadImage(imageFilePath);
            if (bufferedImage != null) {
                return new SplashScreenProgressMonitor(new CeresSplash(bufferedImage), config);
            }
        } else {
            SplashScreen splashScreen = null;
            try {
                splashScreen = SplashScreen.getSplashScreen();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (splashScreen != null) {
                return new SplashScreenProgressMonitor(new AwtSplash(splashScreen), config);
            }
        }
        return ProgressMonitor.NULL;
    }

    public SplashScreenProgressMonitor(Splash splashScreen, RuntimeConfig config) {
        Assert.notNull(splashScreen, "splashScreen");
        this.splashScreen = splashScreen;
        Dimension size = this.splashScreen.getSize();
        this.splashArea = new Rectangle(size);
        this.progressBarColor = SplashScreenProgressMonitor.getConfiguredColor(config, CONFIG_KEY_SPLASH_PROGRESS_BAR_COLOR, Color.GREEN);
        this.progressBarArea = SplashScreenProgressMonitor.getConfiguredSplashProgressBarArea(config);
        if (this.progressBarArea != null) {
            this.progressBarHeight = this.progressBarArea.height;
        } else {
            this.progressBarHeight = 5;
            this.progressBarArea = new Rectangle(0, this.splashArea.height - this.progressBarHeight - 4, this.splashArea.width, this.progressBarHeight);
        }
        this.taskLabelColor = SplashScreenProgressMonitor.getConfiguredColor(config, CONFIG_KEY_TASK_LABEL_COLOR, Color.WHITE);
        this.taskLabelEnabled = this.getConfiguredOptionEnabled(config, CONFIG_KEY_TASK_LABEL_ENABLED);
        if (this.taskLabelEnabled) {
            this.taskLabelFont = SplashScreenProgressMonitor.getConfiguredFont(config, CONFIG_KEY_TASK_LABEL_FONT);
            this.taskLabelPos = SplashScreenProgressMonitor.getConfiguredPos(config, CONFIG_KEY_TASK_LABEL_POS);
            if (this.taskLabelPos == null) {
                this.taskLabelPos = new Point(this.progressBarArea.x, this.progressBarArea.y + this.progressBarArea.height + 10);
            }
        }
        this.versionLabelEnabled = this.getConfiguredOptionEnabled(config, CONFIG_KEY_VERSION_ENABLED);
        if (this.versionLabelEnabled) {
            this.versionText = config.getContextProperty(CONFIG_KEY_SPLASH_VERSION_TEXT);
            if (this.versionText == null) {
                this.versionText = config.getContextProperty("version");
            }
            this.versionLabelFont = SplashScreenProgressMonitor.getConfiguredFont(config, CONFIG_KEY_VERSION_FONT);
            this.versionLabelColor = SplashScreenProgressMonitor.getConfiguredColor(config, CONFIG_KEY_VERSION_COLOR, this.taskLabelColor);
            this.versionLabelPos = SplashScreenProgressMonitor.getConfiguredPos(config, CONFIG_KEY_VERSION_POS);
            if (this.versionLabelPos == null) {
                this.versionLabelPos = new Point(this.progressBarArea.x, this.progressBarArea.y + this.progressBarArea.height + 30);
            }
        }
        this.graphics = this.splashScreen.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.message = "";
    }

    public Splash getSplash() {
        return this.splashScreen;
    }

    @Override
    public void beginTask(String taskName, int totalWork) {
        this.totalWork = totalWork;
        this.currentWork = 0.0;
        this.lastPixelsWorked = 0;
        this.setTaskName(taskName);
    }

    @Override
    public void done() {
        this.internalWorked(this.totalWork);
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        if (this.splashScreen.isVisible()) {
            this.splashScreen.close();
        }
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }

    @Override
    public void internalWorked(double work) {
        this.currentWork += work;
        double progress = this.currentWork / this.totalWork;
        this.pixelsWorked = (int)((double)this.progressBarArea.width * progress);
        if (this.pixelsWorked > this.lastPixelsWorked) {
            this.lastPixelsWorked = this.pixelsWorked;
            this.update();
        }
    }

    @Override
    public void setTaskName(String taskName) {
        this.taskName = taskName;
        this.message = this.createMessage();
        this.update();
    }

    @Override
    public void setSubTaskName(String subTaskName) {
        this.subTaskName = subTaskName;
        this.message = this.createMessage();
        this.update();
    }

    private String createMessage() {
        boolean validSubTaskName;
        boolean validTaskName = this.taskName != null && this.taskName.length() > 0;
        boolean bl = validSubTaskName = this.subTaskName != null && this.subTaskName.length() > 0;
        String message = validTaskName && validSubTaskName ? this.taskName + " - " + this.subTaskName : (validTaskName ? this.taskName : (validSubTaskName ? this.subTaskName : ""));
        return message;
    }

    private void update() {
        if (this.graphics == null || !this.splashScreen.isVisible()) {
            return;
        }
        this.graphics.setComposite(AlphaComposite.Clear);
        this.graphics.fill(this.splashArea);
        this.graphics.setPaintMode();
        if (this.taskLabelEnabled) {
            this.paintTaskLabel();
        }
        if (this.versionLabelEnabled) {
            this.paintVersionLabel();
        }
        this.paintBar();
        this.splashScreen.update();
    }

    private void paintBar() {
        this.graphics.setColor(this.progressBarColor);
        this.graphics.fillRect(this.progressBarArea.x, this.progressBarArea.y, this.pixelsWorked, this.progressBarArea.height);
    }

    private void paintTaskLabel() {
        this.graphics.setColor(this.taskLabelColor);
        this.graphics.setFont(this.taskLabelFont);
        this.graphics.drawString(this.message, this.taskLabelPos.x, this.taskLabelPos.y);
    }

    private void paintVersionLabel() {
        this.graphics.setColor(this.versionLabelColor);
        this.graphics.setFont(this.versionLabelFont);
        this.graphics.drawString(this.versionText, this.versionLabelPos.x, this.versionLabelPos.y);
    }

    private static BufferedImage loadImage(String imageFilePath) {
        try {
            return ImageIO.read(new File(imageFilePath));
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean getConfiguredOptionEnabled(RuntimeConfig config, String key) {
        return Boolean.parseBoolean(config.getContextProperty(key, "false"));
    }

    private static Color getConfiguredColor(RuntimeConfig config, String key, Color defaultValue) {
        String colorStr = config.getContextProperty(key);
        if (colorStr != null && !colorStr.isEmpty()) {
            if (colorStr.startsWith("#")) {
                return Color.decode(colorStr);
            }
            StringTokenizer st = new StringTokenizer(colorStr, ",");
            int n = st.countTokens();
            if (n == 3 || n == 4) {
                try {
                    int r = Integer.parseInt(st.nextToken());
                    int g = Integer.parseInt(st.nextToken());
                    int b = Integer.parseInt(st.nextToken());
                    int a = 255;
                    if (st.hasMoreTokens()) {
                        a = Integer.parseInt(st.nextToken());
                    }
                    return new Color(r, g, b, a);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    private static Rectangle getConfiguredSplashProgressBarArea(RuntimeConfig config) {
        StringTokenizer st;
        int n;
        String areaStr = config.getContextProperty(CONFIG_KEY_SPLASH_PROGRESS_BAR_AREA);
        if (areaStr != null && !areaStr.isEmpty() && (n = (st = new StringTokenizer(areaStr, ",")).countTokens()) == 4) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                int w = Integer.parseInt(st.nextToken());
                int h = Integer.parseInt(st.nextToken());
                return new Rectangle(x, y, w, h);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Point getConfiguredPos(RuntimeConfig config, String key) {
        StringTokenizer st;
        int n;
        String posStr = config.getContextProperty(key);
        if (posStr != null && !posStr.isEmpty() && (n = (st = new StringTokenizer(posStr, ",")).countTokens()) == 2) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                return new Point(x, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Font getConfiguredFont(RuntimeConfig config, String key) {
        String fontDesc = config.getContextProperty(key);
        if (fontDesc == null || fontDesc.isEmpty()) {
            return new Font("Verdana", 2, 10);
        }
        return Font.decode(fontDesc.replace(",", "-"));
    }

    private static class CeresSplash
    extends Window
    implements Splash {
        private BufferedImage bufferImage;
        private BufferedImage backgroundImage;
        private BufferedImage updateImage;
        private Graphics2D bufferGraphics;

        public CeresSplash(BufferedImage image) {
            super((Frame)null);
            this.backgroundImage = image;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle bounds = new Rectangle((screenSize.width - image.getWidth()) / 2, (screenSize.height - image.getHeight()) / 2, image.getWidth(), image.getHeight());
            this.bufferImage = new BufferedImage(bounds.width, bounds.height, 2);
            this.bufferGraphics = this.bufferImage.createGraphics();
            this.setBounds(bounds);
            this.setFocusable(false);
            this.setAlwaysOnTop(false);
            this.setVisible(true);
        }

        @Override
        public void close() {
            if (this.bufferGraphics != null) {
                this.dispose();
                this.bufferGraphics.dispose();
                this.bufferGraphics = null;
                this.bufferImage = null;
                this.backgroundImage = null;
                this.updateImage = null;
            }
        }

        @Override
        public void update() {
            this.repaint();
        }

        @Override
        public Graphics2D createGraphics() throws IllegalStateException {
            if (this.updateImage == null) {
                Dimension dim = this.getSize();
                this.updateImage = new BufferedImage(dim.width, dim.height, 2);
            }
            return this.updateImage.createGraphics();
        }

        @Override
        public void update(Graphics g) {
            this.bufferGraphics.drawImage(this.backgroundImage, null, 0, 0);
            if (this.updateImage != null) {
                this.bufferGraphics.drawImage(this.updateImage, null, 0, 0);
            }
            g.drawImage(this.bufferImage, 0, 0, null);
        }
    }

    private static class AwtSplash
    implements Splash {
        private final SplashScreen splashScreen;

        public AwtSplash(SplashScreen splashScreen) {
            this.splashScreen = splashScreen;
        }

        @Override
        public void close() {
            this.splashScreen.close();
        }

        @Override
        public boolean isVisible() {
            return this.splashScreen.isVisible();
        }

        @Override
        public void update() {
            this.splashScreen.update();
        }

        @Override
        public Graphics2D createGraphics() {
            return this.splashScreen.createGraphics();
        }

        @Override
        public Dimension getSize() {
            return this.splashScreen.getSize();
        }

        @Override
        public Rectangle getBounds() {
            return this.splashScreen.getBounds();
        }
    }

    public static interface Splash {
        public boolean isVisible();

        public void close();

        public void update();

        public Graphics2D createGraphics();

        public Dimension getSize();

        public Rectangle getBounds();
    }
}

