/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.core.runtime.internal.ModuleClassLoader;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ResolveException;
import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ModuleResolver {
    private ClassLoader moduleParentClassLoader;
    private boolean resolvingLibs;
    private Stack<String> moduleStack;

    public ModuleResolver(ClassLoader moduleParentClassLoader, boolean resolvingLibs) {
        Assert.notNull(moduleParentClassLoader, "moduleParentClassLoader");
        this.moduleParentClassLoader = moduleParentClassLoader;
        this.resolvingLibs = resolvingLibs;
        this.moduleStack = new Stack();
    }

    public void resolve(ModuleImpl module) throws ResolveException {
        Assert.notNull(module, "module");
        ModuleState previousState = module.getState();
        this.initModuleDependencies(module);
        if (module.getState() == ModuleState.RESOLVED) {
            this.initModuleClassLoader(module);
            ModuleResolver.initRefCount(module);
        }
        if (module.hasResolveErrors()) {
            module.setState(previousState);
            String msg = String.format("Failed to resolve module [%s].", module.getSymbolicName());
            throw new ResolveException(msg);
        }
    }

    private void initModuleDependencies(ModuleImpl module) {
        if (module.hasResolveErrors()) {
            return;
        }
        if (module.getState() == ModuleState.INSTALLED) {
            if (module.getModuleDependencies() == null) {
                ModuleImpl[] resolvedModules = this.resolveModuleDependencies(module);
                module.setModuleDependencies(resolvedModules);
            }
            if (module.getDeclaredLibs() == null) {
                String[] declaredLibs = ModuleResolver.findDeclaredLibs(module);
                module.setDeclaredLibs(declaredLibs);
            }
            if (module.getLibDependencies() == null) {
                URL[] libDependencies = this.findLibDependencies(module);
                module.setLibDependencies(libDependencies);
            }
            if (!module.hasResolveErrors()) {
                module.setState(ModuleState.RESOLVED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleImpl[] resolveModuleDependencies(ModuleImpl module) {
        String moduleKey = module.getSymbolicName() + ":" + module.getVersion();
        if (this.moduleStack.contains(moduleKey)) {
            String message = this.createCyclicDependecyExceptionMessage(module);
            module.addResolveError(new ResolveException(message));
            return new ModuleImpl[0];
        }
        try {
            this.moduleStack.push(moduleKey);
            ModuleImpl[] moduleImplArray = this.resolveModuleDependenciesImpl(module);
            return moduleImplArray;
        }
        finally {
            this.moduleStack.pop();
        }
    }

    private String createCyclicDependecyExceptionMessage(ModuleImpl module) {
        StringBuilder trace = new StringBuilder();
        for (String s : this.moduleStack) {
            trace.append('[').append(s).append(']');
        }
        return MessageFormat.format("Cyclic dependencies detected for module [{0}], trace: {1}", module.getSymbolicName(), trace);
    }

    private ModuleImpl[] resolveModuleDependenciesImpl(ModuleImpl module) {
        DependencyItem[] moduleDependencies = ModuleResolver.findModuleDependencies(module);
        ArrayList<ModuleImpl> resolvedModules = new ArrayList<ModuleImpl>(moduleDependencies.length);
        for (DependencyItem dependencyItem : moduleDependencies) {
            ResolveException[] resolveWarnings;
            ResolveException[] resolveErrors;
            this.initModuleDependencies(dependencyItem.module);
            if (dependencyItem.module.getState() == ModuleState.RESOLVED) {
                resolvedModules.add(dependencyItem.module);
            }
            if ((resolveErrors = dependencyItem.module.getResolveErrors()).length > 0) {
                for (ResolveException resolveError : resolveErrors) {
                    if (dependencyItem.optional) {
                        module.addResolveWarning(resolveError);
                        continue;
                    }
                    module.addResolveError(resolveError);
                }
            }
            if ((resolveWarnings = dependencyItem.module.getResolveWarnings()).length <= 0) continue;
            for (ResolveException resolveWarning : resolveWarnings) {
                module.addResolveWarning(resolveWarning);
            }
        }
        return resolvedModules.toArray(new ModuleImpl[resolvedModules.size()]);
    }

    private void initModuleClassLoader(ModuleImpl module) {
        if (module.getClassLoader() == null) {
            URL[] nativeLibs = ModuleResolver.getNativeLibs(module);
            URL[] dependencyLibs = module.getLibDependencies();
            if (dependencyLibs == null) {
                dependencyLibs = new URL[]{};
            }
            ClassLoader[] dependencyClassLoaders = this.getDependencyClassLoaders(module);
            module.setClassLoader(new ModuleClassLoader(dependencyClassLoaders, dependencyLibs, nativeLibs, this.moduleParentClassLoader));
        }
    }

    private ClassLoader[] getDependencyClassLoaders(ModuleImpl module) {
        ArrayList<ClassLoader> dependencyCl = new ArrayList<ClassLoader>();
        for (ModuleImpl moduleDependency : module.getModuleDependencies()) {
            if (moduleDependency.getState() != ModuleState.RESOLVED) continue;
            if (moduleDependency.getClassLoader() == null) {
                this.initModuleClassLoader(moduleDependency);
            }
            dependencyCl.add(moduleDependency.getClassLoader());
        }
        return dependencyCl.toArray(new ClassLoader[dependencyCl.size()]);
    }

    private static URL[] getNativeLibs(ModuleImpl module) {
        File moduleDir;
        ArrayList<URL> libPaths = new ArrayList<URL>();
        if (module.isNative() && (moduleDir = UrlHelper.urlToFile(module.getLocation())).isDirectory()) {
            String[] impliciteNativeLibs;
            for (String libPath : impliciteNativeLibs = module.getImpliciteNativeLibs()) {
                File libFile = new File(moduleDir, libPath);
                if (libFile.isFile() && libFile.canRead()) {
                    libPaths.add(UrlHelper.fileToUrl(libFile));
                    continue;
                }
                String msg = String.format("Native library [%s] found in module [%s] is not accessible.", libFile, module.getSymbolicName());
                module.addResolveWarning(new ResolveException(msg));
            }
        }
        return libPaths.toArray(new URL[libPaths.size()]);
    }

    private static void initRefCount(ModuleImpl module) {
        module.incrementRefCount();
        if (module.getModuleDependencies() != null) {
            ModuleImpl[] moduleDependencies;
            for (ModuleImpl moduleDependency : moduleDependencies = module.getModuleDependencies()) {
                ModuleResolver.initRefCount(moduleDependency);
            }
        }
    }

    private URL[] findLibDependencies(ModuleImpl module) {
        if (module.getLocation() == null) {
            throw new IllegalStateException("module.getLocation() == null");
        }
        if (module.getModuleDependencies() == null) {
            throw new IllegalStateException("module.getModuleDependencies() == null");
        }
        if (module.getDeclaredLibs() == null) {
            throw new IllegalStateException("module.getDeclaredLibs() == null");
        }
        if (module.getImpliciteLibs() == null) {
            throw new IllegalStateException("module.getImpliciteLibs() == null");
        }
        File moduleFile = UrlHelper.urlToFile(module.getLocation());
        if (moduleFile == null) {
            return new URL[0];
        }
        ArrayList<URL> libDependencies = new ArrayList<URL>(16);
        ModuleResolver.collectLibDependency(module, moduleFile, libDependencies);
        ModuleResolver.resolveLibs(module, moduleFile, this.resolvingLibs, libDependencies);
        for (String impliciteLib : module.getImpliciteLibs()) {
            ModuleResolver.collectLibDependency(module, new File(moduleFile, impliciteLib), libDependencies);
        }
        return libDependencies.toArray(new URL[0]);
    }

    private static void resolveLibs(ModuleImpl module, File moduleFile, boolean resolvingLibs, List<URL> libDependencies) {
        Dependency[] declaredDependencies;
        for (Dependency dependency : declaredDependencies = module.getDeclaredDependencies()) {
            if (dependency.getLibName() == null) continue;
            boolean libResolved = false;
            File file = ModuleResolver.resolveFile(moduleFile, dependency.getLibName(), resolvingLibs);
            if (file != null) {
                ModuleResolver.collectLibDependency(module, file, libDependencies);
                libResolved = true;
            } else {
                for (ModuleImpl moduleDependency : module.getModuleDependencies()) {
                    File file2;
                    File moduleDependencyFile = UrlHelper.urlToFile(moduleDependency.getLocation());
                    if (moduleDependencyFile == null || (file2 = ModuleResolver.resolveFile(moduleDependencyFile, dependency.getLibName(), resolvingLibs)) == null) continue;
                    ModuleResolver.collectLibDependency(module, file2, libDependencies);
                    libResolved = true;
                    break;
                }
            }
            if (libResolved || !resolvingLibs || dependency.isOptional()) continue;
            String msg = String.format("Mandatory library [%s] declared by module [%s] not found.", dependency.getLibName(), module.getSymbolicName());
            module.addResolveError(new ResolveException(msg));
        }
    }

    private static File resolveFile(File parent, String libPath, boolean checkExists) {
        if (parent.isDirectory()) {
            File file = new File(parent, libPath);
            if (!checkExists || file.exists()) {
                return file;
            }
        }
        return null;
    }

    private static DependencyItem[] findModuleDependencies(ModuleImpl module) {
        ArrayList<DependencyItem> list = new ArrayList<DependencyItem>(16);
        ModuleResolver.collectDeclaredModuleDependencies(module, list);
        ModuleResolver.collectImpliciteModuleDependencies(module, list);
        return list.toArray(new DependencyItem[0]);
    }

    private static void collectDeclaredModuleDependencies(ModuleImpl module, List<DependencyItem> list) {
        Dependency[] dependencies;
        for (Dependency dependency : dependencies = module.getDeclaredDependencies()) {
            if (dependency.getModuleSymbolicName() == null) continue;
            ModuleImpl[] dependencyModules = module.getRegistry().getModules(dependency.getModuleSymbolicName());
            if (dependencyModules.length > 0) {
                if (dependency.getVersion() != null) {
                    Version requiredVersion = Version.parseVersion(dependency.getVersion());
                    ModuleImpl dependencyModule = ModuleResolver.findBestMatchingModuleVersion(requiredVersion, dependencyModules);
                    if (dependencyModule != null && requiredVersion.compareTo(dependencyModule.getVersion()) <= 0) {
                        ModuleResolver.collectDependencyModule(module, dependencyModule, dependency.isOptional(), list);
                        continue;
                    }
                    if (dependency.isOptional()) continue;
                    String msg = String.format("Mandatory dependency [%s:%s] declared by module [%s] not found.", dependency.getModuleSymbolicName(), dependency.getVersion(), module.getSymbolicName());
                    module.addResolveError(new ResolveException(msg));
                    continue;
                }
                if (dependencyModules.length <= 0) continue;
                ModuleImpl dependencyModule = ModuleResolver.findLatestModuleVersion(dependencyModules);
                ModuleResolver.collectDependencyModule(module, dependencyModule, dependency.isOptional(), list);
                continue;
            }
            if (dependency.isOptional()) continue;
            String msg = String.format("Mandatory dependency [%s] declared by module [%s] not found.", dependency.getModuleSymbolicName(), module.getSymbolicName());
            module.addResolveError(new ResolveException(msg));
        }
    }

    private static void collectImpliciteModuleDependencies(ModuleImpl module, List<DependencyItem> list) {
        Extension[] extensions;
        for (Extension extension : extensions = module.getExtensions()) {
            ExtensionPoint extensionPoint = extension.getExtensionPoint();
            if (extensionPoint != null) {
                ModuleResolver.collectDependencyModule(module, (ModuleImpl)extensionPoint.getDeclaringModule(), true, list);
                continue;
            }
            String msg = String.format("Extension point [%s] used by module [%s] not found. Extension will be ignored.", extension.getPoint(), module.getSymbolicName());
            module.addResolveWarning(new ResolveException(msg));
        }
    }

    private static ModuleImpl findLatestModuleVersion(ModuleImpl[] modules) {
        ModuleImpl latestModule = modules[0];
        Version latestVersion = latestModule.getVersion();
        for (int i = 1; i < modules.length; ++i) {
            ModuleImpl module = modules[i];
            Version version = module.getVersion();
            if (version.compareTo(latestVersion) <= 0) continue;
            latestModule = module;
            latestVersion = version;
        }
        return latestModule;
    }

    private static Version[] getVersions(Module[] modules) {
        Version[] versions = new Version[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            versions[i] = modules[i].getVersion();
        }
        return versions;
    }

    private static ModuleImpl findBestMatchingModuleVersion(Version requiredVersion, ModuleImpl[] modules) {
        Version[] versions = ModuleResolver.getVersions(modules);
        for (int i = 0; i < modules.length; ++i) {
            ModuleImpl module = modules[i];
            if (versions[i].compareTo(requiredVersion) != 0) continue;
            return module;
        }
        ModuleImpl bestModule = ModuleResolver.findLatestModuleVersion(modules);
        Version bestVersion = bestModule.getVersion();
        for (int i = 0; i < modules.length; ++i) {
            ModuleImpl module = modules[i];
            Version version = versions[i];
            if (version.compareTo(requiredVersion) == 0) {
                bestModule = module;
                break;
            }
            if (version.compareTo(requiredVersion) <= 0 || version.compareTo(bestVersion) >= 0) continue;
            bestModule = module;
            bestVersion = version;
        }
        return bestModule;
    }

    private static String[] findDeclaredLibs(ModuleImpl module) {
        Dependency[] dependencies = module.getDeclaredDependencies();
        ArrayList<String> libNames = new ArrayList<String>(dependencies.length);
        for (Dependency dependency : dependencies) {
            if (dependency.getLibName() == null || libNames.contains(dependency.getLibName())) continue;
            libNames.add(dependency.getLibName());
        }
        return libNames.toArray(new String[0]);
    }

    private static void collectDependencyModule(ModuleImpl module, ModuleImpl dependencyModule, boolean optional, List<DependencyItem> dependencyItems) {
        if (dependencyModule == module) {
            return;
        }
        for (DependencyItem dependencyItem : dependencyItems) {
            if (dependencyModule != dependencyItem.module) continue;
            return;
        }
        dependencyItems.add(new DependencyItem(dependencyModule, optional));
    }

    private static void collectLibDependency(ModuleImpl module, File lib, List<URL> list) {
        try {
            URL url = ModuleResolver.convertToURL(lib);
            if (!list.contains(url)) {
                list.add(url);
            }
        }
        catch (MalformedURLException e) {
            String msg = String.format("Library file path [%s] used by module [%s] cannot be converted to an URL.", lib.getPath(), module.getSymbolicName());
            module.addResolveError(new ResolveException(msg, e));
        }
    }

    private static URL convertToURL(File lib) throws MalformedURLException {
        return lib.toURI().toURL();
    }

    static class DependencyItem {
        ModuleImpl module;
        boolean optional;

        public DependencyItem(ModuleImpl module, boolean optional) {
            this.module = module;
            this.optional = optional;
        }
    }
}

